/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import java.net.InetAddress;
import org.jacorb.orb.ParsedIOR;
import org.omg.CORBA.ORB;
import org.omg.IIOP.ProfileBody_1_1;
import org.omg.IOP.IOR;

public class IORdump {
    private String iorString = null;
    private String type_id = null;
    private String iiopVersion = null;
    private String host = null;
    private int port = -1;
    private String devname = null;

    public IORdump(String string, String string2) throws DevFailed {
        this.devname = string == null ? "unknown" : string;
        if (string2 == null) {
            DeviceProxy deviceProxy = new DeviceProxy(string);
            string2 = deviceProxy.get_ior();
        } else {
            this.iorString = string2;
        }
        if (string2 != null) {
            if (string2.equals("nada")) {
                string2 = null;
            } else {
                this.iorAnalysis(string2);
            }
        }
    }

    public IORdump(String string) throws DevFailed {
        this.devname = string;
        DeviceProxy deviceProxy = new DeviceProxy(string);
        this.iorString = deviceProxy.get_ior();
        if (this.iorString != null) {
            if (this.iorString.equals("nada")) {
                this.iorString = null;
            } else {
                this.iorAnalysis(this.iorString);
            }
        }
    }

    public String toString() {
        if (this.iorString == null) {
            return new String("No IOR found in database for " + this.devname + "\n" + "(Maybe, the device has never been exported...)");
        }
        return new String("Device:        " + this.devname + "\n" + "type_id:       " + this.get_type_id() + "\n" + "iiop_version:  " + this.get_iiop_version() + "\n" + "host:          " + this.get_host() + "\n" + "port:          " + this.get_port());
    }

    private void iorAnalysis(String string) throws DevFailed {
        ORB oRB = ApiUtil.get_orb();
        if (string == null) {
            return;
        }
        if (!string.startsWith("IOR:")) {
            return;
        }
        ParsedIOR parsedIOR = new ParsedIOR(string);
        IOR iOR = parsedIOR.getIOR();
        ProfileBody_1_1[] profileBody_1_1Array = parsedIOR.getProfileBodies();
        this.type_id = iOR.type_id;
        int n = 0;
        while (n < profileBody_1_1Array.length) {
            ProfileBody_1_1 profileBody_1_1 = profileBody_1_1Array[n];
            this.iiopVersion = new String(profileBody_1_1.iiop_version.major + "." + profileBody_1_1.iiop_version.minor);
            try {
                InetAddress inetAddress = InetAddress.getByName(profileBody_1_1.host);
                String string2 = inetAddress.getHostName();
                String string3 = inetAddress.getHostAddress();
                this.host = new String(string2 + " (" + string3 + ")");
            }
            catch (Exception exception) {
                this.host = new String(profileBody_1_1.host + " (" + exception + ")");
            }
            this.port = profileBody_1_1.port;
            if (this.port < 0) {
                this.port += 65536;
            }
            ++n;
        }
    }

    public String get_type_id() {
        return this.type_id;
    }

    public String get_host() {
        return this.host;
    }

    public int get_port() {
        return this.port;
    }

    public String get_iiop_version() {
        return this.iiopVersion;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(new IORdump(stringArray[0]).toString());
        }
        catch (DevFailed devFailed) {
            Except.print_exception(devFailed);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("Device name ?");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

