/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.AttributeConfig;
import fr.esrf.Tango.AttributeConfig_2;
import fr.esrf.Tango.AttributeValue;
import fr.esrf.Tango.DevAttrHistory;
import fr.esrf.Tango.DevCmdHistory;
import fr.esrf.Tango.DevCmdInfo;
import fr.esrf.Tango.DevCmdInfo_2;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.ApiDefs;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.Connection;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevExportInfo;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DbDevInfo;
import fr.esrf.TangoApi.DbDevice;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceDataHistory;
import fr.esrf.TangoApi.T2Ttypes;
import fr.esrf.TangoDs.Except;

public class DeviceProxy
extends Connection
implements ApiDefs {
    private DbDevice db_dev;
    private String[] attnames_array = null;

    public DeviceProxy(String string) throws DevFailed {
        super(string);
    }

    public DeviceProxy(String string, String string2) throws DevFailed {
        super(string, string2, 1);
    }

    public DeviceProxy(String string, String string2, String string3) throws DevFailed {
        super(string, string2, string3);
    }

    public String name() {
        return this.get_name();
    }

    public String status() throws DevFailed {
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        if (this.url.protocol == 0) {
            String string;
            try {
                string = this.device.status();
            }
            catch (Exception exception) {
                string = "Unknown";
                this.throw_dev_failed(exception, "DeviceProxy.status()", false);
            }
            return string;
        }
        return this.command_inout("DevStatus").extractString();
    }

    public DevState state() throws DevFailed {
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        if (this.url.protocol == 0) {
            DevState devState;
            try {
                devState = this.device.state();
            }
            catch (Exception exception) {
                devState = DevState.UNKNOWN;
                this.throw_dev_failed(exception, "DeviceProxy.state()", false);
            }
            return devState;
        }
        DeviceData deviceData = this.command_inout("DevState");
        short s = deviceData.extractShort();
        return T2Ttypes.tangoState(s);
    }

    public CommandInfo command_query(String string) throws DevFailed {
        CommandInfo commandInfo;
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        if (this.url.protocol == 0) {
            if (this.device_2 != null) {
                DevCmdInfo_2 devCmdInfo_2 = this.device_2.command_query_2(string);
                commandInfo = new CommandInfo(devCmdInfo_2);
            } else {
                DevCmdInfo devCmdInfo = this.device.command_query(string);
                commandInfo = new CommandInfo(devCmdInfo);
            }
        } else {
            commandInfo = this.taco_device.commandQuery(string);
        }
        return commandInfo;
    }

    public DbDevImportInfo import_device() throws DevFailed {
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        if (this.url.protocol == 0) {
            return this.db_dev.import_device();
        }
        return null;
    }

    public void export_device(DbDevExportInfo dbDevExportInfo) throws DevFailed {
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("export_device");
        this.db_dev.export_device(dbDevExportInfo);
    }

    public void add_device(DbDevInfo dbDevInfo) throws DevFailed {
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("add_device");
        this.db_dev.add_device(dbDevInfo);
    }

    public void delete_device() throws DevFailed {
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("delete_device");
        this.db_dev.delete_device();
    }

    public String[] get_property_list(String string) throws DevFailed {
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("get_property_list");
        return this.db_dev.get_property_list(string);
    }

    public DbDatum[] get_property(String[] stringArray) throws DevFailed {
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("get_property");
        return this.db_dev.get_property(stringArray);
    }

    public DbDatum get_property(String string) throws DevFailed {
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("get_property");
        return this.db_dev.get_property(string);
    }

    public DbDatum[] get_property(DbDatum[] dbDatumArray) throws DevFailed {
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("get_property");
        return this.db_dev.get_property(dbDatumArray);
    }

    public void put_property(DbDatum[] dbDatumArray) throws DevFailed {
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("put_property");
        this.db_dev.put_property(dbDatumArray);
    }

    public void delete_property(String[] stringArray) throws DevFailed {
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("delete_property");
        this.db_dev.delete_property(stringArray);
    }

    public void delete_property(String string) throws DevFailed {
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("delete_property");
        this.db_dev.delete_property(string);
    }

    public void delete_property(DbDatum[] dbDatumArray) throws DevFailed {
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("delete_property");
        this.db_dev.delete_property(dbDatumArray);
    }

    public String[] get_attribute_list() throws DevFailed {
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        if (this.url.protocol == 0) {
            String[] stringArray = new String[]{"All attributes"};
            AttributeInfo[] attributeInfoArray = this.get_attribute_config(stringArray);
            String[] stringArray2 = new String[attributeInfoArray.length];
            int n = 0;
            while (n < attributeInfoArray.length) {
                stringArray2[n] = attributeInfoArray[n].name;
                ++n;
            }
            return stringArray2;
        }
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        return this.taco_device.get_attribute_list();
    }

    public void put_attribute_property(DbAttribute[] dbAttributeArray) throws DevFailed {
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("put_attribute_property");
        this.db_dev.put_attribute_property(dbAttributeArray);
    }

    public void put_attribute_property(DbAttribute dbAttribute) throws DevFailed {
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("put_attribute_property");
        this.db_dev.put_attribute_property(dbAttribute);
    }

    public void delete_attribute_property(String string, String[] stringArray) throws DevFailed {
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("delete_attribute_property");
        this.db_dev.delete_attribute_property(string, stringArray);
    }

    public void delete_attribute_property(String string, String string2) throws DevFailed {
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("delete_attribute_property");
        this.db_dev.delete_attribute_property(string, string2);
    }

    public void delete_attribute_property(DbAttribute dbAttribute) throws DevFailed {
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("delete_attribute_property");
        this.db_dev.delete_attribute_property(dbAttribute);
    }

    public void delete_attribute_property(DbAttribute[] dbAttributeArray) throws DevFailed {
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("delete_attribute_property");
        this.db_dev.delete_attribute_property(dbAttributeArray);
    }

    public DbAttribute[] get_attribute_property(String[] stringArray) throws DevFailed {
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("get_attribute_property");
        return this.db_dev.get_attribute_property(stringArray);
    }

    public DbAttribute get_attribute_property(String string) throws DevFailed {
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("get_attribute_property");
        return this.db_dev.get_attribute_property(string);
    }

    public void delete_attribute(String string) throws DevFailed {
        if (this.db_dev == null) {
            this.db_dev = new DbDevice(this.devname, this.url.host, this.url.strport);
        }
        this.checkIfTango("delete_attribute");
        this.db_dev.delete_attribute(string);
    }

    public AttributeInfo[] get_attribute_info(String[] stringArray) throws DevFailed {
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        try {
            AttributeConfig[] attributeConfigArray = null;
            AttributeConfig_2[] attributeConfig_2Array = null;
            if (this.url.protocol == 0) {
                if (this.device_2 != null) {
                    attributeConfig_2Array = this.device_2.get_attribute_config_2(stringArray);
                } else {
                    attributeConfigArray = this.device.get_attribute_config(stringArray);
                }
            } else {
                attributeConfigArray = this.taco_device.get_attribute_config(stringArray);
            }
            int n = attributeConfig_2Array != null ? attributeConfig_2Array.length : attributeConfigArray.length;
            AttributeInfo[] attributeInfoArray = new AttributeInfo[n];
            int n2 = 0;
            while (n2 < n) {
                attributeInfoArray[n2] = attributeConfig_2Array != null ? new AttributeInfo(attributeConfig_2Array[n2]) : new AttributeInfo(attributeConfigArray[n2]);
                ++n2;
            }
            return attributeInfoArray;
        }
        catch (DevFailed devFailed) {
            throw devFailed;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.throw_dev_failed(exception, "get_attribute_config", true);
            return null;
        }
    }

    public AttributeInfo[] get_attribute_config(String[] stringArray) throws DevFailed {
        return this.get_attribute_info(stringArray);
    }

    public AttributeInfo get_attribute_info(String string) throws DevFailed {
        String[] stringArray = ApiUtil.toStringArray(string);
        AttributeInfo[] attributeInfoArray = this.get_attribute_config(stringArray);
        return attributeInfoArray[0];
    }

    public AttributeInfo get_attribute_config(String string) throws DevFailed {
        return this.get_attribute_info(string);
    }

    public AttributeInfo[] get_attribute_info() throws DevFailed {
        String[] stringArray = new String[]{"All attributes"};
        AttributeInfo[] attributeInfoArray = this.get_attribute_config(stringArray);
        return attributeInfoArray;
    }

    public AttributeInfo[] get_attribute_config() throws DevFailed {
        return this.get_attribute_info();
    }

    public void set_attribute_info(AttributeInfo[] attributeInfoArray) throws DevFailed {
        this.checkIfTango("set_attribute_config");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        try {
            AttributeConfig[] attributeConfigArray = new AttributeConfig[attributeInfoArray.length];
            int n = 0;
            while (n < attributeInfoArray.length) {
                attributeConfigArray[n] = attributeInfoArray[n].get_attribute_config_obj();
                ++n;
            }
            this.device.set_attribute_config(attributeConfigArray);
        }
        catch (DevFailed devFailed) {
            throw devFailed;
        }
        catch (Exception exception) {
            this.throw_dev_failed(exception, "set_attribute_info", true);
        }
    }

    public void set_attribute_config(AttributeInfo[] attributeInfoArray) throws DevFailed {
        this.set_attribute_info(attributeInfoArray);
    }

    public DeviceAttribute read_attribute(String string) throws DevFailed {
        String[] stringArray = ApiUtil.toStringArray(string);
        DeviceAttribute[] deviceAttributeArray = this.read_attribute(stringArray);
        return deviceAttributeArray[0];
    }

    public AttributeValue read_attribute_value(String string) throws DevFailed {
        this.checkIfTango("read_attribute_value");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        if (this.attnames_array == null) {
            this.attnames_array = new String[1];
        }
        this.attnames_array[0] = string;
        try {
            AttributeValue[] attributeValueArray = this.device_2 != null ? this.device_2.read_attributes_2(this.attnames_array, this.dev_src) : this.device.read_attributes(this.attnames_array);
            return attributeValueArray[0];
        }
        catch (DevFailed devFailed) {
            Except.re_throw_exception(devFailed, "TangoApi_CANNOT_READ_ATTRIBUTE", "Cannot read attribute:   " + string, "DeviceProxy.read_attribute()");
            return null;
        }
        catch (Exception exception) {
            this.throw_dev_failed(exception, "device.read_attributes()", false);
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public DeviceAttribute[] read_attribute(String[] var1_1) throws DevFailed {
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        if (this.url.protocol == 0) {
            try {
                var3_2 = this.device_2 != null ? this.device_2.read_attributes_2(var1_1, this.dev_src) : this.device.read_attributes(var1_1);
            }
            catch (DevFailed var4_3) {
                var5_5 = new StringBuffer(var1_1[0]);
                var6_7 = 1;
                ** while (var6_7 < var1_1.length)
            }
lbl-1000:
            // 1 sources

            {
                var5_5.append(", " + var1_1[var6_7]);
                ++var6_7;
                continue;
            }
lbl15:
            // 1 sources

            Except.re_throw_exception(var4_3, "TangoApi_CANNOT_READ_ATTRIBUTE", "Cannot read attribute(s):   " + var5_5.toString(), "DeviceProxy.read_attribute()");
            return null;
            catch (Exception var5_6) {
                this.throw_dev_failed(var5_6, "device.read_attributes()", false);
                return null;
            }
            var2_8 = new DeviceAttribute[var3_2.length];
            var4_4 = 0;
            while (var4_4 < var3_2.length) {
                var2_8[var4_4] = new DeviceAttribute(var3_2[var4_4]);
                ++var4_4;
            }
        } else {
            var2_8 = this.taco_device.read_attribute(var1_1);
        }
        return var2_8;
    }

    public void write_attribute(DeviceAttribute deviceAttribute) throws DevFailed {
        this.checkIfTango("write_attribute");
        try {
            DeviceAttribute[] deviceAttributeArray = new DeviceAttribute[]{deviceAttribute};
            this.write_attribute(deviceAttributeArray);
        }
        catch (DevFailed devFailed) {
            throw devFailed;
        }
        catch (Exception exception) {
            this.throw_dev_failed(exception, "device.write_attributes()", false);
        }
    }

    public void write_attribute(DeviceAttribute[] deviceAttributeArray) throws DevFailed {
        this.checkIfTango("write_attribute");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        AttributeValue[] attributeValueArray = new AttributeValue[deviceAttributeArray.length];
        int n = 0;
        while (n < deviceAttributeArray.length) {
            attributeValueArray[n] = deviceAttributeArray[n].getAttributeValueObject();
            ++n;
        }
        try {
            this.device.write_attributes(attributeValueArray);
        }
        catch (DevFailed devFailed) {
            throw devFailed;
        }
        catch (Exception exception) {
            this.throw_dev_failed(exception, "device.write_attributes()", false);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void poll_object(String var1_1, String var2_2, int var3_3) throws DevFailed {
        block6: {
            this.checkIfTango("poll_object");
            if (this.device == null && this.devname != null) {
                this.build_connection();
            }
            var4_4 = new DevVarLongStringArray();
            var4_4.lvalue = new int[1];
            var4_4.svalue = new String[3];
            var4_4.svalue[0] = this.devname;
            var4_4.svalue[1] = var2_2;
            var4_4.svalue[2] = var1_1;
            var4_4.lvalue[0] = var3_3;
            var5_5 = new DeviceProxy(this.device.adm_name());
            if (var5_5.get_idl_version() < 2) {
                Except.throw_exception("TangoApi_IDL_NOT_SUPPORTED", "Not supported by the IDL version used by device", "DeviceProxy.poll_object()");
            }
            var6_6 = new DeviceData();
            var6_6.insert(var4_4);
            try {
                var5_5.command_inout("AddObjPolling", var6_6);
                break block6;
            }
            catch (DevFailed var7_7) {
                var8_8 = 0;
                ** while (var8_8 < var7_7.errors.length)
            }
lbl-1000:
            // 1 sources

            {
                if (var7_7.errors[var8_8].reason.equals("API_AlreadyPolled")) {
                    var5_5.command_inout("UpdObjPollingPeriod", var6_6);
                    return;
                }
                ++var8_8;
                continue;
            }
lbl29:
            // 1 sources

            Except.re_throw_exception(var7_7, "TangoApi_CANNOT_POLL_OBJECT", "Cannot poll object " + var1_1, "DeviceProxy.poll_object()");
        }
    }

    public void poll_command(String string, int n) throws DevFailed {
        this.poll_object(string, "command", n);
    }

    public void poll_attribute(String string, int n) throws DevFailed {
        this.poll_object(string, "attribute", n);
    }

    private void remove_poll_object(String string, String string2) throws DevFailed {
        DeviceProxy deviceProxy;
        this.checkIfTango("remove_poll_object");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        if ((deviceProxy = new DeviceProxy(this.device.adm_name())).get_idl_version() < 2) {
            Except.throw_exception("TangoApi_IDL_NOT_SUPPORTED", "Not supported by the IDL version used by device", "DeviceProxy.remove_poll_object()");
        }
        DeviceData deviceData = new DeviceData();
        String[] stringArray = new String[]{this.devname, string2, string};
        deviceData.insert(stringArray);
        deviceProxy.command_inout("RemObjPolling", deviceData);
    }

    public void stop_poll_command(String string) throws DevFailed {
        this.remove_poll_object(string, "command");
    }

    public void stop_poll_attribute(String string) throws DevFailed {
        this.remove_poll_object(string, "attribute");
    }

    public String[] polling_status() throws DevFailed {
        DeviceProxy deviceProxy;
        this.checkIfTango("polling_status");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        if ((deviceProxy = new DeviceProxy(this.device.adm_name())).get_idl_version() < 2) {
            Except.throw_exception("TangoApi_IDL_NOT_SUPPORTED", "Not supported by the IDL version used by device", "DeviceProxy.polling_status()");
        }
        DeviceData deviceData = new DeviceData();
        deviceData.insert(this.devname);
        DeviceData deviceData2 = deviceProxy.command_inout("DevPollStatus", deviceData);
        String[] stringArray = deviceData2.extractStringArray();
        return stringArray;
    }

    public DeviceDataHistory[] command_history(String string, int n) throws DevFailed {
        this.checkIfTango("polled_devices");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        if (this.get_idl_version() < 2) {
            Except.throw_exception("TangoApi_IDL_NOT_SUPPORTED", "Not supported by the IDL version used by device", "DeviceProxy.command_history()");
        }
        DevCmdHistory[] devCmdHistoryArray = this.device_2.command_inout_history_2(string, n);
        DeviceDataHistory[] deviceDataHistoryArray = new DeviceDataHistory[devCmdHistoryArray.length];
        int n2 = 0;
        while (n2 < devCmdHistoryArray.length) {
            deviceDataHistoryArray[n2] = new DeviceDataHistory(string, devCmdHistoryArray[n2]);
            ++n2;
        }
        return deviceDataHistoryArray;
    }

    public DeviceDataHistory[] attribute_history(String string, int n) throws DevFailed {
        this.checkIfTango("polled_devices");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        if (this.get_idl_version() < 2) {
            Except.throw_exception("TangoApi_IDL_NOT_SUPPORTED", "Not supported by the IDL version used by device", "DeviceProxy.attribute_history()");
        }
        DevAttrHistory[] devAttrHistoryArray = this.device_2.read_attribute_history_2(string, n);
        DeviceDataHistory[] deviceDataHistoryArray = new DeviceDataHistory[devAttrHistoryArray.length];
        int n2 = 0;
        while (n2 < devAttrHistoryArray.length) {
            deviceDataHistoryArray[n2] = new DeviceDataHistory(devAttrHistoryArray[n2]);
            ++n2;
        }
        return deviceDataHistoryArray;
    }

    public String[] dev_inform() throws DevFailed {
        this.checkIfTaco("dev_inform");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        return this.taco_device.dev_inform();
    }

    public void dev_rpc_protocol(int n) throws DevFailed {
        this.checkIfTaco("dev_rpc_protocol");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        this.taco_device.dev_rpc_protocol(n);
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        try {
            string2 = stringArray[0];
            string = stringArray[1];
        }
        catch (Exception exception) {
            if (string2 == null) {
                System.out.println("Usage :");
                System.out.println("fr.esrf.TangoApi.DeviceProxy  cmdname devname");
                System.out.println("\t- cmdname : command name (ping, state, status...)");
                System.out.println("\t- devname : device name to send command.");
            } else {
                System.out.println("Device name ?");
            }
            System.exit(0);
        }
        try {
            DeviceProxy deviceProxy = new DeviceProxy(string);
            if (string2.equals("ping")) {
                deviceProxy.ping();
                System.out.println(string + " is alive");
            } else if (string2.equals("status")) {
                System.out.println(string + " - " + deviceProxy.status());
            } else if (string2.equals("state")) {
                String[] stringArray2 = new String[]{"ON", "OFF", "CLOSE", "OPEN", "INSERT", "EXTRACT", "MOVING", "STANDBY", "FAULT", "INIT", "RUNNING", "ALARM", "DISABLE", "UNKNOWN"};
                DevState devState = deviceProxy.state();
                int n = devState.value();
                System.out.println(string + " is " + stringArray2[n]);
            }
        }
        catch (DevFailed devFailed) {
            Except.print_exception(devFailed);
        }
    }
}

