/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.AttributeValue;
import fr.esrf.Tango.DevAttrHistory;
import fr.esrf.Tango.DevCmdHistory;
import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.TimeVal;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoDs.Except;

public class DeviceDataHistory
extends DeviceData {
    private DevCmdHistory cmd_histo;
    private AttributeValue attrval;
    private TimeVal tval;
    public static final int COMMAND = 0;
    public static final int ATTRIBUTE = 1;
    public int source = 0;
    public String name;
    public boolean failed;
    public DevError[] errors;

    public DeviceDataHistory(String string, DevCmdHistory devCmdHistory) throws DevFailed {
        super(devCmdHistory.value);
        this.cmd_histo = devCmdHistory;
        this.name = string;
        this.tval = devCmdHistory.time;
        this.failed = devCmdHistory.cmd_failed;
        this.errors = devCmdHistory.errors;
    }

    public DeviceDataHistory(DevAttrHistory devAttrHistory) throws DevFailed {
        super(devAttrHistory.value.value);
        this.attrval = devAttrHistory.value;
        this.name = devAttrHistory.value.name;
        this.tval = devAttrHistory.value.time;
        this.failed = devAttrHistory.attr_failed;
        this.errors = devAttrHistory.errors;
    }

    public TimeVal getTimeVal() {
        return this.tval;
    }

    public long getTimeValSec() {
        return this.tval.tv_sec;
    }

    public long getTime() {
        return (long)this.tval.tv_sec * 1000L + (long)(this.tval.tv_usec / 1000);
    }

    public AttributeValue getAttributeValueObject() throws DevFailed {
        if (this.source == 0) {
            Except.throw_exception("TangoApi_NOT_AVAILABLE", "Method not avalaible for command", "DeviceDataHistory.getAttributeValueObject()");
        }
        return this.attrval;
    }

    public AttrQuality getAttrQuality() throws DevFailed {
        if (this.source == 0) {
            Except.throw_exception("TangoApi_NOT_AVAILABLE", "Method not avalaible for command", "DeviceDataHistory.getAttrQuality()");
        }
        return this.attrval.quality;
    }

    public int getDimX() throws DevFailed {
        if (this.source == 0) {
            Except.throw_exception("TangoApi_NOT_AVAILABLE", "Method not avalaible for command", "DeviceDataHistory.getDimX()");
        }
        return this.attrval.dim_x;
    }

    public int getDimY() throws DevFailed {
        if (this.source == 0) {
            Except.throw_exception("TangoApi_NOT_AVAILABLE", "Method not avalaible for command", "DeviceDataHistory.getDimY()");
        }
        return this.attrval.dim_y;
    }
}

