/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.AttributeValue;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarDoubleArrayHelper;
import fr.esrf.Tango.DevVarLongArrayHelper;
import fr.esrf.Tango.DevVarShortArrayHelper;
import fr.esrf.Tango.DevVarStringArrayHelper;
import fr.esrf.Tango.TimeVal;
import fr.esrf.TangoApi.ApiUtil;

public class DeviceAttribute {
    private AttributeValue attrval;

    private void buildAttributeValueObject(String string) {
        this.attrval = new AttributeValue();
        this.attrval.name = string;
        this.attrval.quality = AttrQuality.ATTR_VALID;
        this.attrval.time = new TimeVal();
        this.attrval.dim_x = 1;
        this.attrval.dim_y = 0;
        try {
            this.attrval.value = ApiUtil.get_orb().create_any();
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        long l = System.currentTimeMillis();
        this.attrval.time.tv_sec = (int)(l / 1000L);
        this.attrval.time.tv_usec = (int)(l - (long)(this.attrval.time.tv_sec * 1000)) * 1000;
        this.attrval.time.tv_nsec = 0;
    }

    public DeviceAttribute(AttributeValue attributeValue) {
        this.attrval = attributeValue;
    }

    public DeviceAttribute(String string) {
        this.buildAttributeValueObject(string);
    }

    public DeviceAttribute(String string, int n, int n2) {
        this.buildAttributeValueObject(string);
    }

    public DeviceAttribute(String string, short s) {
        this.buildAttributeValueObject(string);
        this.insert(s);
    }

    public DeviceAttribute(String string, short[] sArray, int n, int n2) {
        this.buildAttributeValueObject(string);
        this.insert(sArray, n, n2);
    }

    public DeviceAttribute(String string, int n) {
        this.buildAttributeValueObject(string);
        this.insert(n);
    }

    public DeviceAttribute(String string, int[] nArray, int n, int n2) {
        this.buildAttributeValueObject(string);
        this.insert(nArray, n, n2);
    }

    public DeviceAttribute(String string, double d) {
        this.buildAttributeValueObject(string);
        this.insert(d);
    }

    public DeviceAttribute(String string, double[] dArray, int n, int n2) {
        this.buildAttributeValueObject(string);
        this.insert(dArray, n, n2);
    }

    public DeviceAttribute(String string, String string2) {
        this.buildAttributeValueObject(string);
        this.insert(string2);
    }

    public DeviceAttribute(String string, String[] stringArray, int n, int n2) {
        this.buildAttributeValueObject(string);
        this.insert(stringArray, n, n2);
    }

    public void setAttributeValue(AttributeValue attributeValue) {
        this.attrval = attributeValue;
    }

    public AttributeValue setAttributeValue() {
        return this.attrval;
    }

    public void insert(short s) {
        short[] sArray = new short[]{s};
        this.attrval.dim_x = 1;
        this.attrval.dim_y = 0;
        DevVarShortArrayHelper.insert(this.attrval.value, sArray);
    }

    public void insert(short[] sArray, int n, int n2) {
        this.attrval.dim_x = n;
        this.attrval.dim_y = n2;
        DevVarShortArrayHelper.insert(this.attrval.value, sArray);
    }

    public void insert(int n) {
        int[] nArray = new int[]{n};
        this.attrval.dim_x = 1;
        this.attrval.dim_y = 0;
        DevVarLongArrayHelper.insert(this.attrval.value, nArray);
    }

    public void insert(int[] nArray, int n, int n2) {
        this.attrval.dim_x = n;
        this.attrval.dim_y = n2;
        DevVarLongArrayHelper.insert(this.attrval.value, nArray);
    }

    public void insert(double d) {
        double[] dArray = new double[]{d};
        this.attrval.dim_x = 1;
        this.attrval.dim_y = 0;
        DevVarDoubleArrayHelper.insert(this.attrval.value, dArray);
    }

    public void insert(double[] dArray, int n, int n2) {
        this.attrval.dim_x = n;
        this.attrval.dim_y = n2;
        DevVarDoubleArrayHelper.insert(this.attrval.value, dArray);
    }

    public void insert(String string) {
        String[] stringArray = new String[]{string};
        this.attrval.dim_x = 1;
        this.attrval.dim_y = 0;
        DevVarStringArrayHelper.insert(this.attrval.value, stringArray);
    }

    public void insert(String[] stringArray, int n, int n2) {
        this.attrval.dim_x = n;
        this.attrval.dim_y = n2;
        DevVarStringArrayHelper.insert(this.attrval.value, stringArray);
    }

    public short extractShort() {
        short[] sArray = this.extractShortArray();
        return sArray[0];
    }

    public short[] extractShortArray() {
        return DevVarShortArrayHelper.extract(this.attrval.value);
    }

    public int extractLong() {
        int[] nArray = this.extractLongArray();
        return nArray[0];
    }

    public int[] extractLongArray() {
        return DevVarLongArrayHelper.extract(this.attrval.value);
    }

    public double extractDouble() {
        double[] dArray = this.extractDoubleArray();
        return dArray[0];
    }

    public double[] extractDoubleArray() {
        return DevVarDoubleArrayHelper.extract(this.attrval.value);
    }

    public String extractString() {
        String[] stringArray = this.extractStringArray();
        return stringArray[0];
    }

    public String[] extractStringArray() {
        return DevVarStringArrayHelper.extract(this.attrval.value);
    }

    public AttrQuality getQuality() {
        return this.attrval.quality;
    }

    public TimeVal getTimeVal() {
        return this.attrval.time;
    }

    public long getTimeValSec() {
        return this.attrval.time.tv_sec;
    }

    public long getTimeValMillisSec() {
        return (long)this.attrval.time.tv_sec * 1000L + (long)this.attrval.time.tv_usec / 1000L;
    }

    public String getName() {
        return this.attrval.name;
    }

    public int getDimX() {
        return this.attrval.dim_x;
    }

    public int getDimY() {
        return this.attrval.dim_y;
    }

    public AttributeValue getAttributeValueObject() {
        return this.attrval;
    }

    public long getTime() {
        return (long)this.attrval.time.tv_sec * 1000L + (long)(this.attrval.time.tv_usec / 1000);
    }
}

