/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Connection;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevExportInfo;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DbDevInfo;
import fr.esrf.TangoApi.DbServInfo;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;

public class Database
extends Connection {
    private static DeviceData argin;
    private static DeviceData argout;

    public Database() throws DevFailed {
        argin = new DeviceData(ApiUtil.get_orb());
        argout = new DeviceData(ApiUtil.get_orb());
    }

    public Database(String string, String string2) throws DevFailed {
        super(string, string2);
        argin = new DeviceData(ApiUtil.get_orb());
        argout = new DeviceData(ApiUtil.get_orb());
    }

    private String stringArray2String(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            if (n < stringArray.length - 1) {
                stringBuffer.append("\n");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String get_info() throws DevFailed {
        argout = this.command_inout("DbInfo", argin);
        String[] stringArray = argout.extractStringArray();
        return this.stringArray2String(stringArray);
    }

    public String[] get_host_list() throws DevFailed {
        argin.insert("*");
        argout = this.command_inout("DbGetHostList", argin);
        return argout.extractStringArray();
    }

    public String[] get_host_list(String string) throws DevFailed {
        argin.insert(string);
        argout = this.command_inout("DbGetHostList", argin);
        return argout.extractStringArray();
    }

    public String[] get_server_class_list(String string) throws DevFailed {
        argin.insert(string);
        argout = this.command_inout("DbGetDeviceServerClassList", argin);
        String[] stringArray = argout.extractStringArray();
        String[] stringArray2 = new String[stringArray.length - 1];
        int n = 0;
        int n2 = 0;
        while (n < stringArray.length) {
            if (!stringArray[n].equals("DServer")) {
                stringArray2[n2++] = stringArray[n];
            }
            ++n;
        }
        return stringArray2;
    }

    public String[] get_server_list() throws DevFailed {
        argin.insert("*");
        argout = this.command_inout("DbGetServerList", argin);
        return argout.extractStringArray();
    }

    public String[] get_server_list(String string) throws DevFailed {
        argin.insert(string);
        argout = this.command_inout("DbGetServerList", argin);
        return argout.extractStringArray();
    }

    public String[] get_host_server_list(String string) throws DevFailed {
        argin.insert(string);
        argout = this.command_inout("DbGetHostServerList", argin);
        return argout.extractStringArray();
    }

    public DbServInfo get_server_info(String string) throws DevFailed {
        argin.insert(string);
        argout = this.command_inout("DbGetServerInfo", argin);
        String[] stringArray = argout.extractStringArray();
        return new DbServInfo(stringArray);
    }

    public void put_server_info(DbServInfo dbServInfo) throws DevFailed {
        String[] stringArray = new String[]{dbServInfo.name, dbServInfo.host, dbServInfo.controlled ? "1" : "0", new String("" + dbServInfo.startup_level)};
        argin.insert(stringArray);
        this.command_inout("DbPutServerInfo", argin);
    }

    public void add_device(DbDevInfo dbDevInfo) throws DevFailed {
        argin.insert(dbDevInfo.toStringArray());
        this.command_inout("DbAddDevice", argin);
    }

    public void add_device(String string, String string2, String string3) throws DevFailed {
        DbDevInfo dbDevInfo = new DbDevInfo(string, string2, string3);
        argin.insert(dbDevInfo.toStringArray());
        this.command_inout("DbAddDevice", argin);
    }

    public void delete_device(String string) throws DevFailed {
        boolean bl = true;
        try {
            DeviceProxy deviceProxy = new DeviceProxy(string);
            deviceProxy.ping();
            bl = false;
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        if (bl) {
            argin.insert(string);
            this.command_inout("DbDeleteDevice", argin);
        } else {
            Except.throw_exception("TangoApi_DEVICE_ALIVE", "Cannot delete a device which is ALIVE.", "delete_device()");
        }
    }

    public DbDevImportInfo import_device(String string) throws DevFailed {
        argin.insert(string);
        argout = this.command_inout("DbImportDevice", argin);
        DevVarLongStringArray devVarLongStringArray = argout.extractLongStringArray();
        return new DbDevImportInfo(devVarLongStringArray);
    }

    public void unexport_device(String string) throws DevFailed {
        argin.insert(string);
        this.command_inout("DbUnExportDevice", argin);
    }

    public void export_device(DbDevExportInfo dbDevExportInfo) throws DevFailed {
        String[] stringArray = dbDevExportInfo.toStringArray();
        argin.insert(stringArray);
        this.command_inout("DbExportDevice", argin);
    }

    public String[] get_device_class_list(String string) throws DevFailed {
        argin.insert(string);
        argout = this.command_inout("DbGetDeviceClassList", argin);
        return argout.extractStringArray();
    }

    public String[] get_device_name(String string, String string2) throws DevFailed {
        String[] stringArray = new String[]{string, string2};
        argin.insert(stringArray);
        argout = this.command_inout("DbGetDeviceList", argin);
        return argout.extractStringArray();
    }

    public String[] get_device_alias(String string) throws DevFailed {
        argin.insert(string);
        argout = this.command_inout("DbGetDeviceAliasList", argin);
        return argout.extractStringArray();
    }

    public String[] get_device_domain(String string) throws DevFailed {
        argin.insert(string);
        argout = this.command_inout("DbGetDeviceDomainList", argin);
        return argout.extractStringArray();
    }

    public String[] get_device_family(String string) throws DevFailed {
        argin.insert(string);
        argout = this.command_inout("DbGetDeviceFamilyList", argin);
        return argout.extractStringArray();
    }

    public String[] get_device_member(String string) throws DevFailed {
        argin.insert(string);
        argout = this.command_inout("DbGetDeviceMemberList", argin);
        return argout.extractStringArray();
    }

    public void add_server(String string, DbDevInfo[] dbDevInfoArray) throws DevFailed {
        String[] stringArray = new String[1 + 2 * dbDevInfoArray.length];
        stringArray[0] = string;
        int n = 0;
        while (n < dbDevInfoArray.length) {
            stringArray[2 * n + 1] = dbDevInfoArray[n].name;
            stringArray[2 * n + 2] = dbDevInfoArray[n]._class;
            ++n;
        }
        argin.insert(stringArray);
        this.command_inout("DbAddServer", argin);
    }

    public void delete_server(String string) throws DevFailed {
        argin.insert(string);
        this.command_inout("DbDeleteServer", argin);
    }

    public void export_server(String string, DbDevExportInfo[] dbDevExportInfoArray) throws DevFailed {
        String[] stringArray = new String[6 * dbDevExportInfoArray.length];
        int n = 0;
        while (n < dbDevExportInfoArray.length) {
            String[] stringArray2 = dbDevExportInfoArray[n].toStringArray();
            int n2 = 0;
            while (n2 < 6) {
                stringArray[6 * n + n2] = new String(stringArray2[n2]);
                ++n2;
            }
            ++n;
        }
        argin.insert(stringArray);
        this.command_inout("DbExportServer", argin);
    }

    public void unexport_server(String string) throws DevFailed {
        argin.insert(string);
        this.command_inout("DbUnExportServer", argin);
    }

    private String[] dbdatum2StringArray(String string, DbDatum[] dbDatumArray) {
        int n = 2;
        int n2 = 0;
        while (n2 < dbDatumArray.length) {
            n += 2;
            n += dbDatumArray[n2].size();
            ++n2;
        }
        String[] stringArray = new String[n];
        stringArray[0] = string;
        stringArray[1] = String.valueOf(dbDatumArray.length);
        int n3 = 0;
        int n4 = 2;
        while (n3 < dbDatumArray.length) {
            String[] stringArray2 = dbDatumArray[n3].toStringArray();
            int n5 = 0;
            while (n5 < stringArray2.length) {
                stringArray[n4++] = stringArray2[n5];
                ++n5;
            }
            ++n3;
        }
        return stringArray;
    }

    private String[] dbdatum2StringArray(String string, String string2, DbDatum[] dbDatumArray) {
        int n = 4;
        int n2 = 0;
        while (n2 < dbDatumArray.length) {
            n += 2;
            n += dbDatumArray[n2].size();
            ++n2;
        }
        String[] stringArray = new String[n];
        int n3 = 0;
        stringArray[n3++] = string;
        stringArray[n3++] = "1";
        stringArray[n3++] = string2;
        stringArray[n3++] = String.valueOf(dbDatumArray.length);
        int n4 = 0;
        int n5 = n3;
        while (n4 < dbDatumArray.length) {
            String[] stringArray2 = dbDatumArray[n4].toStringArray();
            int n6 = 0;
            while (n6 < stringArray2.length) {
                stringArray[n5++] = stringArray2[n6];
                ++n6;
            }
            ++n4;
        }
        return stringArray;
    }

    private DbDatum[] stringArray2DbDatum(String[] stringArray) {
        int n = Integer.parseInt(stringArray[1]);
        DbDatum[] dbDatumArray = new DbDatum[n];
        int n2 = 2;
        int n3 = 0;
        while (n2 < stringArray.length - 1) {
            int n4 = Integer.parseInt(stringArray[n2 + 1]);
            int n5 = n2 + 2;
            int n6 = n2 + 2 + n4;
            if (n4 > 0) {
                dbDatumArray[n3++] = new DbDatum(stringArray[n2], stringArray, n5, n6);
            } else {
                String string;
                dbDatumArray[n3++] = new DbDatum(stringArray[n2]);
                if (n5 + 1 < stringArray.length && ((string = stringArray[n5]).length() == 0 || string.equals(" "))) {
                    n6 = n5 + 1;
                }
            }
            n2 = n6;
        }
        return dbDatumArray;
    }

    private DbDatum[] get_obj_property(String string, String string2, DbDatum[] dbDatumArray) throws DevFailed {
        String[] stringArray = new String[dbDatumArray.length];
        int n = 0;
        while (n < dbDatumArray.length) {
            stringArray[n] = dbDatumArray[n].name;
            ++n;
        }
        return this.get_obj_property(string, string2, stringArray);
    }

    private DbDatum get_obj_property(String string, String string2, String string3) throws DevFailed {
        String[] stringArray = new String[]{string3};
        DbDatum[] dbDatumArray = this.get_obj_property(string, string2, stringArray);
        return dbDatumArray[0];
    }

    private DbDatum[] get_obj_property(String string, String string2, String[] stringArray) throws DevFailed {
        String[] stringArray2 = new String[1 + stringArray.length];
        stringArray2[0] = string;
        int n = 1;
        while (n < stringArray.length + 1) {
            stringArray2[n] = stringArray[n - 1];
            ++n;
        }
        String string3 = new String("DbGet" + string2 + "Property");
        argin.insert(stringArray2);
        argout = this.command_inout(string3, argin);
        String[] stringArray3 = argout.extractStringArray();
        return this.stringArray2DbDatum(stringArray3);
    }

    private void delete_obj_property(String string, String string2, DbDatum[] dbDatumArray) throws DevFailed {
        String[] stringArray = new String[dbDatumArray.length];
        int n = 0;
        while (n < dbDatumArray.length) {
            stringArray[n] = dbDatumArray[n].name;
            ++n;
        }
        this.delete_obj_property(string, string2, stringArray);
    }

    private void delete_obj_property(String string, String string2, String string3) throws DevFailed {
        String[] stringArray = new String[]{string3};
        this.delete_obj_property(string, string2, stringArray);
    }

    private void delete_obj_property(String string, String string2, String[] stringArray) throws DevFailed {
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = string;
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n + 1] = stringArray[n];
            ++n;
        }
        String string3 = new String("DbDelete" + string2 + "Property");
        argin.insert(stringArray2);
        this.command_inout(string3, argin);
    }

    public String[] get_object_list(String string) throws DevFailed {
        argin.insert(string);
        argout = this.command_inout("DbGetObjectList", argin);
        return argout.extractStringArray();
    }

    public String[] get_object_property_list(String string, String string2) throws DevFailed {
        String[] stringArray = new String[]{string, string2};
        argin.insert(stringArray);
        argout = this.command_inout("DbGetPropertyList", argin);
        return argout.extractStringArray();
    }

    public DbDatum[] get_property(String string, String[] stringArray) throws DevFailed {
        String string2 = "";
        return this.get_obj_property(string, string2, stringArray);
    }

    public DbDatum get_property(String string, String string2) throws DevFailed {
        String string3 = "";
        return this.get_obj_property(string, string3, string2);
    }

    public DbDatum[] get_property(String string, DbDatum[] dbDatumArray) throws DevFailed {
        String string2 = "";
        return this.get_obj_property(string, string2, dbDatumArray);
    }

    public void put_property(String string, DbDatum[] dbDatumArray) throws DevFailed {
        String[] stringArray = this.dbdatum2StringArray(string, dbDatumArray);
        argin.insert(stringArray);
        this.command_inout("DbPutProperty", argin);
    }

    public void delete_property(String string, String[] stringArray) throws DevFailed {
        String string2 = "";
        this.delete_obj_property(string, string2, stringArray);
    }

    public void delete_property(String string, String string2) throws DevFailed {
        String string3 = "";
        this.delete_obj_property(string, string3, string2);
    }

    public void delete_property(String string, DbDatum[] dbDatumArray) throws DevFailed {
        String string2 = "";
        this.delete_obj_property(string, string2, dbDatumArray);
    }

    public String[] get_class_property_list(String string, String string2) throws DevFailed {
        String[] stringArray = new String[]{string, string2};
        argin.insert(string);
        argout = this.command_inout("DbGetClassPropertyList", argin);
        return argout.extractStringArray();
    }

    public String[] get_device_property_list(String string, String string2) throws DevFailed {
        String[] stringArray = new String[]{string, string2};
        argin.insert(stringArray);
        argout = this.command_inout("DbGetDevicePropertyList", argin);
        return argout.extractStringArray();
    }

    public DbDatum[] get_device_property(String string, String[] stringArray) throws DevFailed {
        String string2 = "Device";
        return this.get_obj_property(string, string2, stringArray);
    }

    public DbDatum get_device_property(String string, String string2) throws DevFailed {
        String string3 = "Device";
        return this.get_obj_property(string, string3, string2);
    }

    public DbDatum[] get_device_property(String string, DbDatum[] dbDatumArray) throws DevFailed {
        String string2 = "Device";
        return this.get_obj_property(string, string2, dbDatumArray);
    }

    public void put_device_property(String string, DbDatum[] dbDatumArray) throws DevFailed {
        String[] stringArray = this.dbdatum2StringArray(string, dbDatumArray);
        argin.insert(stringArray);
        this.command_inout("DbPutDeviceProperty", argin);
    }

    public void delete_device_property(String string, String[] stringArray) throws DevFailed {
        String string2 = "Device";
        this.delete_obj_property(string, string2, stringArray);
    }

    public void delete_device_property(String string, String string2) throws DevFailed {
        String string3 = "Device";
        this.delete_obj_property(string, string3, string2);
    }

    public void delete_device_property(String string, DbDatum[] dbDatumArray) throws DevFailed {
        String string2 = "Device";
        this.delete_obj_property(string, string2, dbDatumArray);
    }

    public DbAttribute[] get_device_attribute_property(String string, String[] stringArray) throws DevFailed {
        argin.insert(ApiUtil.toStringArray(string, stringArray));
        argout = this.command_inout("DbGetDeviceAttributeProperty", argin);
        return ApiUtil.toDbAttributeArray(argout.extractStringArray());
    }

    public DbAttribute get_device_attribute_property(String string, String string2) throws DevFailed {
        argin.insert(ApiUtil.toStringArray(string, string2));
        argout = this.command_inout("DbGetDeviceAttributeProperty", argin);
        DbAttribute[] dbAttributeArray = ApiUtil.toDbAttributeArray(argout.extractStringArray());
        return dbAttributeArray[0];
    }

    public void put_device_attribute_property(String string, DbAttribute[] dbAttributeArray) throws DevFailed {
        argin.insert(ApiUtil.toStringArray(string, dbAttributeArray));
        this.command_inout("DbPutDeviceAttributeProperty", argin);
    }

    public void put_device_attribute_property(String string, DbAttribute dbAttribute) throws DevFailed {
        argin.insert(ApiUtil.toStringArray(string, dbAttribute));
        this.command_inout("DbPutDeviceAttributeProperty", argin);
    }

    public void delete_device_attribute_property(String string, DbAttribute dbAttribute) throws DevFailed {
        DbAttribute[] dbAttributeArray = new DbAttribute[]{dbAttribute};
        this.delete_device_attribute_property(string, dbAttributeArray);
    }

    public void delete_device_attribute_property(String string, DbAttribute[] dbAttributeArray) throws DevFailed {
        String[] stringArray = ApiUtil.toStringArray(string, dbAttributeArray);
        argin.insert(stringArray);
        this.command_inout("DbDeleteDeviceAttributeProperty", argin);
    }

    public void delete_device_attribute_property(String string, String string2, String[] stringArray) throws DevFailed {
        DbAttribute[] dbAttributeArray = new DbAttribute[1 + stringArray.length];
        dbAttributeArray[0] = new DbAttribute(string2);
        int n = 0;
        while (n < stringArray.length) {
            dbAttributeArray[n + 1].add(stringArray[n]);
            ++n;
        }
        this.delete_device_attribute_property(string, dbAttributeArray);
    }

    public void delete_device_attribute_property(String string, String string2, String string3) throws DevFailed {
        DbAttribute[] dbAttributeArray = new DbAttribute[]{new DbAttribute(string2)};
        dbAttributeArray[0].add(string3);
        this.delete_device_attribute_property(string, dbAttributeArray);
    }

    public void delete_device_attribute(String string, String string2) throws DevFailed {
        String[] stringArray = new String[]{string, string2};
        argin.insert(stringArray);
        this.command_inout("DbDeleteDeviceAttribute", argin);
    }

    public String[] get_class_list(String string) throws DevFailed {
        argin.insert(string);
        argout = this.command_inout("DbGetClassList", argin);
        return argout.extractStringArray();
    }

    public DbDatum[] get_class_property(String string, String[] stringArray) throws DevFailed {
        String string2 = "Class";
        return this.get_obj_property(string, string2, stringArray);
    }

    public DbDatum get_class_property(String string, String string2) throws DevFailed {
        String string3 = "Class";
        return this.get_obj_property(string, string3, string2);
    }

    public DbDatum[] get_class_property(String string, DbDatum[] dbDatumArray) throws DevFailed {
        String string2 = "Class";
        return this.get_obj_property(string, string2, dbDatumArray);
    }

    public void put_class_property(String string, DbDatum[] dbDatumArray) throws DevFailed {
        String[] stringArray = this.dbdatum2StringArray(string, dbDatumArray);
        argin.insert(stringArray);
        this.command_inout("DbPutClassProperty", argin);
    }

    public void delete_class_property(String string, String[] stringArray) throws DevFailed {
        String string2 = "Class";
        this.delete_obj_property(string, string2, stringArray);
    }

    public void delete_class_property(String string, String string2) throws DevFailed {
        String string3 = "Class";
        this.delete_obj_property(string, string3, string2);
    }

    public void delete_class_property(String string, DbDatum[] dbDatumArray) throws DevFailed {
        String string2 = "Class";
        this.delete_obj_property(string, string2, dbDatumArray);
    }

    public String[] get_class_attribute_list(String string, String string2) throws DevFailed {
        argin.insert(ApiUtil.toStringArray(string, string2));
        argout = this.command_inout("DbGetClassAttributeList", argin);
        return argout.extractStringArray();
    }

    public DbAttribute get_class_attribute_property(String string, String string2) throws DevFailed {
        argin.insert(ApiUtil.toStringArray(string, string2));
        argout = this.command_inout("DbGetClassAttributeProperty", argin);
        DbAttribute[] dbAttributeArray = ApiUtil.toDbAttributeArray(argout.extractStringArray());
        return dbAttributeArray[0];
    }

    public DbAttribute[] get_class_attribute_property(String string, String[] stringArray) throws DevFailed {
        argin.insert(ApiUtil.toStringArray(string, stringArray));
        argout = this.command_inout("DbGetClassAttributeProperty", argin);
        return ApiUtil.toDbAttributeArray(argout.extractStringArray());
    }

    public void put_class_attribute_property(String string, DbAttribute[] dbAttributeArray) throws DevFailed {
        argin.insert(ApiUtil.toStringArray(string, dbAttributeArray));
        this.command_inout("DbPutClassAttributeProperty", argin);
    }

    public void put_class_attribute_property(String string, DbAttribute dbAttribute) throws DevFailed {
        argin.insert(ApiUtil.toStringArray(string, dbAttribute));
        this.command_inout("DbPutClassAttributeProperty", argin);
    }

    public void delete_class_attribute_property(String string, String[] stringArray) throws DevFailed {
        String string2 = "ClassAttribute";
        this.delete_obj_property(string, string2, stringArray);
    }

    public void delete_class_attribute_property(String string, String string2) throws DevFailed {
        String string3 = "ClassAttribute";
        this.delete_obj_property(string, string3, string2);
    }
}

