/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevCmdInfo;
import fr.esrf.Tango.DevCmdInfo_2;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevInfo;
import fr.esrf.Tango.DevSource;
import fr.esrf.Tango.Device;
import fr.esrf.Tango.DeviceHelper;
import fr.esrf.Tango.Device_2;
import fr.esrf.Tango.Device_2Helper;
import fr.esrf.TangoApi.ApiDefs;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbClass;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.TacoDevice;
import fr.esrf.TangoApi.TangoUrl;
import fr.esrf.TangoDs.Except;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;

public class Connection
implements ApiDefs {
    protected int idl_version = 1;
    protected Device device = null;
    protected Device_2 device_2 = null;
    protected TacoDevice taco_device = null;
    private Object obj = null;
    private int dev_timeout = 0;
    protected String devname = null;
    private boolean already_connected = false;
    private boolean device_is_dbase;
    private String ior = null;
    protected TangoUrl url;
    protected DevSource dev_src = DevSource.CACHE_DEV;
    protected boolean transparent_reconnection = true;

    public Device get_device() {
        return this.device;
    }

    private String buildUrlName(String string, String string2) {
        return new String("tango://" + string + ":" + string2);
    }

    private String buildUrlName(String string, String string2, String string3) {
        return new String("tango://" + string + ":" + string2 + "/" + string3);
    }

    protected Connection() throws DevFailed {
        this.url = new TangoUrl();
        ApiUtil.get_orb();
        this.dev_timeout = ApiUtil.timeout;
        this.connect_to_dbase();
        this.devname = this.device.name();
        this.already_connected = true;
        this.device_is_dbase = true;
    }

    protected Connection(String string, String string2) throws DevFailed {
        this.url = new TangoUrl(this.buildUrlName(string, string2));
        ApiUtil.get_orb();
        this.dev_timeout = ApiUtil.timeout;
        this.connect_to_dbase();
        this.devname = this.device.name();
        this.already_connected = true;
        this.device_is_dbase = true;
    }

    protected Connection(String string) throws DevFailed {
        this.url = new TangoUrl(string);
        this.device_is_dbase = false;
        this.devname = this.url.devname;
        if (this.url.protocol == 0 && this.url.use_db) {
            this.ior = this.get_exported_ior();
        }
    }

    protected Connection(String string, String string2, int n) throws DevFailed {
        this.devname = string;
        this.device_is_dbase = false;
        if (n == 1) {
            this.ior = string2;
        } else {
            String string3 = "TangoApi_INVALID_ARGS";
            String string4 = new String("Invalid argument");
            String string5 = new String("Connection.Connemction()");
            Except.throw_exception(string3, string4, string5);
        }
    }

    protected Connection(String string, String string2, String string3) throws DevFailed {
        this.url = new TangoUrl(this.buildUrlName(string2, string3, string));
        this.devname = this.url.devname;
        this.device_is_dbase = false;
        if (this.url.protocol == 0) {
            this.ior = this.get_exported_ior();
        }
    }

    protected void build_connection() throws DevFailed {
        if (this.device_is_dbase) {
            this.connect_to_dbase();
        } else {
            try {
                if (this.url.protocol == 0) {
                    if (this.url.use_db) {
                        this.dev_import();
                    } else {
                        this.dev_import_without_dbase();
                    }
                } else {
                    this.taco_device = new TacoDevice(this.devname);
                }
            }
            catch (DevFailed devFailed) {
                this.ior = null;
                String string = "TangoApi_CANNOT_IMPORT_DEVICE";
                String string2 = new String("Cannot import " + this.devname);
                String string3 = new String("Connection.build_connection(" + this.devname + ")");
                Except.re_throw_exception(devFailed, string, string2, string3);
            }
        }
    }

    private void createDevice(String string) throws DevFailed {
        ORB oRB = ApiUtil.get_orb();
        this.dev_timeout = ApiUtil.timeout;
        this.obj = oRB.string_to_object(string);
        if (this.obj._is_a("IDL:Tango/Device_2:1.0")) {
            this.device_2 = Device_2Helper.narrow(this.obj);
            this.idl_version = 2;
        } else if (!this.obj._is_a("IDL:Tango/Device:1.0")) {
            Except.throw_exception("TangoApi_DEVICE_IDL_UNKNOWN", this.devname + " has an IDL revision not suported !", "Connection.createDevice(" + this.devname + ")");
        }
        this.device = DeviceHelper.narrow(this.obj);
    }

    public String get_ior() throws DevFailed {
        Database database = this.url.host == null ? ApiUtil.get_db_obj() : ApiUtil.get_db_obj(this.url.host, this.url.strport);
        DbDevImportInfo dbDevImportInfo = database.import_device(this.devname);
        return dbDevImportInfo.ior;
    }

    private String get_exported_ior() throws DevFailed {
        Database database = this.url.host == null ? ApiUtil.get_db_obj() : ApiUtil.get_db_obj(this.url.host, this.url.strport);
        DbDevImportInfo dbDevImportInfo = database.import_device(this.devname);
        String string = null;
        if (dbDevImportInfo.exported) {
            string = dbDevImportInfo.ior;
        }
        return string;
    }

    protected void dev_import() throws DevFailed {
        java.lang.Object object;
        String string = null;
        Database database = this.url.host == null ? ApiUtil.get_db_obj() : ApiUtil.get_db_obj(this.url.host, this.url.strport);
        if (this.ior == null) {
            object = database.import_device(this.devname);
            if (!((DbDevImportInfo)object).exported) {
                Except.throw_exception("TangoApi_DEVICE_NOT_EXPORTED", this.devname + " Not Exported !", "Connection(" + this.devname + ")");
            }
            string = ((DbDevImportInfo)object).ior;
        } else {
            string = this.ior;
        }
        try {
            this.createDevice(string);
            if (this.dev_timeout == 0) {
                try {
                    object = new DbClass("TangoDevice");
                    DbDatum dbDatum = ((DbClass)object).get_property("DefaultTimeout");
                    this.dev_timeout = 2000;
                    if (!dbDatum.is_empty()) {
                        this.dev_timeout = dbDatum.extractLong();
                    }
                }
                catch (DevFailed devFailed) {
                    this.dev_timeout = 2000;
                }
            }
            this.set_timeout_millis(this.dev_timeout);
            this.device.ping();
            this.already_connected = true;
        }
        catch (Exception exception) {
            this.device = null;
            this.ior = null;
            String string2 = "TangoApi_CANNOT_IMPORT_DEVICE";
            String string3 = this.already_connected ? "Re-" : "";
            String string4 = new String("Cannot " + string3 + "import " + this.devname + " :\n\t" + exception.toString());
            String string5 = new String("Connection.dev_import(" + this.devname + ")");
            Except.throw_exception(string2, string4, string5);
        }
    }

    private void connect_to_dbase() throws DevFailed {
        if (this.device == null) {
            try {
                String string = new String("corbaloc:iiop:" + this.url.host + ":" + this.url.strport + "/database");
                this.createDevice(string);
            }
            catch (SystemException systemException) {
                systemException.printStackTrace();
                this.device = null;
                this.ior = null;
                Except.throw_exception("TangoApi_DATABASE_CONNECTION_FAILED", "Connection to database failed  !\n" + systemException, "connect_to_dbase(" + this.url.host + "," + this.url.strport + ")");
            }
        }
    }

    private void dev_import_without_dbase() throws DevFailed {
        if (this.device == null) {
            try {
                String string = new String("corbaloc:iiop:" + this.url.host + ":" + this.url.strport + "/" + this.devname);
                this.createDevice(string);
            }
            catch (SystemException systemException) {
                this.device = null;
                this.ior = null;
                Except.throw_exception("TangoApi_DEVICE_CONNECTION_FAILED", "Connection to device without database failed  !\n" + systemException, "Connection.dev_import_without_dbase(" + this.url.host + "," + this.url.strport + ")");
            }
        }
    }

    private Object build_obj_for_timout(int n) throws DevFailed {
        return this.obj;
    }

    public void set_timeout_millis(int n) throws DevFailed {
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        if (this.url.protocol == 1) {
            this.taco_device.set_rpc_timeout(n);
            return;
        }
        Object object = this.build_obj_for_timout(n);
        if (this.device_2 != null) {
            this.device_2 = Device_2Helper.narrow(object);
        }
        this.device = DeviceHelper.narrow(object);
    }

    public int get_timeout() {
        return this.dev_timeout;
    }

    public int get_timeout_millis() throws DevFailed {
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        if (this.url.protocol == 1) {
            return this.taco_device.get_rpc_timeout();
        }
        return this.dev_timeout;
    }

    protected void throw_dev_failed(Exception exception, String string, boolean bl) throws DevFailed {
        String string2;
        String string3;
        String string4 = string3 = bl ? new String(this.devname + ".command_inout(" + string + ")") : new String(this.devname + "." + string + ")");
        if (exception.toString().indexOf("org.omg.CORBA.NO_RESPONSE") >= 0 || exception.toString().indexOf("org.omg.CORBA.IMP_LIMIT") >= 0) {
            string2 = new String("Device (" + this.devname + ") timed out (>" + this.dev_timeout + " ms)!");
        } else if (exception.toString().indexOf("org.omg.CORBA.TRANSIENT") >= 0 || exception.toString().indexOf("org.omg.CORBA.UNKNOWN") >= 0 || exception.toString().indexOf("org.omg.CORBA.COMM_FAILURE") >= 0 || exception.toString().indexOf("org.omg.CORBA.OBJECT_NOT_EXIST") >= 0) {
            string2 = new String("Lost Connection during command : " + string);
            this.device = null;
            this.ior = null;
        } else {
            System.out.println("API has cached an exception: " + exception);
            string2 = new String(exception.getMessage());
            exception.printStackTrace();
        }
        Except.throw_exception(new String(exception.toString()), string2, string3);
    }

    public DeviceData command_inout(String string, DeviceData deviceData) throws DevFailed {
        java.lang.Object var3_3 = null;
        Any any = null;
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        if (this.url.protocol == 1) {
            return this.taco_device.command_inout(string, deviceData);
        }
        boolean bl = false;
        int n = 0;
        while (n < 2 && !bl && this.transparent_reconnection) {
            try {
                any = this.device.command_inout(string, deviceData.extractAny());
                bl = true;
            }
            catch (DevFailed devFailed) {
                String string2 = "TangoApi_CANNOT_EXECUTE_COMMAND";
                String string3 = new String("Cannot execute command " + string + " on " + this.devname);
                String string4 = new String("Connection.command_inout()");
                Except.re_throw_exception(devFailed, string2, string3, string4);
            }
            catch (Exception exception) {
                if (exception.toString().indexOf("org.omg.CORBA.TRANSIENT") >= 0 && n == 0) {
                    this.device = null;
                    this.ior = null;
                    this.build_connection();
                }
                this.throw_dev_failed(exception, string, true);
            }
            ++n;
        }
        return new DeviceData(any);
    }

    public DeviceData command_inout(String string) throws DevFailed {
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        try {
            if (this.url.protocol == 1) {
                return this.taco_device.command_inout(string, null);
            }
            Any any = ApiUtil.get_orb().create_any();
            Any any2 = this.device_2 != null ? this.device_2.command_inout_2(string, any, this.dev_src) : this.device.command_inout(string, any);
            return new DeviceData(any2);
        }
        catch (DevFailed devFailed) {
            String string2 = "TangoApi_CANNOT_EXECUTE_COMMAND";
            String string3 = new String("Cannot execute command " + string + " on " + this.devname);
            String string4 = new String("Connection.command_inout()");
            Except.re_throw_exception(devFailed, string2, string3, string4);
            return null;
        }
        catch (Exception exception) {
            this.throw_dev_failed(exception, string, true);
            return null;
        }
    }

    public long ping() throws DevFailed {
        this.checkIfTango("ping");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        long l = System.currentTimeMillis();
        try {
            this.device.ping();
        }
        catch (DevFailed devFailed) {
            String string = "TangoApi_CANNOT_PING_DEVICE";
            String string2 = new String("Cannot ping " + this.devname);
            String string3 = new String("Connection.ping()");
            Except.re_throw_exception(devFailed, string, string2, string3);
        }
        catch (Exception exception) {
            this.throw_dev_failed(exception, "ping", false);
        }
        long l2 = System.currentTimeMillis();
        return (int)(l2 - l) * 1000;
    }

    public String[] black_box(int n) throws DevFailed {
        this.checkIfTango("black_box");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        try {
            String[] stringArray = this.device.black_box(n);
            return stringArray;
        }
        catch (DevFailed devFailed) {
            String string = "TangoApi_CANNOT_READ_BLACK BOX";
            String string2 = new String("Cannot read black box on " + this.devname);
            String string3 = new String("Connection.black_box()");
            Except.re_throw_exception(devFailed, string, string2, string3);
        }
        catch (Exception exception) {
            this.throw_dev_failed(exception, "black_box", false);
        }
        return null;
    }

    public DevInfo info() throws DevFailed {
        this.checkIfTango("info");
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        try {
            DevInfo devInfo = this.device.info();
            return devInfo;
        }
        catch (DevFailed devFailed) {
            String string = "TangoApi_CANNOT_READ _DEVICE_INFO";
            String string2 = new String("Cannot read device info on " + this.devname);
            String string3 = new String("Connection.info()");
            Except.re_throw_exception(devFailed, string, string2, string3);
        }
        catch (Exception exception) {
            this.throw_dev_failed(exception, "info", false);
        }
        return null;
    }

    public CommandInfo[] command_list_query() throws DevFailed {
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        try {
            CommandInfo[] commandInfoArray;
            if (this.url.protocol == 1) {
                commandInfoArray = this.taco_device.commandListQuery();
            } else if (this.device_2 != null) {
                DevCmdInfo_2[] devCmdInfo_2Array = this.device_2.command_list_query_2();
                commandInfoArray = new CommandInfo[devCmdInfo_2Array.length];
                int n = 0;
                while (n < devCmdInfo_2Array.length) {
                    commandInfoArray[n] = new CommandInfo(devCmdInfo_2Array[n]);
                    ++n;
                }
            } else {
                DevCmdInfo[] devCmdInfoArray = this.device.command_list_query();
                commandInfoArray = new CommandInfo[devCmdInfoArray.length];
                int n = 0;
                while (n < devCmdInfoArray.length) {
                    commandInfoArray[n] = new CommandInfo(devCmdInfoArray[n]);
                    ++n;
                }
            }
            return commandInfoArray;
        }
        catch (DevFailed devFailed) {
            String string = "TangoApi_CANNOT__READ_CMD_LIST";
            String string2 = new String("Cannot read command list for " + this.devname);
            String string3 = new String("Connection.command_list_query()");
            Except.re_throw_exception(devFailed, string, string2, string3);
        }
        catch (Exception exception) {
            this.throw_dev_failed(exception, "command_list_query", false);
        }
        return null;
    }

    public int get_idl_version() throws DevFailed {
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        return this.idl_version;
    }

    public DevSource get_source() {
        return this.dev_src;
    }

    public void set_source(DevSource devSource) {
        this.dev_src = devSource;
    }

    public String get_name() {
        return this.devname;
    }

    public String description() throws DevFailed {
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        return this.device.description();
    }

    public String adm_name() throws DevFailed {
        if (this.device == null && this.devname != null) {
            this.build_connection();
        }
        return this.device.adm_name();
    }

    public String get_tango_host() throws DevFailed {
        this.checkIfTango("get_tango_host");
        return new String(this.url.host + ":" + this.url.strport);
    }

    public boolean is_taco() {
        return this.url.protocol == 1;
    }

    protected void checkIfTaco(String string) throws DevFailed {
        if (!this.is_taco()) {
            Except.throw_exception("TangoApi_NOT_TANGO_CMD", new String(string + " is NOT a TANGO command."), new String(string + "()"));
        }
    }

    protected void checkIfTango(String string) throws DevFailed {
        if (this.is_taco()) {
            Except.throw_exception("TangoApi_NOT_TACO_CMD", new String(string + " is NOT a TACO command."), new String(string + "()"));
        }
    }

    public boolean getTransparenceReconnection() {
        return this.transparent_reconnection;
    }

    public void setTransparenceReconnection(boolean bl) {
        this.transparent_reconnection = bl;
    }
}

