/*
 * Decompiled with CFR 0.152.
 */
package tool_panels.spectrum_histo;

import app_util.PopupError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeProxy;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceDataHistory;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.Splash;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import tool_panels.spectrum_histo.AttributeBrowser;
import tool_panels.spectrum_histo.Histo_3D;

public class SpectrumHisto
extends JDialog {
    private static String className = "SpectrumHisto";
    private static String revNumber = "Release 1.6  -  Tue May 19 13:53:44 CEST 2009";
    private Component parent;
    private String attname;
    private JLabel titleLabel;
    private long period = 3000L;
    private SpectrumViewer viewer;
    private static final String[] menu_labels = new String[]{"Set refresher period"};
    private static final int REFRESHER_PERIOD = 0;
    static String[] labels = null;
    public static Splash splash;
    private boolean running = true;
    private int splash_progress = 5;
    private JButton exceptionBtn;

    public SpectrumHisto(JFrame parent, String attname) throws DevFailed {
        this(parent, attname, true);
    }

    public SpectrumHisto(JFrame parent, String attname, boolean modal) throws DevFailed {
        super((Frame)parent, modal);
        this.createDialog(parent, attname);
    }

    public SpectrumHisto(JDialog parent, String attname) throws DevFailed {
        this(parent, attname, true);
    }

    public SpectrumHisto(JDialog parent, String attname, boolean modal) throws DevFailed {
        super((Dialog)parent, modal);
        this.createDialog(parent, attname);
    }

    private void createDialog(Component parent, String attname) throws DevFailed {
        String title = className;
        int end = revNumber.indexOf("-");
        if (end > 0) {
            title = title + " - " + revNumber.substring(0, end).trim();
        }
        splash = new Splash();
        splash.setTitle(title);
        this.increaseSplashProgress(5, "Building UI");
        this.parent = parent;
        this.attname = attname;
        this.initComponents();
        this.viewer = new SpectrumViewer(this);
        if (labels != null) {
            this.viewer.setYLabels(labels);
        }
        this.getContentPane().add((Component)((Object)this.viewer), "Center");
        double d_period = (double)this.period / 1000.0;
        this.titleLabel.setText(attname + "   History  (" + d_period + " ms)");
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
        this.setTitle(className + " - " + revNumber);
        splash.progress(100);
        splash.setVisible(false);
    }

    private void increaseSplashProgress(int i, String message) {
        this.splash_progress += i;
        if (this.splash_progress > 99) {
            this.splash_progress = 99;
        }
        splash.progress(this.splash_progress);
        splash.setMessage(message);
    }

    private void initComponents() {
        JPanel jPanel1 = new JPanel();
        JButton cancelBtn = new JButton();
        JPanel jPanel2 = new JPanel();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                SpectrumHisto.this.closeDialog(evt);
            }
        });
        cancelBtn.setText("Dismiss");
        cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpectrumHisto.this.cancelBtnActionPerformed(evt);
            }
        });
        jPanel1.add(cancelBtn);
        this.exceptionBtn = new JButton();
        this.exceptionBtn.setText("Error");
        this.exceptionBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpectrumHisto.this.exceptionBtnActionPerformed(evt);
            }
        });
        this.exceptionBtn.setVisible(false);
        jPanel1.add(this.exceptionBtn);
        this.getContentPane().add((Component)jPanel1, "South");
        this.titleLabel = new JLabel();
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)jPanel2, "North");
        this.pack();
    }

    private void exceptionBtnActionPerformed(ActionEvent evt) {
        DevFailed e = this.viewer.getException();
        if (e != null) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        if (this.parent.getWidth() > 0) {
            this.setVisible(false);
            this.dispose();
        } else {
            this.running = false;
            System.exit(0);
        }
    }

    static void checkSyntax(String[] args) throws DevFailed {
        StringTokenizer stk = new StringTokenizer(args[0], "/");
        Vector<String> v = new Vector<String>();
        while (stk.hasMoreTokens()) {
            v.add(stk.nextToken());
        }
        if (v.size() != 4) {
            Except.throw_exception((String)"BAD_APRAM", (String)(args[0] + "  is not an attribute name !"), (String)"SpectrumHistor.checkSyntax()");
        }
        try {
            if (args.length > 1) {
                FileInputStream fid = new FileInputStream(args[1]);
                int nb = fid.available();
                byte[] inStr = new byte[nb];
                if ((nb = fid.read(inStr)) == 0) {
                    labels = null;
                }
                fid.close();
                String code = new String(inStr).trim();
                stk = new StringTokenizer(code, "\n");
                v = new Vector();
                while (stk.hasMoreTokens()) {
                    v.add(stk.nextToken());
                }
                labels = new String[v.size()];
                for (int i = 0; i < v.size(); ++i) {
                    SpectrumHisto.labels[i] = (String)v.get(i);
                }
                System.out.println(labels.length + " labels found");
            }
        }
        catch (Exception e) {
            Except.throw_exception((String)"READ_FILE_FAILED", (String)e.toString(), (String)"SpectrumHistor.checkSyntax()");
        }
    }

    public static boolean supportedType(int type) {
        switch (type) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            AttributeBrowser browser = new AttributeBrowser(new JFrame());
            browser.setVisible(true);
        } else {
            try {
                SpectrumHisto.checkSyntax(args);
                new SpectrumHisto(new JFrame(), args[0]).setVisible(true);
            }
            catch (Exception e) {
                if (splash != null) {
                    splash.setVisible(false);
                }
                ErrorPane.showErrorMessage((Component)new Frame(), null, (Exception)e);
                System.exit(0);
            }
        }
    }

    class Refresher
    extends Thread {
        private AttributeProxy att;
        private SpectrumViewer viewer;
        private DevFailed dev_failed;

        Refresher(SpectrumViewer viewer, AttributeProxy att) {
            this.viewer = viewer;
            this.att = att;
        }

        DevFailed getException() {
            return this.dev_failed;
        }

        public void run() {
            while (SpectrumHisto.this.running) {
                try {
                    DeviceAttribute da = this.att.read();
                    switch (da.getType()) {
                        case 5: {
                            this.viewer.addData(da.extractDoubleArray());
                            break;
                        }
                        case 3: {
                            int i;
                            Object[] values = da.extractLongArray();
                            double[] d_values = new double[values.length];
                            for (i = 0; i < values.length; ++i) {
                                d_values[i] = values[i];
                            }
                            this.viewer.addData(d_values);
                            break;
                        }
                        case 6: {
                            int i;
                            Object[] values = da.extractUShortArray();
                            double[] d_values = new double[values.length];
                            for (i = 0; i < values.length; ++i) {
                                d_values[i] = values[i];
                            }
                            this.viewer.addData(d_values);
                            break;
                        }
                        case 2: {
                            int i;
                            Object[] values = da.extractShortArray();
                            double[] d_values = new double[values.length];
                            for (i = 0; i < values.length; ++i) {
                                d_values[i] = values[i];
                            }
                            this.viewer.addData(d_values);
                            break;
                        }
                        case 4: {
                            int i;
                            Object[] values = da.extractFloatArray();
                            double[] d_values = new double[values.length];
                            for (i = 0; i < values.length; ++i) {
                                d_values[i] = values[i];
                            }
                            this.viewer.addData(d_values);
                            break;
                        }
                        default: {
                            Except.throw_exception((String)"TYPE_NOT_SUPPORTED", (String)(TangoConst.Tango_CmdArgTypeName[da.getType()] + "\n   is a non supported type !"), (String)"SpectrumHisto.Refresher.run()");
                        }
                    }
                    SpectrumHisto.this.exceptionBtn.setVisible(false);
                }
                catch (DevFailed e) {
                    if (e.errors[0].reason.equals("TYPE_NOT_SUPPORTED")) {
                        splash.setVisible(false);
                        ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)e);
                        return;
                    }
                    Except.print_exception((Exception)((Object)e));
                    this.dev_failed = e;
                    SpectrumHisto.this.exceptionBtn.setVisible(true);
                    this.viewer.addData(null);
                }
                try {
                    Refresher.sleep(SpectrumHisto.this.period);
                }
                catch (Exception exception) {}
            }
        }
    }

    class SpectrumViewer
    extends Histo_3D {
        private AttributeProxy attribute;
        private Refresher refresher;
        private JDialog parent;

        SpectrumViewer(JDialog parent) throws DevFailed {
            super(parent);
            this.parent = parent;
            this.setSearchBestFitVisible(true);
            this.attribute = new AttributeProxy(SpectrumHisto.this.attname);
            this.readHistory();
            this.setPollingPeriod();
            this.refresher = new Refresher(this, this.attribute);
            this.refresher.start();
            for (String label : menu_labels) {
                JMenuItem btn = new JMenuItem(label);
                btn.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        SpectrumViewer.this.histoMenuActionPerformed(evt);
                    }
                });
                this.addToMenu(btn);
            }
        }

        private void setPollingPeriod() {
            try {
                SpectrumHisto.this.period = this.attribute.get_polling_period();
            }
            catch (NoSuchMethodError nsme) {
                try {
                    DeviceProxy dev = this.attribute.getDeviceProxy();
                    DbDatum datum = dev.get_property("polled_attr");
                    String[] str = datum.extractStringArray();
                    String attname = this.attribute.name().toLowerCase();
                    if (str != null) {
                        for (int i = 0; i < str.length; i += 2) {
                            if (!str[i].toLowerCase().equals(attname) || i >= str.length - 1) continue;
                            SpectrumHisto.this.period = Integer.parseInt(str[i + 1]);
                        }
                    }
                    Except.throw_exception((String)"NOT_POLLED", (String)("Attribute " + this.attribute.name() + " not polled"), (String)"SpectrumHisto.setPollingPeriod()");
                }
                catch (NumberFormatException ex) {
                    System.err.println(ex);
                }
                catch (DevFailed e) {
                    if (e.errors[0].reason.equals("NOT_POLLED")) {
                        e.errors[0].desc = e.errors[0].desc + "\n\n - The refresher period is set 3 seconds.\n - There is no history to be read.\n - The fit range cannot be done.";
                    }
                    splash.setVisible(false);
                    ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)e);
                }
            }
            catch (DevFailed e) {
                if (e.errors[0].reason.equals("NOT_POLLED")) {
                    e.errors[0].desc = e.errors[0].desc + "\n\n - The refresher period is set 3 seconds.\n - There is no history to be read.\n - The fit range cannot be done.";
                }
                splash.setVisible(false);
                ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)e);
            }
        }

        private void histoMenuActionPerformed(ActionEvent evt) {
            String cmd = evt.getActionCommand();
            if (cmd.equals(menu_labels[0])) {
                int nb_sec = (int)SpectrumHisto.this.period / 1000;
                String strval = "" + nb_sec;
                boolean ok = false;
                while (!ok) {
                    if ((strval = (String)JOptionPane.showInputDialog(this.parent, "Refresher Period in seconds : ", "", 3, null, null, strval)) == null) {
                        return;
                    }
                    try {
                        nb_sec = Integer.parseInt(strval);
                        if (nb_sec < 1) {
                            PopupError.show((Component)((Object)this), "The period must be higher than 1 second");
                            continue;
                        }
                        ok = true;
                    }
                    catch (NumberFormatException e) {
                        PopupError.show((Component)((Object)this), e.toString());
                    }
                }
                SpectrumHisto.this.period = 1000 * nb_sec;
            }
        }

        private void readHistory() {
            try {
                System.out.println("Reading History");
                SpectrumHisto.this.increaseSplashProgress(50, "Reading History");
                DeviceDataHistory[] histo = this.attribute.history();
                System.out.println(histo.length + " data read");
                SpectrumHisto.this.increaseSplashProgress(20, "Updating image");
                this.addHistoData(histo);
                this.setBestFitMinMax();
                this.setPreferredSize(new Dimension(histo.length, this.getYSize() + 50));
            }
            catch (DevFailed e) {
                Except.print_exception((Exception)((Object)e));
            }
        }

        void addData(double[] data) {
            this.addHistoData(data);
            this.updateImage();
        }

        DevFailed getException() {
            return this.refresher.getException();
        }
    }
}

