/*
 * Decompiled with CFR 0.152.
 */
package tool_panels.servstate;

import atkpanel.MainPanel;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.tangoatk.core.ATKException;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.DevStateScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IDevStateScalar;
import fr.esrf.tangoatk.core.IDevStateScalarListener;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.widget.attribute.StateViewer;
import fr.esrf.tangoatk.widget.util.ATKDiagnostic;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorHistory;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import jive.ExecDev;

public class ServStatePanel
extends JScrollPane {
    private String title;
    private AttributeList attlist = new AttributeList();
    private ErrorHistory err_history;
    private StatePopupMenu menu;

    public ServStatePanel(String servname) throws DevFailed {
        try {
            new DeviceProxy("dserver/" + servname).ping();
        }
        catch (DevFailed e) {
            e.errors[0].desc = "Server " + servname + " Is not running !";
            throw e;
        }
        this.title = servname;
        TangoClass[] classes = this.getClasses(servname);
        this.initializeComponents(classes);
        this.menu = new StatePopupMenu(this);
    }

    public ServStatePanel(String title, String[] devnames) {
        this.title = title;
        TangoClass _class = new TangoClass(devnames);
        this.initializeComponents(new TangoClass[]{_class});
    }

    public void stopRefresher() {
        this.attlist.stopRefresher();
    }

    private void initializeComponents(TangoClass[] classes) {
        this.err_history = new ErrorHistory();
        this.attlist.addErrorListener((IErrorListener)this.err_history);
        this.attlist.startRefresher();
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        int y = 2;
        for (TangoClass _class : classes) {
            gbc.gridx = 0;
            gbc.gridy = y++;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 0, 4, 0);
            panel.add((Component)new JLabel(_class.name), gbc);
            for (TangoDevice dev : _class.dev) {
                if (dev == null) continue;
                gbc.gridx = 1;
                gbc.gridy = y;
                gbc.fill = 2;
                gbc.insets = new Insets(4, 0, 4, 0);
                panel.add((Component)dev.label, gbc);
                if (dev.viewer != null) {
                    gbc.gridx = 2;
                    gbc.gridy = y;
                    gbc.fill = 2;
                    gbc.insets = new Insets(4, 0, 4, 0);
                    panel.add((Component)dev.viewer, gbc);
                    gbc.gridx = 4;
                    gbc.gridy = y;
                    gbc.fill = 2;
                    panel.add((Component)dev.btn, gbc);
                    dev.setStateText();
                }
                ++y;
            }
        }
        JLabel title_lbl = new JLabel(this.title);
        title_lbl.setFont(new Font("Dialog", 1, 16));
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(4, 4, 30, 0);
        panel.add((Component)title_lbl, gbc);
        JButton errBtn = new JButton("Errors");
        errBtn.setMargin(new Insets(2, 5, 5, 2));
        gbc.gridwidth = 2;
        gbc.gridx = 2;
        gbc.gridy = 0;
        panel.add((Component)errBtn, gbc);
        errBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if ((evt.getModifiers() & 2) == 0) {
                    ServStatePanel.this.err_history.setVisible(true);
                } else {
                    ATKDiagnostic.showDiagnostic();
                }
            }
        });
        this.add(panel);
        this.setViewportView(panel);
        if (y > 24) {
            this.setPreferredSize(new Dimension(300, 650));
        }
    }

    private TangoClass[] getClasses(String servname) throws DevFailed {
        DbServer serv = new DbServer(servname);
        String[] classnames = serv.get_class_list();
        TangoClass[] classes = new TangoClass[classnames.length];
        int i = 0;
        for (String name : classnames) {
            classes[classnames.length - i - 1] = new TangoClass(serv, name);
            ++i;
        }
        return classes;
    }

    class StatePopupMenu
    extends JPopupMenu {
        private ServStatePanel parent;
        private final String[] menuLabels = new String[]{"Status", "Test Device", "monitor Device"};
        private JLabel title;
        private TangoDevice device;
        private final int OFFSET = 2;
        private final int STATUS = 0;
        private final int TEST_DEVICE = 1;
        private final int MONITOR_DEVICE = 2;

        public StatePopupMenu(ServStatePanel parent) {
            this.parent = parent;
            this.buildBtnPopupMenu();
        }

        private void buildBtnPopupMenu() {
            this.title = new JLabel("Device :");
            this.title.setFont(new Font("Dialog", 1, 16));
            this.add(this.title);
            this.add(new JPopupMenu.Separator());
            for (String menuLabel : this.menuLabels) {
                if (menuLabel == null) {
                    this.add(new JPopupMenu.Separator());
                    continue;
                }
                JMenuItem btn = new JMenuItem(menuLabel);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        StatePopupMenu.this.itemActionPerformed(evt);
                    }
                });
                this.add(btn);
            }
        }

        public void showMenu(MouseEvent evt, TangoDevice dev) {
            this.device = dev;
            this.title.setText("Device: " + this.device.name);
            JComponent c = (JComponent)evt.getSource();
            Point p = c.getLocation();
            this.show(this.parent, evt.getX() + p.x, evt.getY() + p.y);
        }

        private void itemActionPerformed(ActionEvent evt) {
            Object obj = evt.getSource();
            int cmdidx = 0;
            for (int i = 0; i < this.menuLabels.length; ++i) {
                if (this.getComponent(2 + i) != obj) continue;
                cmdidx = i;
            }
            switch (cmdidx) {
                case 0: {
                    this.device.displayStatus();
                    break;
                }
                case 1: {
                    try {
                        JDialog d = new JDialog((Frame)new JFrame(), false);
                        d.setTitle(this.device.name + " Device Panel");
                        d.setContentPane((Container)new ExecDev(this.device.name));
                        ATKGraphicsUtils.centerDialog((Dialog)d);
                        d.setVisible(true);
                    }
                    catch (DevFailed e) {
                        ErrorPane.showErrorMessage((Component)new JFrame(), (String)this.device.name, (DevFailed)e);
                    }
                    break;
                }
                case 2: {
                    new MainPanel(this.device.name(), false, true);
                }
            }
        }
    }

    class TangoDevice
    extends DeviceProxy
    implements IDevStateScalarListener {
        String name;
        JLabel label;
        StateViewer viewer;
        JButton btn;

        public TangoDevice(String name) throws DevFailed {
            super(name);
            this.name = name;
            try {
                this.label = new JLabel(name);
                this.label.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent evt) {
                        TangoDevice.this.devMouseClicked(evt);
                    }
                });
                IDevStateScalar att_state = (IDevStateScalar)ServStatePanel.this.attlist.add(name + "/state");
                this.viewer = new StateViewer();
                this.viewer.setLabel("");
                this.viewer.setStatePreferredSize(new Dimension(60, 15));
                this.viewer.setModel(att_state);
                att_state.addDevStateScalarListener((IDevStateScalarListener)this);
                this.btn = new JButton("...");
                this.btn.setPreferredSize(new Dimension(20, 15));
                this.btn.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent evt) {
                        TangoDevice.this.devMouseClicked(evt);
                    }
                });
            }
            catch (ConnectionException e) {
                ErrorPane.showErrorMessage((Component)new JFrame(), null, (ATKException)e);
            }
        }

        private void setStateText() {
            String str = this.viewer.getCurrentState();
            this.viewer.setStateText(str);
        }

        public void devStateScalarChange(DevStateScalarEvent evt) {
            this.viewer.setStateText(evt.getValue());
        }

        public void stateChange(AttributeStateEvent evt) {
        }

        public void errorChange(ErrorEvent evt) {
            System.out.println(evt.getError());
        }

        private void displayStatus() {
            try {
                String status = this.status();
                JOptionPane.showMessageDialog(new Frame(), status, this.name, 1);
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)e);
            }
        }

        private void devMouseClicked(MouseEvent evt) {
            int mask = evt.getModifiers();
            if ((mask & 0x10) != 0 && evt.getSource() instanceof JButton) {
                this.displayStatus();
            } else if ((mask & 4) != 0) {
                ServStatePanel.this.menu.showMenu(evt, this);
            }
        }
    }

    class TangoClass {
        String name;
        TangoDevice[] dev;

        public TangoClass(DbServer adm_dev, String name) {
            this.name = name;
            try {
                String[] devnames = adm_dev.get_device_name(name);
                this.dev = new TangoDevice[devnames.length];
                int i = 0;
                for (String devname : devnames) {
                    this.dev[i++] = new TangoDevice(devname);
                }
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)e);
            }
        }

        public TangoClass(String[] devnames) {
            this.name = "";
            try {
                this.dev = new TangoDevice[devnames.length];
                int i = 0;
                for (String devname : devnames) {
                    this.dev[i++] = new TangoDevice(devname);
                }
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)e);
            }
        }

        public String toString() {
            String str = "Class " + this.name + ":\n";
            for (TangoDevice d : this.dev) {
                str = str + "\t" + d.name() + "\n";
            }
            return str;
        }
    }
}

