/*
 * Decompiled with CFR 0.152.
 */
package tool_panels.atktable;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.AsynReplyNotArrived;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.AttributeProxy;
import fr.esrf.TangoApi.CommunicationFailed;
import fr.esrf.TangoApi.ConnectionFailed;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceInfo;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.EventSystemFailed;
import fr.esrf.TangoApi.NonDbDevice;
import fr.esrf.TangoApi.NonSupportedFeature;
import fr.esrf.TangoApi.WrongData;
import fr.esrf.TangoApi.WrongNameSyntax;
import fr.esrf.TangoDs.TangoConst;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import tool_panels.atktable.DevBrowser;
import tool_panels.atktable.TablePopupMenu;

public class DevBrowserTree
extends JTree
implements TangoConst {
    private static final int INSTANCE = 3;
    private static final int CLASS = 4;
    private static final int DEVICE = 5;
    private static final int ATTRIB = 6;
    private static final int DOMAIN = 3;
    private static final int FAMILY = 4;
    private static final int MEMBER = 5;
    private DefaultTreeModel treeModel;
    private DevBrowser browser;
    private DefaultMutableTreeNode root;
    private TablePopupMenu menu;

    public DevBrowserTree(DevBrowser parent) throws DevFailed {
        this.browser = parent;
        String tango_host = ApiUtil.get_db_obj().get_tango_host();
        this.initComponent(tango_host);
        this.menu = new TablePopupMenu(this);
    }

    private void initComponent(String title) throws DevFailed {
        this.root = new DefaultMutableTreeNode(title);
        this.createServerNodes(this.root);
        this.createDeviceNodes(this.root);
        this.createAliasNodes(this.root);
        this.getSelectionModel().setSelectionMode(1);
        this.treeModel = new DefaultTreeModel(this.root);
        this.setModel(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(new TangoRenderer());
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent e) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent e) {
                DevBrowserTree.this.expandedPerfomed(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DevBrowserTree.this.treeMouseClicked(evt);
            }
        });
    }

    private boolean createChildNodes(DefaultMutableTreeNode node, String[] str) {
        boolean create = false;
        if (node.getChildCount() != str.length) {
            create = true;
        } else {
            for (int i = 0; i < str.length; ++i) {
                if (node.getChildAt(i).toString().equals(str[i])) continue;
                create = true;
            }
        }
        return create;
    }

    private void createAliasNodes(DefaultMutableTreeNode root) throws DevFailed {
        DefaultMutableTreeNode c_node = new DefaultMutableTreeNode("Aliases");
        root.add(c_node);
        Database db = ApiUtil.get_db_obj();
        String[] aliases = db.get_device_alias_list("*");
        for (int i = 0; i < aliases.length; ++i) {
            try {
                String devname = ApiUtil.get_db_obj().get_alias_device(aliases[i]);
                DefaultMutableTreeNode al_node = new DefaultMutableTreeNode((Object)new BrowserDevice(devname, aliases[i]));
                al_node.add(new DefaultMutableTreeNode("dummy"));
                c_node.add(al_node);
                continue;
            }
            catch (DevFailed e) {
                // empty catch block
            }
        }
    }

    private void createServerNodes(DefaultMutableTreeNode root) throws DevFailed {
        DefaultMutableTreeNode c_node = new DefaultMutableTreeNode("Servers");
        root.add(c_node);
        Database db = ApiUtil.get_db_obj();
        String[] servers = db.get_server_name_list();
        for (int d = 0; d < servers.length; ++d) {
            DefaultMutableTreeNode d_node = new DefaultMutableTreeNode(servers[d]);
            d_node.add(new DefaultMutableTreeNode("dummy"));
            c_node.add(d_node);
        }
    }

    private void createInstanceNodes(DefaultMutableTreeNode node) {
        try {
            String binfile = (String)node.getUserObject();
            String[] instancies = ApiUtil.get_db_obj().get_instance_name_list(binfile);
            if (!this.createChildNodes(node, instancies)) {
                return;
            }
            for (int i = 0; i < instancies.length; ++i) {
                DefaultMutableTreeNode s_node = new DefaultMutableTreeNode(new BrowserServer(binfile, instancies[i]));
                s_node.add(new DefaultMutableTreeNode("Dummy"));
                this.treeModel.insertNodeInto(s_node, node, i);
            }
            this.removePreviousNode(node, instancies.length);
        }
        catch (DevFailed e) {
            this.displayException((Exception)((Object)e));
        }
    }

    private void createClassNodes(DefaultMutableTreeNode node) {
        try {
            BrowserServer server = (BrowserServer)node.getUserObject();
            String[] classes = ApiUtil.get_db_obj().get_server_class_list(server.name);
            if (!this.createChildNodes(node, classes)) {
                return;
            }
            for (int i = 0; i < classes.length; ++i) {
                DefaultMutableTreeNode i_node = new DefaultMutableTreeNode(classes[i]);
                i_node.add(new DefaultMutableTreeNode("Dummy"));
                this.treeModel.insertNodeInto(i_node, node, i);
            }
            this.removePreviousNode(node, classes.length);
        }
        catch (DevFailed e) {
            this.displayException((Exception)((Object)e));
        }
    }

    private void createDeviceNodesFromServer(DefaultMutableTreeNode node) {
        try {
            DefaultMutableTreeNode s_node = (DefaultMutableTreeNode)node.getParent();
            BrowserServer server = (BrowserServer)s_node.getUserObject();
            String servname = server.name;
            String classname = (String)node.getUserObject();
            String[] devices = ApiUtil.get_db_obj().get_device_name(servname, classname);
            if (!this.createChildNodes(node, devices)) {
                return;
            }
            for (int i = 0; i < devices.length; ++i) {
                DefaultMutableTreeNode d_node = new DefaultMutableTreeNode((Object)new BrowserDevice_2(devices[i]));
                d_node.add(new DefaultMutableTreeNode("dummy"));
                this.treeModel.insertNodeInto(d_node, node, i);
            }
            this.removePreviousNode(node, devices.length);
        }
        catch (DevFailed e) {
            this.displayException((Exception)((Object)e));
        }
    }

    private void createDeviceNodes(DefaultMutableTreeNode root) throws DevFailed {
        DefaultMutableTreeNode c_node = new DefaultMutableTreeNode("Devices");
        root.add(c_node);
        Database db = ApiUtil.get_db_obj();
        String[] domains = db.get_device_domain("*");
        for (int d = 0; d < domains.length; ++d) {
            DefaultMutableTreeNode d_node = new DefaultMutableTreeNode(domains[d]);
            d_node.add(new DefaultMutableTreeNode("dummy"));
            c_node.add(d_node);
        }
    }

    private void createFamilyNodes(DefaultMutableTreeNode node) {
        try {
            String domain = (String)node.getUserObject();
            String[] families = ApiUtil.get_db_obj().get_device_family(domain + "/*");
            if (!this.createChildNodes(node, families)) {
                return;
            }
            for (int f = 0; f < families.length; ++f) {
                DefaultMutableTreeNode f_node = new DefaultMutableTreeNode(families[f]);
                f_node.add(new DefaultMutableTreeNode("Dummy"));
                this.treeModel.insertNodeInto(f_node, node, f);
            }
            this.removePreviousNode(node, families.length);
        }
        catch (DevFailed e) {
            this.displayException((Exception)((Object)e));
        }
    }

    private void createMemberNodes(String tango_path, DefaultMutableTreeNode node) {
        try {
            tango_path = tango_path + (String)node.getUserObject();
            String[] members = ApiUtil.get_db_obj().get_device_member(tango_path + "/*");
            if (!this.createChildNodes(node, members)) {
                return;
            }
            for (int m = 0; m < members.length; ++m) {
                DefaultMutableTreeNode m_node = new DefaultMutableTreeNode((Object)new BrowserDevice(tango_path + "/" + members[m]));
                m_node.add(new DefaultMutableTreeNode("Dummy"));
                this.treeModel.insertNodeInto(m_node, node, m);
            }
            this.removePreviousNode(node, members.length);
        }
        catch (DevFailed e) {
            this.displayException((Exception)((Object)e));
        }
    }

    private void createAttributeNodes(DefaultMutableTreeNode node) {
        try {
            BrowserDevice dev = (BrowserDevice)((Object)node.getUserObject());
            String[] attnames = dev.get_attribute_list();
            if (!this.createChildNodes(node, attnames)) {
                return;
            }
            for (int a = 0; a < attnames.length; ++a) {
                BrowserAttribute attr = new BrowserAttribute(attnames[a], dev);
                DefaultMutableTreeNode a_node = new DefaultMutableTreeNode(attr);
                this.treeModel.insertNodeInto(a_node, node, a);
            }
            this.removePreviousNode(node, attnames.length);
        }
        catch (DevFailed e) {
            this.removePreviousNode(node, 0);
            this.displayException((Exception)((Object)e));
        }
    }

    private void removePreviousNode(DefaultMutableTreeNode node, int offset) {
        while (node.getChildCount() > offset) {
            DefaultMutableTreeNode leaf = (DefaultMutableTreeNode)node.getChildAt(offset);
            this.treeModel.removeNodeFromParent(leaf);
        }
    }

    private String tangoPath(TreePath path, int nb) {
        String p = "";
        for (int i = 3; i < 3 + nb; ++i) {
            p = p + path.getPathComponent(i - 1).toString();
            p = p + "/";
        }
        return p;
    }

    public void expandedPerfomed(TreeExpansionEvent evt) {
        TreePath tp = evt.getPath();
        Object[] path = tp.getPath();
        if (path.length < 2) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp.getPathComponent(path.length - 1);
        if (path[1].toString().equals("Servers")) {
            switch (path.length) {
                case 3: {
                    this.createInstanceNodes(node);
                    break;
                }
                case 4: {
                    this.createClassNodes(node);
                    break;
                }
                case 5: {
                    this.createDeviceNodesFromServer(node);
                    break;
                }
                case 6: {
                    this.createAttributeNodes(node);
                }
            }
        } else if (path[1].toString().equals("Devices")) {
            switch (path.length) {
                case 3: {
                    this.createFamilyNodes(node);
                    break;
                }
                case 4: {
                    String tango_path = this.tangoPath(tp, 1);
                    this.createMemberNodes(tango_path, node);
                    break;
                }
                case 5: {
                    this.createAttributeNodes(node);
                }
            }
        } else if (path[1].toString().equals("Aliases") && path.length == 3) {
            this.createAttributeNodes(node);
        }
    }

    private void treeMouseClicked(MouseEvent evt) {
        if (this.getRowForLocation(evt.getX(), evt.getY()) < 1) {
            return;
        }
        TreePath selectedPath = this.getPathForLocation(evt.getX(), evt.getY());
        if (selectedPath == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectedPath.getPathComponent(selectedPath.getPathCount() - 1);
        Object o = node.getUserObject();
        int mask = evt.getModifiers();
        this.clearDisplay();
        if (evt.getClickCount() == 2 && node.isLeaf()) {
            if (o instanceof BrowserDevice) {
                this.createAttributeNodes(node);
                for (int i = 0; i < node.getChildCount(); ++i) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                    this.expandPath(new TreePath(child.getPath()));
                }
            }
            if (o instanceof BrowserAttribute) {
                BrowserAttribute attr = (BrowserAttribute)o;
                this.displayEventProperties(attr);
                this.addAttribute();
            }
        } else if ((mask & 4) != 0) {
            if (o instanceof BrowserAttribute) {
                BrowserAttribute attr = (BrowserAttribute)o;
                this.menu.showTreeMenu(evt, attr.attname, this.browser.target_position);
                this.displayEventProperties(attr);
            }
        } else if ((mask & 0x10) != 0) {
            if (o instanceof BrowserServer) {
                this.displayDeviceInfo(((BrowserServer)o).dev);
            } else if (o instanceof BrowserDevice) {
                this.displayDeviceInfo((BrowserDevice)((Object)o));
            } else if (o instanceof BrowserAttribute) {
                this.displayEventProperties((BrowserAttribute)o);
            }
        }
    }

    private void clearDisplay() {
        this.browser.setText("");
    }

    private boolean displayDeviceInfo(BrowserDevice dev) {
        String message;
        try {
            DeviceInfo info = dev.get_info();
            message = info + "\n\n";
        }
        catch (DevFailed e) {
            this.browser.setText(e.toString());
            return false;
        }
        boolean ok = false;
        try {
            String str = "\n=======================================\n";
            str = str + "           Polling Status:\n\n";
            if (dev.name().startsWith("dserver/")) {
                DeviceData argout = dev.command_inout("QueryDevice");
                String[] devlist = argout.extractStringArray();
                for (int i = 0; i < devlist.length; ++i) {
                    String devname = devlist[i].substring(devlist[i].indexOf("::") + 2);
                    DeviceData argin = new DeviceData();
                    argin.insert(devname);
                    argout = dev.command_inout("DevPollStatus", argin);
                    String[] s = argout.extractStringArray();
                    str = str + "----------------- " + devname + " ------------------\n";
                    for (int j = 0; j < s.length; ++j) {
                        str = str + s[j] + "\n\n";
                    }
                }
                ok = true;
            } else {
                String[] poll_st = dev.polling_status();
                for (int i = 0; i < poll_st.length; ++i) {
                    str = str + poll_st[i] + "\n\n";
                }
                ok = true;
            }
            message = message + str;
        }
        catch (DevFailed e) {
            try {
                dev.ping();
                ok = true;
            }
            catch (DevFailed ex) {
                message = message + "\n=======================================\n";
            }
        }
        this.browser.setText(message);
        return ok;
    }

    String getSelectedName() {
        Object o = this.getSelectedNode().getUserObject();
        if (o instanceof BrowserAttribute) {
            return ((BrowserAttribute)o).name;
        }
        if (o instanceof BrowserDevice) {
            return ((BrowserDevice)((Object)o)).name;
        }
        if (o instanceof BrowserServer) {
            return ((BrowserServer)o).name;
        }
        return "??";
    }

    private String getAttPollingInfo() {
        Object o = this.getSelectedNode().getUserObject();
        if (o instanceof BrowserAttribute) {
            try {
                BrowserAttribute att = (BrowserAttribute)o;
                String header = "Polled attribute name = ";
                String[] poll_status = att.dev.polling_status();
                for (int i = 0; i < poll_status.length; ++i) {
                    String s = poll_status[i].substring(header.length(), poll_status[i].indexOf(10));
                    if (!s.toLowerCase().equals(att.name.toLowerCase())) continue;
                    return poll_status[i];
                }
            }
            catch (DevFailed e) {
                return e.toString();
            }
        }
        return "";
    }

    private void displayEventProperties(BrowserAttribute attr) {
        this.displayEventProperties(attr.attname);
    }

    void displayEventProperties(String attname) {
        String str = "";
        try {
            AttributeProxy ap = new AttributeProxy(attname);
            int att_idl_version = ap.get_idl_version();
            if (att_idl_version < 3) {
                this.browser.setText("Device_" + att_idl_version + "Impl not supported.");
                return;
            }
            AttributeInfoEx info = ap.get_info_ex();
            if (info.events != null) {
                str = attname;
                str = str + "\n\nChange event properties:\n";
                if (info.events.ch_event != null) {
                    str = str + "abs_change :   " + info.events.ch_event.abs_change + "\n";
                    str = str + "rel_change :   " + info.events.ch_event.rel_change + "\n";
                } else {
                    str = str + "rel_change :   Not specified\n";
                    str = str + "abs_change :   Not specified\n";
                }
                str = str + "\n\nPeriodic event properties:\n";
                str = info.events.per_event != null ? str + "period     :   " + info.events.per_event.period : str + "period     :   Not specified";
                str = str + "\n\nArchive event properties:\n";
                if (info.events.arch_event != null) {
                    str = str + "abs_change :   " + info.events.arch_event.abs_change + "\n";
                    str = str + "rel_change :   " + info.events.arch_event.rel_change + "\n";
                    str = str + "period     :   " + info.events.arch_event.period;
                } else {
                    str = str + "rel_change :   Not specified\n";
                    str = str + "abs_change :   Not specified\n";
                    str = str + "period     :   Not specified";
                }
            }
            str = str + "\n\n\n" + this.getAttPollingInfo();
            this.browser.setText(str);
        }
        catch (DevFailed e) {
            this.displayException((Exception)((Object)e));
        }
    }

    private void displayException(Exception e) {
        this.browser.setText(DevBrowserTree.strException(e));
    }

    DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
    }

    void addAttribute() {
        Object o = this.getSelectedNode().getUserObject();
        if (o instanceof BrowserAttribute) {
            this.browser.addAttribute(((BrowserAttribute)o).attname);
        }
    }

    void gotoServer() {
        Object o = this.getSelectedNode().getUserObject();
        if (o instanceof BrowserDevice) {
            BrowserDevice dev = (BrowserDevice)((Object)o);
            try {
                DefaultMutableTreeNode node;
                int i;
                DeviceInfo info = dev.get_info();
                String servname = info.server;
                String binfile = servname.substring(0, servname.indexOf(47));
                String instance = servname.substring(servname.indexOf(47) + 1);
                Object[] path = new DefaultMutableTreeNode[4];
                int idx = 0;
                path[idx] = this.root;
                boolean found = false;
                for (i = 0; !found && i < path[idx].getChildCount(); ++i) {
                    node = (DefaultMutableTreeNode)path[idx].getChildAt(i);
                    found = node.toString().equals("Servers");
                    if (!found) continue;
                    path[++idx] = node;
                }
                found = false;
                for (i = 0; !found && i < path[idx].getChildCount(); ++i) {
                    node = (DefaultMutableTreeNode)path[idx].getChildAt(i);
                    found = node.toString().equals(binfile);
                    if (!found) continue;
                    path[++idx] = node;
                }
                if (!found) {
                    this.browser.setText(binfile + " Not Found !");
                    return;
                }
                if (path[idx].getChildCount() == 1 && path[idx].getChildAt(0).toString().equals("dummy")) {
                    this.createInstanceNodes((DefaultMutableTreeNode)path[idx]);
                }
                found = false;
                for (i = 0; !found && i < path[idx].getChildCount(); ++i) {
                    node = (DefaultMutableTreeNode)((DefaultMutableTreeNode)path[idx]).getChildAt(i);
                    Object obj = node.getUserObject();
                    if (!(obj instanceof BrowserServer)) continue;
                    BrowserServer serv = (BrowserServer)obj;
                    found = serv.instance.equals(instance);
                    if (!found) continue;
                    path[++idx] = node;
                }
                if (!found) {
                    this.browser.setText(instance + " Not Found !");
                    return;
                }
                TreePath tp = new TreePath(path);
                this.setSelectionPath(tp);
                this.scrollPathToVisible(tp);
            }
            catch (DevFailed e) {
                this.displayException((Exception)((Object)e));
            }
        }
    }

    String getCollection() {
        Object o = this.getSelectedNode().getUserObject();
        if (o instanceof BrowserDevice_2) {
            return "Servers";
        }
        return "Devices";
    }

    public static String strException(Exception except) {
        String str = "";
        if (except instanceof ConnectionFailed) {
            str = str + ((ConnectionFailed)except).getStack();
        } else if (except instanceof CommunicationFailed) {
            str = str + ((CommunicationFailed)except).getStack();
        } else if (except instanceof WrongNameSyntax) {
            str = str + ((WrongNameSyntax)except).getStack();
        } else if (except instanceof WrongData) {
            str = str + ((WrongData)except).getStack();
        } else if (except instanceof NonDbDevice) {
            str = str + ((NonDbDevice)except).getStack();
        } else if (except instanceof NonSupportedFeature) {
            str = str + ((NonSupportedFeature)except).getStack();
        } else if (except instanceof EventSystemFailed) {
            str = str + ((EventSystemFailed)except).getStack();
        } else if (except instanceof AsynReplyNotArrived) {
            str = str + ((AsynReplyNotArrived)except).getStack();
        } else if (except instanceof DevFailed) {
            DevFailed df = (DevFailed)((Object)except);
            str = str + "Tango exception  " + df.toString() + "\n";
            for (int i = 0; i < df.errors.length; ++i) {
                str = str + "Severity -> ";
                switch (df.errors[i].severity.value()) {
                    case 0: {
                        str = str + "WARNING \n";
                        break;
                    }
                    case 1: {
                        str = str + "ERROR \n";
                        break;
                    }
                    case 2: {
                        str = str + "PANIC \n";
                        break;
                    }
                    default: {
                        str = str + "Unknown severity code";
                    }
                }
                str = str + "Desc   -> " + df.errors[i].desc + "\n";
                str = str + "Reason -> " + df.errors[i].reason + "\n";
                str = str + "Origin -> " + df.errors[i].origin + "\n";
                if (i >= df.errors.length - 1) continue;
                str = str + "-------------------------------------------------------------\n";
            }
        } else {
            str = except.toString();
        }
        return str;
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon tangoIcon;
        private ImageIcon serv_icon;
        private ImageIcon dev_icon;
        private ImageIcon attr_icon;
        private ImageIcon class_icon;
        private Font[] fonts;
        private final int TITLE = 0;
        private final int DEVICE = 1;
        private final int ATTR = 2;

        public TangoRenderer() {
            String img_path = "/app_util/img/";
            this.tangoIcon = new ImageIcon(this.getClass().getResource(img_path + "network5.gif"));
            this.serv_icon = new ImageIcon(this.getClass().getResource(img_path + "server.gif"));
            this.dev_icon = new ImageIcon(this.getClass().getResource(img_path + "device.gif"));
            this.attr_icon = new ImageIcon(this.getClass().getResource(img_path + "leaf.gif"));
            this.class_icon = new ImageIcon(this.getClass().getResource(img_path + "class.gif"));
            this.fonts = new Font[3];
            this.fonts[0] = new Font("courrier", 1, 18);
            this.fonts[1] = new Font("Monospaced", 1, 12);
            this.fonts[2] = new Font("Monospaced", 0, 12);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object obj, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, obj, sel, expanded, leaf, row, hasFocus);
            if (row == 0) {
                this.setFont(this.fonts[0]);
                this.setIcon(this.tangoIcon);
            } else {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
                if (node.getUserObject() instanceof String) {
                    this.setFont(this.fonts[0]);
                    if (obj.toString().equals("Servers")) {
                        this.setIcon(this.serv_icon);
                    } else if (obj.toString().equals("Devices")) {
                        this.setIcon(this.dev_icon);
                    } else if (obj.toString().equals("Aliases")) {
                        this.setIcon(this.dev_icon);
                    } else {
                        this.setFont(this.fonts[1]);
                        this.setIcon(this.class_icon);
                    }
                } else if (node.getUserObject() instanceof BrowserAttribute) {
                    this.setFont(this.fonts[2]);
                    this.setIcon(this.attr_icon);
                } else if (node.getUserObject() instanceof BrowserDevice) {
                    this.setFont(this.fonts[1]);
                    this.setIcon(this.dev_icon);
                } else if (node.getUserObject() instanceof BrowserServer) {
                    this.setFont(this.fonts[1]);
                    this.setIcon(this.serv_icon);
                }
            }
            return this;
        }
    }

    private class BrowserAttribute {
        BrowserDevice dev;
        String name;
        String attname;

        BrowserAttribute(String name, BrowserDevice dev) {
            this.name = name;
            this.dev = dev;
            this.attname = dev.name + "/" + name;
        }

        public String toString() {
            return this.name;
        }
    }

    private class BrowserDevice_2
    extends BrowserDevice {
        BrowserDevice_2(String name) throws DevFailed {
            super(name);
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    private class BrowserDevice
    extends DeviceProxy {
        String name;
        String member;

        BrowserDevice(String name) throws DevFailed {
            super(name);
            this.name = name;
            int idx = name.lastIndexOf(47);
            this.member = idx < 0 ? name : name.substring(idx + 1);
        }

        BrowserDevice(String name, String aliasname) throws DevFailed {
            super(name);
            this.name = name;
            this.member = aliasname;
        }

        public String toString() {
            return this.member;
        }
    }

    private class BrowserServer {
        String name;
        String instance;
        BrowserDevice_2 dev;

        BrowserServer(String binfile, String instance) {
            this.name = binfile + "/" + instance;
            this.instance = instance;
            try {
                this.dev = new BrowserDevice_2("dserver/" + this.name);
            }
            catch (DevFailed e) {
                // empty catch block
            }
        }

        public String toString() {
            return this.instance;
        }
    }
}

