/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.nio.ByteBuffer;
import zmq.EncoderBase;
import zmq.IMsgSource;
import zmq.Msg;

public class V1Encoder
extends EncoderBase {
    private static final int size_ready = 0;
    private static final int message_ready = 1;
    private Msg in_progress;
    private final byte[] tmpbuf = new byte[9];
    private IMsgSource msg_source;

    public V1Encoder(int bufsize_, IMsgSource session) {
        super(bufsize_);
        this.msg_source = session;
        this.next_step(null, 0, 1, true);
    }

    @Override
    public void set_msg_source(IMsgSource msg_source_) {
        this.msg_source = msg_source_;
    }

    @Override
    protected boolean next() {
        switch (this.state()) {
            case 0: {
                return this.size_ready();
            }
            case 1: {
                return this.message_ready();
            }
        }
        return false;
    }

    private final boolean size_ready() {
        this.next_step(this.in_progress.data(), this.in_progress.size(), 1, !this.in_progress.has_more());
        return true;
    }

    private final boolean message_ready() {
        if (this.msg_source == null) {
            return false;
        }
        this.in_progress = this.msg_source.pull_msg();
        if (this.in_progress == null) {
            return false;
        }
        int protocol_flags = 0;
        if (this.in_progress.has_more()) {
            protocol_flags |= 1;
        }
        if (this.in_progress.size() > 255) {
            protocol_flags |= 2;
        }
        this.tmpbuf[0] = (byte)protocol_flags;
        int size = this.in_progress.size();
        if (size > 255) {
            ByteBuffer b = ByteBuffer.wrap(this.tmpbuf);
            b.position(1);
            b.putLong(size);
            this.next_step(this.tmpbuf, 9, 0, false);
        } else {
            this.tmpbuf[1] = (byte)size;
            this.next_step(this.tmpbuf, 2, 0, false);
        }
        return true;
    }
}

