/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import zmq.Address;

public class TcpAddress
implements Address.IZAddress {
    protected InetSocketAddress address;

    public TcpAddress(String addr_) {
        this.resolve(addr_, false);
    }

    public TcpAddress() {
    }

    @Override
    public String toString() {
        if (this.address == null) {
            return null;
        }
        if (this.address.getAddress() instanceof Inet6Address) {
            return "tcp://[" + this.address.getAddress().getHostAddress() + "]:" + this.address.getPort();
        }
        return "tcp://" + this.address.getAddress().getHostAddress() + ":" + this.address.getPort();
    }

    @Override
    public void resolve(String name_, boolean ipv4only_) {
        int port;
        int delimiter = name_.lastIndexOf(58);
        if (delimiter < 0) {
            throw new IllegalArgumentException(name_);
        }
        String addr_str = name_.substring(0, delimiter);
        String port_str = name_.substring(delimiter + 1);
        if (addr_str.length() >= 2 && addr_str.charAt(0) == '[' && addr_str.charAt(addr_str.length() - 1) == ']') {
            addr_str = addr_str.substring(1, addr_str.length() - 1);
        }
        if (port_str.equals("*") || port_str.equals("0")) {
            port = 0;
        } else {
            port = Integer.parseInt(port_str);
            if (port == 0) {
                throw new IllegalArgumentException(name_);
            }
        }
        InetAddress addr_net = null;
        if (addr_str.equals("*")) {
            addr_str = "0.0.0.0";
        }
        try {
            for (InetAddress ia : InetAddress.getAllByName(addr_str)) {
                if (ipv4only_ && ia instanceof Inet6Address) continue;
                addr_net = ia;
                break;
            }
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
        if (addr_net == null) {
            throw new IllegalArgumentException(name_);
        }
        this.address = new InetSocketAddress(addr_net, port);
    }

    @Override
    public SocketAddress address() {
        return this.address;
    }

    public static class TcpAddressMask
    extends TcpAddress {
        public boolean match_address(SocketAddress addr_) {
            return this.address.equals(addr_);
        }
    }
}

