/*
 * Decompiled with CFR 0.152.
 */
package org.jeromq;

import java.io.IOException;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jeromq.ZMQ;
import zmq.PollItem;
import zmq.ZMQ;

public class ZLoop {
    private static ThreadLocal<Boolean> initialized = new ThreadLocal();
    private static ZLoop instance = null;
    private final List<SPoller> pollers = new ArrayList<SPoller>();
    private final List<STimer> timers = new ArrayList<STimer>();
    private int poll_size;
    private PollItem[] pollset;
    private SPoller[] pollact;
    private boolean dirty;
    private boolean verbose;
    private final List<Object> zombies = new ArrayList<Object>();
    private final List<STimer> newTimers = new ArrayList<STimer>();

    private ZLoop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZLoop instance() {
        if (initialized.get() == null) {
            ThreadLocal<Boolean> threadLocal = initialized;
            synchronized (threadLocal) {
                if (instance == null) {
                    instance = new ZLoop();
                }
                initialized.set(Boolean.TRUE);
            }
        }
        return instance;
    }

    public void destory() {
    }

    private void rebuild() {
        this.pollset = null;
        this.pollact = null;
        this.poll_size = this.pollers.size();
        this.pollset = new PollItem[this.poll_size];
        this.pollact = new SPoller[this.poll_size];
        int item_nbr = 0;
        for (SPoller poller : this.pollers) {
            this.pollset[item_nbr] = poller.item.base();
            this.pollact[item_nbr] = poller;
            ++item_nbr;
        }
        this.dirty = false;
    }

    private long ticklessTimer() {
        long tickless = System.currentTimeMillis() + 3600000L;
        for (STimer timer : this.timers) {
            if (timer.when == -1L) {
                timer.when = (long)timer.delay + System.currentTimeMillis();
            }
            if (tickless <= timer.when) continue;
            tickless = timer.when;
        }
        long timeout = tickless - System.currentTimeMillis();
        if (timeout < 0L) {
            timeout = 0L;
        }
        if (this.verbose) {
            System.out.printf("I: zloop: polling for %d msec\n", timeout);
        }
        return timeout;
    }

    public int poller(ZMQ.PollItem item_, IZLoopHandler handler, Object arg) {
        PollItem item = item_.base();
        if (item.getRawSocket() == null && item.getSocket() == null) {
            return -1;
        }
        SPoller poller = new SPoller(item_, handler, arg);
        this.pollers.add(poller);
        this.dirty = true;
        if (this.verbose) {
            System.out.printf("I: zloop: register %s poller (%s, %s)\n", item.getSocket() != null ? item.getSocket().typeString() : "FD", item.getSocket(), item.getRawSocket());
        }
        return 0;
    }

    public void pollerEnd(ZMQ.PollItem item_) {
        PollItem item = item_.base();
        assert (item.getRawSocket() != null || item.getSocket() != null);
        Iterator<SPoller> it = this.pollers.iterator();
        while (it.hasNext()) {
            SPoller p = it.next();
            if (item.getSocket() != null && item.getSocket() == p.item.getSocket()) {
                it.remove();
                this.dirty = true;
            }
            if (item.getRawSocket() == null || item.getRawSocket() != p.item.getChannel()) continue;
            it.remove();
            this.dirty = true;
        }
        if (this.verbose) {
            System.out.printf("I: zloop: cancel %s poller (%s, %s)", item.getSocket() != null ? item.getSocket().typeString() : "FD", item.getSocket(), item.getRawSocket());
        }
    }

    public int timer(int delay, int times, IZLoopHandler handler, Object arg) {
        STimer timer = new STimer(delay, times, handler, arg);
        this.newTimers.add(timer);
        if (this.verbose) {
            System.out.printf("I: zloop: register timer delay=%d times=%d\n", delay, times);
        }
        return 0;
    }

    public int timerEnd(Object arg) {
        assert (arg != null);
        this.zombies.add(arg);
        if (this.verbose) {
            System.out.printf("I: zloop: cancel timer\n", new Object[0]);
        }
        return 0;
    }

    public void verbose(boolean verbose) {
        this.verbose = verbose;
    }

    public int start() {
        Selector selector;
        int rc = 0;
        this.timers.addAll(this.newTimers);
        this.newTimers.clear();
        for (STimer timer : this.timers) {
            timer.when = (long)timer.delay + System.currentTimeMillis();
        }
        try {
            selector = Selector.open();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            return -1;
        }
        while (!Thread.currentThread().isInterrupted()) {
            long wait;
            if (this.dirty) {
                this.rebuild();
            }
            if ((rc = ZMQ.zmq_poll(selector, this.pollset, wait = this.ticklessTimer())) == -1) {
                if (this.verbose) {
                    System.out.printf("I: zloop: interrupted\n", rc);
                }
                rc = 0;
                break;
            }
            Iterator<STimer> it = this.timers.iterator();
            while (it.hasNext()) {
                STimer timer = it.next();
                if (System.currentTimeMillis() < timer.when || timer.when == -1L) continue;
                if (this.verbose) {
                    System.out.println("I: zloop: call timer handler");
                }
                if ((rc = timer.handler.handle(this, null, timer.arg)) == -1) break;
                if (timer.times != 0 && --timer.times == 0) {
                    it.remove();
                    continue;
                }
                timer.when = (long)timer.delay + System.currentTimeMillis();
            }
            if (rc == -1) break;
            for (int item_nbr = 0; item_nbr < this.poll_size; ++item_nbr) {
                SPoller poller = this.pollact[item_nbr];
                assert (this.pollset[item_nbr].getSocket() == poller.item.getSocket());
                if (this.pollset[item_nbr].isError()) {
                    if (this.verbose) {
                        System.out.printf("I: zloop: can't poll %s socket (%s, %s)", poller.item.getSocket() != null ? poller.item.getSocket().typeString() : "FD", poller.item.getSocket(), poller.item.getChannel());
                    }
                    if (poller.errors++ > 0) {
                        this.pollerEnd(poller.item);
                    }
                } else {
                    poller.errors = 0;
                }
                if (this.pollset[item_nbr].readyOps() <= 0) continue;
                if (this.verbose) {
                    System.out.printf("I: zloop: call %s socket handler (%s, %s)\n", poller.item.getSocket() != null ? poller.item.getSocket().typeString() : "FD", poller.item.getSocket(), poller.item.getChannel());
                }
                if ((rc = poller.handler.handle(this, poller.item, poller.arg)) == -1) break;
            }
            for (Object arg : this.zombies) {
                it = this.timers.iterator();
                while (it.hasNext()) {
                    STimer timer = it.next();
                    if (timer.arg != arg) continue;
                    it.remove();
                }
            }
            this.timers.addAll(this.newTimers);
            this.newTimers.clear();
            if (rc != -1) continue;
            break;
        }
        try {
            selector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return rc;
    }

    private class STimer {
        int delay;
        int times;
        IZLoopHandler handler;
        Object arg;
        long when;

        public STimer(int delay, int times, IZLoopHandler handler, Object arg) {
            this.delay = delay;
            this.times = times;
            this.handler = handler;
            this.arg = arg;
            this.when = -1L;
        }
    }

    private class SPoller {
        ZMQ.PollItem item;
        IZLoopHandler handler;
        Object arg;
        int errors;

        protected SPoller(ZMQ.PollItem item, IZLoopHandler handler, Object arg) {
            this.item = item;
            this.handler = handler;
            this.arg = arg;
            this.errors = 0;
        }
    }

    public static interface IZLoopHandler {
        public int handle(ZLoop var1, ZMQ.PollItem var2, Object var3);
    }
}

