/*
 * Decompiled with CFR 0.152.
 */
package org.jeromq;

import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jeromq.ZMQ;

public class ZContext {
    private ZMQ.Context context = null;
    private List<ZMQ.Socket> sockets = new CopyOnWriteArrayList<ZMQ.Socket>();
    private int ioThreads;
    private int linger;
    private int hwm;
    private boolean main;

    public ZContext() {
        this(1);
    }

    public ZContext(int ioThreads_) {
        this.ioThreads = ioThreads_;
        this.linger = 0;
        this.main = true;
    }

    public void destroy() {
        ListIterator<ZMQ.Socket> itr = this.sockets.listIterator();
        while (itr.hasNext()) {
            this.destroySocket(itr.next());
        }
        this.sockets.clear();
        if (this.isMain() && this.context != null) {
            this.context.term();
        }
    }

    public ZMQ.Socket createSocket(int type) {
        if (this.context == null) {
            this.context = ZMQ.context(this.ioThreads);
        }
        ZMQ.Socket socket = this.context.socket(type);
        this.sockets.add(socket);
        return socket;
    }

    public void destroySocket(ZMQ.Socket s) {
        if (s == null) {
            return;
        }
        if (this.sockets.contains(s)) {
            s.setLinger(this.linger);
            s.close();
            this.sockets.remove(s);
        }
    }

    public static ZContext shadow(ZContext ctx) {
        ZContext shadow = new ZContext();
        shadow.setContext(ctx.getContext());
        shadow.setMain(false);
        return shadow;
    }

    public int getIoThreads() {
        return this.ioThreads;
    }

    public void setIoThreads(int ioThreads) {
        this.ioThreads = ioThreads;
    }

    public int getLinger() {
        return this.linger;
    }

    public void setLinger(int linger) {
        this.linger = linger;
    }

    public int getHWM() {
        return this.hwm;
    }

    public void setHWM(int hwm) {
        this.hwm = hwm;
    }

    public boolean isMain() {
        return this.main;
    }

    public void setMain(boolean main) {
        this.main = main;
    }

    public ZMQ.Context getContext() {
        return this.context;
    }

    public void setContext(ZMQ.Context ctx) {
        this.context = ctx;
    }

    public List<ZMQ.Socket> getSockets() {
        return this.sockets;
    }
}

