/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.portableInterceptor;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_RESOURCES;
import org.omg.CORBA.Object;
import org.omg.CORBA.TypeCode;
import org.omg.Dynamic.Parameter;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.InvalidSlot;
import org.omg.PortableInterceptor.RequestInfo;

public abstract class RequestInfoImpl
extends LocalObject
implements RequestInfo {
    protected int request_id;
    protected String operation;
    protected Parameter[] arguments = null;
    protected TypeCode[] exceptions = null;
    protected Any result = null;
    protected boolean response_expected;
    protected Object forward_reference = null;
    protected short reply_status = (short)5;
    protected Current current = null;
    protected short sync_scope;
    protected final Map<Integer, ServiceContext> request_ctx;
    protected final Map<Integer, ServiceContext> reply_ctx;
    protected short caller_op = (short)-1;

    public RequestInfoImpl() {
        this.request_ctx = new HashMap<Integer, ServiceContext>();
        this.reply_ctx = new HashMap<Integer, ServiceContext>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRequestServiceContexts(ServiceContext[] ctx) {
        Map<Integer, ServiceContext> map = this.request_ctx;
        synchronized (map) {
            for (int i = 0; i < ctx.length; ++i) {
                this.request_ctx.put(ctx[i].context_id, ctx[i]);
            }
        }
    }

    public Collection<ServiceContext> getRequestServiceContexts() {
        return this.request_ctx.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReplyServiceContexts(ServiceContext[] ctx) {
        Map<Integer, ServiceContext> map = this.reply_ctx;
        synchronized (map) {
            for (int i = 0; i < ctx.length; ++i) {
                this.reply_ctx.put(ctx[i].context_id, ctx[i]);
            }
        }
    }

    public Collection<ServiceContext> getReplyServiceContexts() {
        return this.reply_ctx.values();
    }

    public void setArguments(Parameter[] args) {
        this.arguments = args;
    }

    public void setResult(Any result) {
        this.result = result;
    }

    public Current current() {
        return this.current;
    }

    public void setCurrent(Current current) {
        this.current = current;
    }

    public void setReplyStatus(short reply_status) {
        this.reply_status = reply_status;
    }

    public void setForwardReference(Object forward_reference) {
        this.forward_reference = forward_reference;
    }

    @Override
    public Parameter[] arguments() {
        return this.arguments;
    }

    @Override
    public String[] contexts() {
        throw new NO_RESOURCES("JacORB does not support operation contexts", 1, CompletionStatus.COMPLETED_MAYBE);
    }

    @Override
    public TypeCode[] exceptions() {
        return this.exceptions;
    }

    @Override
    public Object forward_reference() {
        return this.forward_reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceContext get_reply_service_context(int id) {
        ServiceContext result;
        Map<Integer, ServiceContext> map = this.reply_ctx;
        synchronized (map) {
            result = this.reply_ctx.get(id);
        }
        if (result == null) {
            throw new BAD_PARAM("No ServiceContext with id " + id, 23, CompletionStatus.COMPLETED_MAYBE);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceContext get_request_service_context(int id) {
        ServiceContext result;
        Map<Integer, ServiceContext> map = this.request_ctx;
        synchronized (map) {
            result = this.request_ctx.get(id);
        }
        if (result == null) {
            throw new BAD_PARAM("No ServiceContext with id " + id, 23, CompletionStatus.COMPLETED_MAYBE);
        }
        return result;
    }

    @Override
    public Any get_slot(int id) throws InvalidSlot {
        return this.current.get_slot(id);
    }

    @Override
    public String operation() {
        return this.operation;
    }

    @Override
    public String[] operation_context() {
        throw new NO_RESOURCES("JacORB does not support operation contexts", 1, CompletionStatus.COMPLETED_MAYBE);
    }

    @Override
    public short reply_status() {
        return this.reply_status;
    }

    @Override
    public int request_id() {
        return this.request_id;
    }

    @Override
    public boolean response_expected() {
        return this.response_expected;
    }

    @Override
    public Any result() {
        if (this.result == null) {
            throw new NO_RESOURCES("Stream-based skeletons/stubs do not support this op", 1, CompletionStatus.COMPLETED_MAYBE);
        }
        return this.result;
    }

    @Override
    public short sync_scope() {
        return this.sync_scope;
    }
}

