/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.miop;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.TaggedComponentList;
import org.jacorb.orb.etf.ProfileBase;
import org.jacorb.orb.iiop.IIOPProfile;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.ETF.Profile;
import org.omg.GIOP.Version;
import org.omg.IOP.IOR;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentSeqHolder;
import org.omg.IOP.TaggedProfile;
import org.omg.IOP.TaggedProfileHolder;
import org.omg.MIOP.UIPMC_ProfileBody;
import org.omg.MIOP.UIPMC_ProfileBodyHelper;
import org.omg.PortableGroup.TagGroupTaggedComponent;
import org.omg.PortableGroup.TagGroupTaggedComponentHelper;

public class MIOPProfile
extends ProfileBase {
    private InetAddress inetAddress = null;
    private byte[] data = null;
    private UIPMC_ProfileBody uipmc = null;
    private TagGroupTaggedComponent tagGroup = null;
    private IIOPProfile groupIIOPProfile = null;

    public MIOPProfile(byte[] data) {
        this.data = data;
        CDRInputStream in = new CDRInputStream(data);
        in.openEncapsulatedArray();
        this.uipmc = UIPMC_ProfileBodyHelper.read(in);
        in.close();
        this.version = this.uipmc.miop_version;
    }

    public MIOPProfile(String address, short port, String domainId, long groupId, Version groupVersion, int groupRefVersion, IIOPProfile iiop) {
        this.groupIIOPProfile = iiop;
        this.tagGroup = new TagGroupTaggedComponent(groupVersion, domainId, groupId, groupRefVersion);
        TaggedComponentList list = new TaggedComponentList();
        list.addComponent(39, this.tagGroup, TagGroupTaggedComponentHelper.class);
        if (iiop != null) {
            list.addAll(iiop.getComponents());
        }
        this.uipmc = new UIPMC_ProfileBody(new Version(1, 0), address, port, list.asArray());
        try {
            this.inetAddress = InetAddress.getByName(this.uipmc.the_address);
        }
        catch (UnknownHostException uke) {
            throw new RuntimeException("Unable to create profile to unknown group address: " + this.uipmc.the_address);
        }
    }

    public MIOPProfile(String corbaloc) {
        this.corbalocStr = corbaloc;
    }

    @Override
    public void configure(Configuration config) throws ConfigurationException {
        super.configure(config);
        this.logger = this.configuration.getLogger("jacorb.miop");
        ORB orb = config.getORB();
        if (this.corbalocStr != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("MIOPProfile parsing corbaloc: " + this.corbalocStr);
            }
            if (!this.corbalocStr.startsWith("miop:")) {
                throw new IllegalArgumentException("URL must start with 'miop:'");
            }
            int sub = this.corbalocStr.indexOf(";");
            if (sub == -1) {
                this.parseMIOPCorbaloc(this.corbalocStr.substring(0));
            } else {
                this.parseMIOPCorbaloc(this.corbalocStr.substring(0, sub));
            }
            this.components = new TaggedComponentList();
            CDROutputStream out = new CDROutputStream();
            out.beginEncapsulatedArray();
            TagGroupTaggedComponentHelper.write(out, this.tagGroup);
            this.components.addComponent(39, out.getBufferCopy());
            out.close();
            if (sub != -1) {
                this.groupIIOPProfile = (IIOPProfile)new ParsedIOR(orb, "corbaloc:" + this.corbalocStr.substring(sub + 1)).getEffectiveProfile();
                this.objectKey = this.groupIIOPProfile.get_object_key();
                TaggedProfile taggedProfile = this.groupIIOPProfile.asTaggedProfile();
                this.components.addComponent(taggedProfile.tag, taggedProfile.profile_data);
            }
            this.uipmc.components = this.components.asArray();
        }
        if (this.tagGroup == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("MIOPProfile inspecting uipmc components.");
            }
            this.components = new TaggedComponentList();
            block6: for (int i = 0; i < this.uipmc.components.length; ++i) {
                TaggedComponent component = this.uipmc.components[i];
                this.components.addComponent(component);
                switch (component.tag) {
                    case 39: {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("MIOPProfile inspecting tagGroup.");
                        }
                        CDRInputStream in2 = new CDRInputStream(orb, component.component_data);
                        in2.openEncapsulatedArray();
                        this.tagGroup = TagGroupTaggedComponentHelper.read(in2);
                        in2.close();
                        continue block6;
                    }
                    case 0: {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("MIOPProfile inspecting group iiop profile.");
                        }
                        IOR ior = new IOR("IDL:omg.org/CORBA/Object:1.0", new TaggedProfile[]{new TaggedProfile(component.tag, component.component_data)});
                        this.groupIIOPProfile = (IIOPProfile)new ParsedIOR(orb, ior).getEffectiveProfile();
                    }
                }
            }
        }
        try {
            this.inetAddress = InetAddress.getByName(this.uipmc.the_address);
        }
        catch (UnknownHostException uke) {
            throw new RuntimeException("Unable to create profile to unknow group address: " + this.uipmc.the_address);
        }
    }

    @Override
    public byte[] get_object_key() {
        if (this.objectKey == null) {
            CDROutputStream out = new CDROutputStream();
            out.beginEncapsulatedArray();
            TagGroupTaggedComponentHelper.write(out, this.tagGroup);
            this.objectKey = out.getBufferCopy();
            out.close();
        }
        return this.objectKey;
    }

    @Override
    public int hash() {
        return this.hashCode();
    }

    @Override
    public boolean is_match(Profile profile) {
        return this.equals(profile);
    }

    @Override
    public void marshal(TaggedProfileHolder taggedProfile, TaggedComponentSeqHolder taggedComponentSeq) {
        if (this.data == null) {
            CDROutputStream out = new CDROutputStream();
            out.beginEncapsulatedArray();
            UIPMC_ProfileBodyHelper.write(out, this.uipmc);
            this.data = out.getBufferCopy();
            out.close();
        }
        taggedProfile.value = new TaggedProfile(3, this.data);
    }

    @Override
    public void set_object_key(byte[] objectKey) {
    }

    @Override
    public int tag() {
        return 3;
    }

    @Override
    public Version version() {
        return this.uipmc.miop_version;
    }

    public final InetAddress getGroupInetAddress() {
        return this.inetAddress;
    }

    public final UIPMC_ProfileBody getUIPMCProfile() {
        return this.uipmc;
    }

    public final TagGroupTaggedComponent getTagGroup() {
        return this.tagGroup;
    }

    public final IIOPProfile getGroupIIOPProfile() {
        return this.groupIIOPProfile;
    }

    public final String toString() {
        return this.uipmc.the_address + ":" + this.uipmc.the_port;
    }

    private void parseMIOPCorbaloc(String corbaloc) {
        int sep = (corbaloc = corbaloc.substring(corbaloc.indexOf(58) + 1)).indexOf(64);
        Version version = this.parseVersion(sep == -1 ? "" : corbaloc.substring(0, sep));
        corbaloc = corbaloc.substring(sep + 1);
        sep = corbaloc.indexOf(47);
        this.parseTagGroup(corbaloc.substring(0, sep));
        corbaloc = corbaloc.substring(sep + 1);
        this.parseGroupAddress(corbaloc);
        this.uipmc.miop_version = version;
    }

    private Version parseVersion(String ver_str) {
        int major = 1;
        int minor = 0;
        int sep = ver_str.indexOf(46);
        if (sep != -1) {
            try {
                major = Integer.parseInt(ver_str.substring(0, sep));
                minor = Integer.parseInt(ver_str.substring(sep + 1));
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Invalid version :" + ver_str);
            }
        }
        return new Version((byte)major, (byte)minor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parseTagGroup(String s) {
        this.tagGroup = new TagGroupTaggedComponent();
        if (s.indexOf(45) == -1) throw new IllegalArgumentException("Illegal group information format: " + s);
        try {
            StringTokenizer st = new StringTokenizer(s, "-");
            this.tagGroup.group_version = this.parseVersion(st.nextToken());
            this.tagGroup.group_domain_id = st.nextToken();
            this.tagGroup.object_group_id = Long.parseLong(st.nextToken());
            if (!st.hasMoreTokens()) return;
            this.tagGroup.object_group_ref_version = Integer.parseInt(st.nextToken());
            return;
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Illegal group information format: " + s);
        }
    }

    private void parseGroupAddress(String s) {
        this.uipmc = new UIPMC_ProfileBody();
        int sep = s.indexOf(58);
        if (sep != -1) {
            try {
                this.uipmc.the_port = (short)Integer.parseInt(s.substring(sep + 1));
                this.uipmc.the_address = s.substring(0, sep);
            }
            catch (NumberFormatException ill) {
                throw new IllegalArgumentException("Illegal port number in MIOP object address format: " + s);
            }
        }
    }

    @Override
    public void readAddressProfile(CDRInputStream stream) {
        throw new NO_IMPLEMENT("Not yet implemented");
    }

    @Override
    public void writeAddressProfile(CDROutputStream stream) {
        throw new NO_IMPLEMENT("Not yet implemented");
    }
}

