/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.etf;

import java.util.ArrayList;
import java.util.List;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.ORB;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NO_RESOURCES;
import org.omg.ETF.Connection;
import org.omg.ETF.Handle;
import org.omg.ETF.Profile;
import org.omg.ETF._ListenerLocalBase;
import org.slf4j.Logger;

public abstract class ListenerBase
extends _ListenerLocalBase
implements Configurable {
    protected ORB orb = null;
    protected Profile profile = null;
    protected Acceptor acceptor = null;
    protected Configuration configuration = null;
    protected Logger logger = null;
    protected Handle up = null;
    protected final List incoming_connections = new ArrayList();
    private boolean terminated = false;

    @Override
    public void configure(Configuration config) throws ConfigurationException {
        this.configuration = config;
        this.orb = this.configuration.getORB();
        this.logger = this.configuration.getLogger(this.configuration.getLoggerName(this.getClass()));
    }

    @Override
    public void set_handle(Handle up) {
        this.up = up;
    }

    @Override
    public void listen() {
        if (this.acceptor != null) {
            this.acceptor.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deliverConnection(Connection connection) {
        if (this.up != null) {
            if (!this.up.add_input(connection)) {
                connection.close();
                throw new NO_RESOURCES("Maximum number of server connections reached");
            }
        } else {
            List list = this.incoming_connections;
            synchronized (list) {
                this.incoming_connections.add(connection);
                this.incoming_connections.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection accept() {
        if (this.up != null) {
            throw new BAD_INV_ORDER("Must not call accept() when a Handle has been set");
        }
        List list = this.incoming_connections;
        synchronized (list) {
            while (!this.terminated && this.incoming_connections.isEmpty()) {
                try {
                    this.incoming_connections.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.terminated) {
                return (Connection)this.incoming_connections.remove(0);
            }
            return null;
        }
    }

    @Override
    public void completed_data(Connection conn) {
        throw new NO_IMPLEMENT();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        if (this.acceptor != null) {
            this.acceptor.terminate();
        }
        List list = this.incoming_connections;
        synchronized (list) {
            this.terminated = true;
            if (this.up == null) {
                this.incoming_connections.notifyAll();
            }
        }
    }

    @Override
    public Profile endpoint() {
        return this.profile.copy();
    }

    protected abstract class Acceptor
    extends Thread {
        protected Acceptor() {
        }

        protected abstract void init();

        @Override
        public abstract void run();

        public abstract void terminate();
    }
}

