/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.config;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class JacORBLogFormatter
extends Formatter {
    private final DateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private boolean showThread = false;

    public JacORBLogFormatter(boolean show_thread) {
        this.showThread = show_thread;
    }

    @Override
    public String format(LogRecord record) {
        String result = this.showThread ? String.format("%s %s [%d] %s\n", this.timeFormat.format(record.getMillis()), record.getLevel(), record.getThreadID(), record.getMessage()) : String.format("%s %s %s\n", this.timeFormat.format(record.getMillis()), record.getLevel(), record.getMessage());
        Throwable t = record.getThrown();
        return t == null ? result : result + this.getStackTrace(t);
    }

    private String getStackTrace(Throwable t) {
        StringBuffer result = new StringBuffer();
        for (StackTraceElement ste : t.getStackTrace()) {
            result.append("    ");
            result.append(ste.toString());
            result.append("\n");
        }
        return result.toString();
    }
}

