/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.CallBack;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.EventCallBackStruct;
import fr.esrf.TangoApi.events.EventChannelStruct;
import fr.esrf.TangoApi.events.EventConsumer;
import fr.esrf.TangoApi.events.IEventConsumer;
import fr.esrf.TangoApi.events.KeepAliveThread;
import fr.esrf.TangoApi.events.ZMQutils;
import fr.esrf.TangoApi.events.ZmqMainThread;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosNotification.StructuredEvent;

public class ZmqEventConsumer
extends EventConsumer
implements TangoConst,
Runnable,
IEventConsumer {
    private static ZmqEventConsumer instance = null;
    private Thread runner;

    public static ZmqEventConsumer getInstance() throws DevFailed {
        if (instance == null) {
            instance = new ZmqEventConsumer();
        }
        return instance;
    }

    private ZmqEventConsumer() throws DevFailed {
        ZmqMainThread zmqMainThread = new ZmqMainThread(ZMQutils.getContext());
        zmqMainThread.start();
        this.addShutdownHook();
    }

    private void addShutdownHook() {
        this.runner = new Thread(this);
        this.runner.setName("ZmqEventConsumer");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.out.println("======== Shutting down ZMQ event system ==========");
                KeepAliveThread.getInstance().stopThread();
                try {
                    ZmqEventConsumer.this.runner.join();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        });
        this.runner.start();
    }

    @Override
    public void run() {
    }

    @Override
    protected String getEventSubscriptionCommandName() {
        return "ZmqEventSubscriptionChange";
    }

    @Override
    protected void checkIfAlreadyConnected(DeviceProxy deviceProxy, String string, String string2, CallBack callBack, int n, boolean bl) throws DevFailed {
    }

    @Override
    protected void setAdditionalInfoToEventCallBackStruct(EventCallBackStruct eventCallBackStruct, String string, String string2, String string3, String[] stringArray, EventChannelStruct eventChannelStruct) throws DevFailed {
        ApiUtil.printTrace("-------------> Set as ZmqEventConsumer for " + string);
        eventCallBackStruct.consumer = this;
    }

    private void connect(DeviceProxy deviceProxy, String string, String string2, DeviceData deviceData) throws DevFailed {
        Object object;
        String string3 = deviceProxy.name();
        String string4 = null;
        int n = 0;
        try {
            string4 = deviceProxy.adm_name();
            n = new DeviceProxy(string4).getTangoVersion();
            if (n >= 810) {
                string4 = string4.toLowerCase();
            }
        }
        catch (DevFailed devFailed) {
            Except.throw_event_system_failed("API_BadConfigurationProperty", "Can't subscribe to event for device " + string3 + "\n Check that device server is running...", "ZmqEventConsumer.connect");
        }
        String string5 = string4;
        Database database = null;
        if (!channel_map.containsKey(string5)) {
            if (deviceProxy.use_db()) {
                database = deviceProxy.get_db_obj();
            }
            object = new EventConsumer.ConnectionStructure(deviceProxy.get_tango_host(), string5, string3, string, string2, database, deviceData, false);
            this.connect_event_channel((EventConsumer.ConnectionStructure)object);
        } else if (deviceProxy.use_db()) {
            database = deviceProxy.get_db_obj();
            ZMQutils.connectEvent(deviceProxy.get_tango_host(), string3, string, deviceData.extractLongStringArray(), string2, false);
        }
        object = (EventChannelStruct)channel_map.get(string5);
        ((EventChannelStruct)object).adm_device_proxy = new DeviceProxy(string4);
        ((EventChannelStruct)object).use_db = deviceProxy.use_db();
        ((EventChannelStruct)object).dbase = database;
        ((EventChannelStruct)object).setTangoRelease(n);
        device_channel_map.put(string3, string5);
    }

    private DeviceData checkZmqAddress(DeviceData deviceData, DeviceProxy deviceProxy) throws DevFailed {
        DevVarLongStringArray devVarLongStringArray = deviceData.extractLongStringArray();
        try {
            InetAddress inetAddress = InetAddress.getByName(deviceProxy.get_host_name());
            String string = inetAddress.getHostAddress();
            if (!devVarLongStringArray.svalue[0].startsWith("tcp://" + string)) {
                String string2 = devVarLongStringArray.svalue[0];
                int n = devVarLongStringArray.svalue[0].lastIndexOf(58);
                if (n > 0) {
                    devVarLongStringArray.svalue[0] = "tcp://" + string + devVarLongStringArray.svalue[0].substring(n);
                    devVarLongStringArray.svalue[1] = "tcp://" + string + devVarLongStringArray.svalue[1].substring(n);
                    System.out.println(string2 + " ---> " + devVarLongStringArray.svalue[0]);
                    deviceData = new DeviceData();
                    deviceData.insert(devVarLongStringArray);
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            Except.throw_exception("UnknownHostException", unknownHostException.toString(), "ZmqEventConsumer.checkZmqAddress()");
        }
        return deviceData;
    }

    @Override
    protected void checkDeviceConnection(DeviceProxy deviceProxy, String string, DeviceData deviceData, String string2) throws DevFailed {
        deviceData = this.checkZmqAddress(deviceData, deviceProxy);
        String string3 = deviceProxy.name();
        ApiUtil.printTrace("checkDeviceConnection for " + string3);
        if (!device_channel_map.containsKey(string3)) {
            ApiUtil.printTrace("    Does NOT Exist");
            this.connect(deviceProxy, string, string2, deviceData);
            if (!device_channel_map.containsKey(string3)) {
                Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to connect to event channel for device", "EventConsumer.subscribe_event()");
            }
        } else {
            ApiUtil.printTrace(string3 + " already connected.");
            ZMQutils.connectEvent(deviceProxy.get_tango_host(), string3, string, deviceData.extractLongStringArray(), string2, false);
        }
    }

    @Override
    protected synchronized void connect_event_channel(EventConsumer.ConnectionStructure connectionStructure) throws DevFailed {
        DeviceProxy deviceProxy = new DeviceProxy(connectionStructure.channelName);
        DevVarLongStringArray devVarLongStringArray = connectionStructure.deviceData.extractLongStringArray();
        ApiUtil.printTrace("connect_event_channel for " + connectionStructure.channelName);
        ZMQutils.connectHeartbeat(deviceProxy.get_tango_host(), deviceProxy.name(), devVarLongStringArray, false);
        ZMQutils.connectEvent(connectionStructure.tangoHost, connectionStructure.deviceName, connectionStructure.attributeName, devVarLongStringArray, connectionStructure.eventName, false);
        if (connectionStructure.reconnect) {
            EventChannelStruct eventChannelStruct = (EventChannelStruct)channel_map.get(connectionStructure.channelName);
            eventChannelStruct.last_heartbeat = System.currentTimeMillis();
            eventChannelStruct.heartbeat_skipped = false;
            eventChannelStruct.has_notifd_closed_the_connection = 0;
            eventChannelStruct.setTangoRelease(devVarLongStringArray.lvalue[0]);
            eventChannelStruct.setIdlVersion(devVarLongStringArray.lvalue[1]);
        } else {
            EventChannelStruct eventChannelStruct = new EventChannelStruct();
            eventChannelStruct.last_heartbeat = System.currentTimeMillis();
            eventChannelStruct.heartbeat_skipped = false;
            eventChannelStruct.adm_device_proxy = deviceProxy;
            eventChannelStruct.has_notifd_closed_the_connection = 0;
            eventChannelStruct.consumer = this;
            eventChannelStruct.zmqEndpoint = devVarLongStringArray.svalue[0];
            eventChannelStruct.setTangoRelease(devVarLongStringArray.lvalue[0]);
            eventChannelStruct.setIdlVersion(devVarLongStringArray.lvalue[1]);
            channel_map.put(connectionStructure.channelName, eventChannelStruct);
            ApiUtil.printTrace("Adding " + connectionStructure.channelName + " to channel_map");
        }
    }

    @Override
    protected boolean reSubscribe(EventChannelStruct eventChannelStruct, EventCallBackStruct eventCallBackStruct) {
        boolean bl = false;
        try {
            ApiUtil.printTrace("====================================================\n   Try to resubscribe " + eventCallBackStruct.channel_name);
            DevVarLongStringArray devVarLongStringArray = ZMQutils.getEventSubscriptionInfoFromAdmDevice(eventChannelStruct.adm_device_proxy, eventCallBackStruct.device.name(), eventCallBackStruct.attr_name, eventCallBackStruct.event_name);
            String string = eventChannelStruct.adm_device_proxy.name();
            if (eventChannelStruct.getTangoRelease() >= 810) {
                string = string.toLowerCase();
            }
            this.push_structured_event_heartbeat(string);
            eventChannelStruct.heartbeat_skipped = false;
            eventChannelStruct.last_subscribed = System.currentTimeMillis();
            eventChannelStruct.setTangoRelease(devVarLongStringArray.lvalue[0]);
            eventChannelStruct.setIdlVersion(devVarLongStringArray.lvalue[1]);
            eventCallBackStruct.last_subscribed = eventChannelStruct.last_subscribed;
            bl = true;
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        return bl;
    }

    @Override
    protected void removeFilters(EventCallBackStruct eventCallBackStruct) throws DevFailed {
    }

    @Override
    protected void checkIfHeartbeatSkipped(String string, EventChannelStruct eventChannelStruct) {
        if (KeepAliveThread.heartbeatHasBeenSkipped(eventChannelStruct)) {
            Object object;
            DevError devError = null;
            try {
                object = eventChannelStruct.adm_device_proxy.fullName();
                if (eventChannelStruct.getTangoRelease() >= 810) {
                    object = ((String)object).toLowerCase();
                }
                eventChannelStruct.adm_device_proxy = new DeviceProxy((String)object);
                eventChannelStruct.adm_device_proxy.set_timeout_millis(300);
                eventChannelStruct.adm_device_proxy.ping();
                this.reconnectToChannel(string);
            }
            catch (DevFailed devFailed) {
                devError = devFailed.errors[0];
            }
            object = EventConsumer.getEventCallbackMap().elements();
            while (object.hasMoreElements()) {
                EventCallBackStruct eventCallBackStruct = (EventCallBackStruct)object.nextElement();
                if (!eventCallBackStruct.channel_name.equals(string)) continue;
                if (devError != null) {
                    this.pushReceivedException(eventChannelStruct, eventCallBackStruct, devError);
                }
                if (eventCallBackStruct.event_name.equals(eventNames[6]) || !this.reconnectToEvent(eventChannelStruct, eventCallBackStruct)) continue;
                this.readAttributeAndPush(eventChannelStruct, eventCallBackStruct);
            }
        }
    }

    @Override
    protected void unsubscribeTheEvent(EventCallBackStruct eventCallBackStruct) throws DevFailed {
        ZMQutils.disConnectEvent(eventCallBackStruct.device.get_tango_host(), eventCallBackStruct.device.name(), eventCallBackStruct.attr_name, eventCallBackStruct.event_name);
    }

    @Override
    public void push_structured_event(StructuredEvent structuredEvent) throws Disconnected {
    }

    private boolean reconnectToEvent(EventChannelStruct eventChannelStruct, EventCallBackStruct eventCallBackStruct) {
        boolean bl;
        try {
            DevVarLongStringArray devVarLongStringArray = ZMQutils.getEventSubscriptionInfoFromAdmDevice(eventChannelStruct.adm_device_proxy, eventCallBackStruct.device.name(), eventCallBackStruct.attr_name, eventCallBackStruct.event_name);
            ZMQutils.connectEvent(eventCallBackStruct.device.get_tango_host(), eventCallBackStruct.device.name(), eventCallBackStruct.attr_name, devVarLongStringArray, eventCallBackStruct.event_name, true);
            bl = true;
        }
        catch (DevFailed devFailed) {
            System.err.println(devFailed.errors[0].desc);
            bl = false;
        }
        return bl;
    }

    private boolean reconnectToChannel(String string) {
        boolean bl = false;
        Enumeration enumeration = event_callback_map.elements();
        while (enumeration.hasMoreElements()) {
            EventCallBackStruct eventCallBackStruct = (EventCallBackStruct)enumeration.nextElement();
            if (!eventCallBackStruct.channel_name.equals(string) || eventCallBackStruct.callback == null) continue;
            try {
                EventChannelStruct eventChannelStruct = (EventChannelStruct)channel_map.get(string);
                DevVarLongStringArray devVarLongStringArray = ZMQutils.getEventSubscriptionInfoFromAdmDevice(eventChannelStruct.adm_device_proxy, eventCallBackStruct.device.name(), eventCallBackStruct.attr_name, eventCallBackStruct.event_name);
                ZMQutils.connectHeartbeat(eventChannelStruct.adm_device_proxy.get_tango_host(), eventChannelStruct.adm_device_proxy.name(), devVarLongStringArray, true);
                bl = true;
            }
            catch (DevFailed devFailed) {
                bl = false;
            }
            break;
        }
        return bl;
    }
}

