/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.EventData;
import fr.esrf.TangoApi.events.EventDispatcher;
import fr.esrf.TangoApi.events.EventUtil;
import fr.esrf.TangoApi.events.ITangoUserListener;
import fr.esrf.TangoApi.events.TangoUserEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.SwingUtilities;

public class TangoUser
extends EventDispatcher
implements Serializable {
    String attr_name;
    int event_identifier;
    String[] filters;

    public TangoUser(DeviceProxy deviceProxy, String string, String[] stringArray) {
        super(deviceProxy);
        this.attr_name = string;
        this.filters = stringArray;
        this.event_identifier = -1;
    }

    public void addTangoUserListener(ITangoUserListener iTangoUserListener, boolean bl) throws DevFailed {
        this.event_listeners.add(ITangoUserListener.class, iTangoUserListener);
        this.event_identifier = this.subscribe_user_event(this.attr_name, this.filters, bl);
    }

    public void removeTangoUserListener(ITangoUserListener iTangoUserListener) throws DevFailed {
        this.event_listeners.remove(ITangoUserListener.class, iTangoUserListener);
        if (this.event_listeners.size() == 0) {
            this.unsubscribe_event(this.event_identifier);
        }
    }

    @Override
    public void dispatch_event(final EventData eventData) {
        final TangoUser tangoUser = this;
        if (EventUtil.graphicAvailable()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    TangoUser.this.fireTangoUserEvent(tangoUser, eventData);
                }
            };
            SwingUtilities.invokeLater(runnable);
        } else {
            this.fireTangoUserEvent(tangoUser, eventData);
        }
    }

    private void fireTangoUserEvent(TangoUser tangoUser, EventData eventData) {
        TangoUserEvent tangoUserEvent = new TangoUserEvent(tangoUser, eventData);
        ArrayList<EventListener> arrayList = this.event_listeners.getListeners(ITangoUserListener.class);
        for (EventListener eventListener : arrayList) {
            ((ITangoUserListener)eventListener).user(tangoUserEvent);
        }
    }
}

