/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.EventData;
import fr.esrf.TangoApi.events.EventDispatcher;
import fr.esrf.TangoApi.events.EventUtil;
import fr.esrf.TangoApi.events.ITangoPeriodicListener;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.SwingUtilities;

public class TangoPeriodic
extends EventDispatcher
implements Serializable {
    String attr_name;
    int event_identifier;
    String[] filters;

    public TangoPeriodic(DeviceProxy deviceProxy, String string, String[] stringArray) {
        super(deviceProxy);
        this.attr_name = string;
        this.filters = stringArray;
        this.event_identifier = -1;
    }

    public void addTangoPeriodicListener(ITangoPeriodicListener iTangoPeriodicListener, boolean bl) throws DevFailed {
        this.event_listeners.add(ITangoPeriodicListener.class, iTangoPeriodicListener);
        this.event_identifier = this.subscribe_periodic_event(this.attr_name, this.filters, bl);
    }

    public void removeTangoPeriodicListener(ITangoPeriodicListener iTangoPeriodicListener) throws DevFailed {
        this.event_listeners.remove(ITangoPeriodicListener.class, iTangoPeriodicListener);
        if (this.event_listeners.size() == 0) {
            this.unsubscribe_event(this.event_identifier);
        }
    }

    @Override
    public void dispatch_event(final EventData eventData) {
        final TangoPeriodic tangoPeriodic = this;
        if (EventUtil.graphicAvailable()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    TangoPeriodic.this.fireTangoPeriodicEvent(tangoPeriodic, eventData);
                }
            };
            SwingUtilities.invokeLater(runnable);
        } else {
            this.fireTangoPeriodicEvent(tangoPeriodic, eventData);
        }
    }

    private void fireTangoPeriodicEvent(TangoPeriodic tangoPeriodic, EventData eventData) {
        TangoPeriodicEvent tangoPeriodicEvent = new TangoPeriodicEvent(tangoPeriodic, eventData);
        ArrayList<EventListener> arrayList = this.event_listeners.getListeners(ITangoPeriodicListener.class);
        for (EventListener eventListener : arrayList) {
            ((ITangoPeriodicListener)eventListener).periodic(tangoPeriodicEvent);
        }
    }
}

