/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.EventData;
import fr.esrf.TangoApi.events.EventDispatcher;
import fr.esrf.TangoApi.events.EventUtil;
import fr.esrf.TangoApi.events.ITangoDataReadyListener;
import fr.esrf.TangoApi.events.TangoDataReadyEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.SwingUtilities;

public class TangoDataReady
extends EventDispatcher
implements Serializable {
    String attr_name;
    int event_identifier;
    String[] filters;

    public TangoDataReady(DeviceProxy deviceProxy, String string, String[] stringArray) {
        super(deviceProxy);
        this.attr_name = string;
        this.filters = stringArray;
        this.event_identifier = -1;
    }

    public void addTangoDataReadyListener(ITangoDataReadyListener iTangoDataReadyListener, boolean bl) throws DevFailed {
        this.event_listeners.add(ITangoDataReadyListener.class, iTangoDataReadyListener);
        this.event_identifier = this.subscribe_data_ready_event(this.attr_name, this.filters, bl);
    }

    public void removeTangoDataReadyListener(ITangoDataReadyListener iTangoDataReadyListener) throws DevFailed {
        this.event_listeners.remove(ITangoDataReadyListener.class, iTangoDataReadyListener);
        if (this.event_listeners.size() == 0) {
            this.unsubscribe_event(this.event_identifier);
        }
    }

    @Override
    public void dispatch_event(final EventData eventData) {
        final TangoDataReady tangoDataReady = this;
        if (EventUtil.graphicAvailable()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    TangoDataReady.this.fireTangoDataReadyEvent(tangoDataReady, eventData);
                }
            };
            SwingUtilities.invokeLater(runnable);
        } else {
            this.fireTangoDataReadyEvent(tangoDataReady, eventData);
        }
    }

    private void fireTangoDataReadyEvent(TangoDataReady tangoDataReady, EventData eventData) {
        TangoDataReadyEvent tangoDataReadyEvent = new TangoDataReadyEvent(tangoDataReady, eventData);
        ArrayList<EventListener> arrayList = this.event_listeners.getListeners(ITangoDataReadyListener.class);
        for (EventListener eventListener : arrayList) {
            ((ITangoDataReadyListener)eventListener).data_ready(tangoDataReadyEvent);
        }
    }
}

