/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.EventData;
import fr.esrf.TangoApi.events.EventDispatcher;
import fr.esrf.TangoApi.events.EventUtil;
import fr.esrf.TangoApi.events.ITangoChangeListener;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.SwingUtilities;

public class TangoChange
extends EventDispatcher
implements Serializable {
    String attr_name;
    int event_identifier;
    String[] filters;

    public TangoChange(DeviceProxy deviceProxy, String string, String[] stringArray) {
        super(deviceProxy);
        this.attr_name = string;
        this.filters = stringArray;
        this.event_identifier = -1;
    }

    public void addTangoChangeListener(ITangoChangeListener iTangoChangeListener, boolean bl) throws DevFailed {
        this.event_listeners.add(ITangoChangeListener.class, iTangoChangeListener);
        this.event_identifier = this.subscribe_change_event(this.attr_name, this.filters, bl);
    }

    public void removeTangoChangeListener(ITangoChangeListener iTangoChangeListener) throws DevFailed {
        this.event_listeners.remove(ITangoChangeListener.class, iTangoChangeListener);
        if (this.event_listeners.size() == 0) {
            this.unsubscribe_event(this.event_identifier);
        }
    }

    @Override
    public void dispatch_event(final EventData eventData) {
        final TangoChange tangoChange = this;
        if (EventUtil.graphicAvailable()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    TangoChange.this.fireTangoChangeEvent(tangoChange, eventData);
                }
            };
            SwingUtilities.invokeLater(runnable);
        } else {
            this.fireTangoChangeEvent(tangoChange, eventData);
        }
    }

    private void fireTangoChangeEvent(TangoChange tangoChange, EventData eventData) {
        TangoChangeEvent tangoChangeEvent = new TangoChangeEvent(tangoChange, eventData);
        ArrayList<EventListener> arrayList = this.event_listeners.getListeners(ITangoChangeListener.class);
        for (EventListener eventListener : arrayList) {
            ((ITangoChangeListener)eventListener).change(tangoChangeEvent);
        }
    }
}

