/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.EventData;
import fr.esrf.TangoApi.events.EventDispatcher;
import fr.esrf.TangoApi.events.EventUtil;
import fr.esrf.TangoApi.events.ITangoArchiveListener;
import fr.esrf.TangoApi.events.TangoArchiveEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.SwingUtilities;

public class TangoArchive
extends EventDispatcher
implements Serializable {
    String attr_name;
    int event_identifier;
    String[] filters;

    public TangoArchive(DeviceProxy deviceProxy, String string, String[] stringArray) {
        super(deviceProxy);
        this.attr_name = string;
        this.filters = stringArray;
        this.event_identifier = -1;
    }

    public void addTangoArchiveListener(ITangoArchiveListener iTangoArchiveListener, boolean bl) throws DevFailed {
        this.event_listeners.add(ITangoArchiveListener.class, iTangoArchiveListener);
        this.event_identifier = this.subscribe_archive_event(this.attr_name, this.filters, bl);
    }

    public void removeTangoArchiveListener(ITangoArchiveListener iTangoArchiveListener) throws DevFailed {
        this.event_listeners.remove(ITangoArchiveListener.class, iTangoArchiveListener);
        if (this.event_listeners.size() == 0) {
            this.unsubscribe_event(this.event_identifier);
        }
    }

    @Override
    public void dispatch_event(final EventData eventData) {
        final TangoArchive tangoArchive = this;
        if (EventUtil.graphicAvailable()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    TangoArchive.this.fireTangoArchiveEvent(tangoArchive, eventData);
                }
            };
            SwingUtilities.invokeLater(runnable);
        } else {
            this.fireTangoArchiveEvent(tangoArchive, eventData);
        }
    }

    private void fireTangoArchiveEvent(TangoArchive tangoArchive, EventData eventData) {
        TangoArchiveEvent tangoArchiveEvent = new TangoArchiveEvent(tangoArchive, eventData);
        ArrayList<EventListener> arrayList = this.event_listeners.getListeners(ITangoArchiveListener.class);
        for (EventListener eventListener : arrayList) {
            ((ITangoArchiveListener)eventListener).archive(tangoArchiveEvent);
        }
    }
}

