/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.Tango.AttDataReady;
import fr.esrf.Tango.AttDataReadyHelper;
import fr.esrf.Tango.AttributeConfigHelper;
import fr.esrf.Tango.AttributeConfig_3Helper;
import fr.esrf.Tango.AttributeValueHelper;
import fr.esrf.Tango.AttributeValue_3Helper;
import fr.esrf.Tango.AttributeValue_4Helper;
import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevErrorListHelper;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.ErrSeverity;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.CallBack;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.DeviceProxyFactory;
import fr.esrf.TangoApi.IORdump;
import fr.esrf.TangoApi.events.DbEventImportInfo;
import fr.esrf.TangoApi.events.EventCallBackStruct;
import fr.esrf.TangoApi.events.EventChannelStruct;
import fr.esrf.TangoApi.events.EventConsumer;
import fr.esrf.TangoApi.events.EventData;
import fr.esrf.TangoApi.events.EventQueue;
import fr.esrf.TangoApi.events.IEventConsumer;
import fr.esrf.TangoApi.events.KeepAliveThread;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import java.util.Enumeration;
import org.jacorb.orb.policies.RelativeRoundtripTimeoutPolicy;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.UserException;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventChannelAdmin.TypeError;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyChannelAdmin.AdminLimitExceeded;
import org.omg.CosNotifyChannelAdmin.ClientType;
import org.omg.CosNotifyChannelAdmin.ConsumerAdmin;
import org.omg.CosNotifyChannelAdmin.EventChannel;
import org.omg.CosNotifyChannelAdmin.EventChannelHelper;
import org.omg.CosNotifyChannelAdmin.ProxySupplier;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPushSupplier;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPushSupplierHelper;
import org.omg.CosNotifyFilter.ConstraintExp;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.FilterNotFound;
import org.omg.CosNotifyFilter.InvalidConstraint;
import org.omg.CosNotifyFilter.InvalidGrammar;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;

public class NotifdEventConsumer
extends EventConsumer
implements TangoConst,
Runnable,
IEventConsumer {
    private static NotifdEventConsumer instance = null;
    private EventChannel eventChannel;
    private ConsumerAdmin consumerAdmin;
    private ProxySupplier proxySupplier;
    private ORB orb = ApiUtil.get_orb();
    private Thread runner = new Thread(this);
    private boolean orbRunning = false;

    public static NotifdEventConsumer create() throws DevFailed {
        if (instance == null) {
            instance = new NotifdEventConsumer();
        }
        return instance;
    }

    public static NotifdEventConsumer getInstance() throws DevFailed {
        if (instance == null) {
            instance = new NotifdEventConsumer();
        }
        return instance;
    }

    private NotifdEventConsumer() throws DevFailed {
        this.runner.setName("NotifdEventConsumer");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.out.println("======== Shutting down notifd event system =======");
                NotifdEventConsumer.this.cleanup_heartbeat_filters();
                NotifdEventConsumer.this.cleanup_event_filters();
                NotifdEventConsumer.this.cleanup_heartbeat_proxies();
                KeepAliveThread.getInstance().stopThread();
                if (NotifdEventConsumer.this.orbRunning) {
                    NotifdEventConsumer.this.orb.shutdown(true);
                    try {
                        NotifdEventConsumer.this.runner.join();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
        });
        this.runner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block5: {
            try {
                if (ApiUtil.in_server()) break block5;
                NotifdEventConsumer notifdEventConsumer = this;
                synchronized (notifdEventConsumer) {
                    Object object = this.orb.resolve_initial_references("RootPOA");
                    POA pOA = POAHelper.narrow(object);
                    POAManager pOAManager = pOA.the_POAManager();
                    pOAManager.activate();
                }
                this.orbRunning = true;
                this.orb.run();
                this.orb.destroy();
            }
            catch (UserException userException) {
                System.out.println("EventConsumer.run() : Unable to start orb");
                userException.printStackTrace();
                System.exit(1);
            }
        }
    }

    private java.lang.Object extractAttributeObject(StructuredEvent structuredEvent) throws BadKind {
        TypeCode typeCode = structuredEvent.remainder_of_body.type();
        if (typeCode.kind().equals(TCKind.tk_struct)) {
            String string = typeCode.name();
            if (string.equals("AttDataReady")) {
                return AttDataReadyHelper.extract(structuredEvent.remainder_of_body);
            }
            if (string.equals("AttributeConfig_3")) {
                return new AttributeInfoEx(AttributeConfig_3Helper.extract(structuredEvent.remainder_of_body));
            }
            if (string.equals("AttributeConfig_2")) {
                return new AttributeInfoEx(AttributeConfigHelper.extract(structuredEvent.remainder_of_body));
            }
            if (string.equals("AttributeValue_4")) {
                return new DeviceAttribute(AttributeValue_4Helper.extract(structuredEvent.remainder_of_body));
            }
            if (string.equals("AttributeValue_3")) {
                return new DeviceAttribute(AttributeValue_3Helper.extract(structuredEvent.remainder_of_body));
            }
            if (string.equals("AttributeValue")) {
                return new DeviceAttribute(AttributeValueHelper.extract(structuredEvent.remainder_of_body));
            }
            DevError[] devErrorArray = new DevError[]{new DevError("API_IncompatibleAttrDataType", ErrSeverity.ERR, "Unknown structure used to pass attribute value (Need compilation ?)", "EventConsumer::extractAttributeObject()")};
            return devErrorArray;
        }
        return DevErrorListHelper.extract(structuredEvent.remainder_of_body);
    }

    @Override
    public void push_structured_event(StructuredEvent structuredEvent) {
        String string = structuredEvent.header.fixed_header.event_type.domain_name;
        String string2 = structuredEvent.header.fixed_header.event_name;
        try {
            if (string2.equals("heartbeat")) {
                this.push_structured_event_heartbeat(string);
                return;
            }
            String string3 = string + "." + string2;
            if (event_callback_map.containsKey(string3)) {
                EventCallBackStruct eventCallBackStruct = (EventCallBackStruct)event_callback_map.get(string3);
                CallBack callBack = eventCallBackStruct.callback;
                DeviceAttribute deviceAttribute = null;
                AttributeInfoEx attributeInfoEx = null;
                AttDataReady attDataReady = null;
                DevError[] devErrorArray = null;
                java.lang.Object object = this.extractAttributeObject(structuredEvent);
                if (object instanceof AttributeInfoEx) {
                    attributeInfoEx = (AttributeInfoEx)object;
                } else if (object instanceof AttDataReady) {
                    attDataReady = (AttDataReady)object;
                } else if (object instanceof DeviceAttribute) {
                    deviceAttribute = (DeviceAttribute)object;
                } else if (object instanceof DevError[]) {
                    devErrorArray = (DevError[])object;
                }
                EventData eventData = new EventData(eventCallBackStruct.device, string, string2, eventCallBackStruct.event_type, 1, deviceAttribute, attributeInfoEx, attDataReady, devErrorArray);
                if (eventCallBackStruct.use_ev_queue) {
                    EventQueue eventQueue = eventCallBackStruct.device.getEventQueue();
                    eventQueue.insert_event(eventData);
                } else if (callBack != null) {
                    callBack.push_event(eventData);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void cleanup_event_filters() {
        Enumeration enumeration = event_callback_map.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            EventCallBackStruct eventCallBackStruct = (EventCallBackStruct)event_callback_map.get(string);
            if (!(eventCallBackStruct.consumer instanceof NotifdEventConsumer)) continue;
            try {
                EventChannelStruct eventChannelStruct = (EventChannelStruct)channel_map.get(eventCallBackStruct.channel_name);
                Filter filter = eventChannelStruct.structuredProxyPushSupplier.get_filter(eventCallBackStruct.filter_id);
                eventChannelStruct.structuredProxyPushSupplier.remove_filter(eventCallBackStruct.filter_id);
                filter.destroy();
            }
            catch (FilterNotFound filterNotFound) {}
        }
    }

    private void cleanup_heartbeat_proxies() {
        Enumeration enumeration = event_callback_map.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            EventCallBackStruct eventCallBackStruct = (EventCallBackStruct)event_callback_map.get(string);
            try {
                EventChannelStruct eventChannelStruct = (EventChannelStruct)channel_map.get(eventCallBackStruct.channel_name);
                if (eventChannelStruct.structuredProxyPushSupplier != null) {
                    eventChannelStruct.structuredProxyPushSupplier.disconnect_structured_push_supplier();
                    eventChannelStruct.structuredProxyPushSupplier = null;
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            event_callback_map.remove(string);
        }
    }

    private DbEventImportInfo getEventImportInfo(String string, Database database, DeviceProxy deviceProxy) throws DevFailed {
        DbEventImportInfo dbEventImportInfo = null;
        try {
            if (database != null) {
                deviceProxy = DeviceProxyFactory.get(string, database.getUrl().getTangoHost());
                dbEventImportInfo = deviceProxy.get_evt_import_info();
                if (dbEventImportInfo == null || !dbEventImportInfo.channel_exported) {
                    dbEventImportInfo = database.import_event(string);
                }
            } else {
                dbEventImportInfo = new DbEventImportInfo();
                deviceProxy = DeviceProxyFactory.get(string);
                DeviceData deviceData = deviceProxy.command_inout("QueryEventChannelIOR");
                dbEventImportInfo.channel_ior = deviceData.extractString();
                dbEventImportInfo.channel_exported = true;
                IORdump iORdump = new IORdump(null, dbEventImportInfo.channel_ior);
                dbEventImportInfo.host = iORdump.get_hostname();
            }
        }
        catch (DevFailed devFailed) {
            if (database != null) {
                Except.throw_event_system_failed("API_NotificationServiceFailed", string + " has no event channel defined in the database " + database.getUrl().getTangoHost() + "\nMay be the server is not running.", "EventConsumer.connect_event_channel");
            }
            Except.throw_event_system_failed("API_NotificationServiceFailed", string + " did not returned event channel IOR\n" + " May be the server is not running.", "EventConsumer.connect_event_channel");
        }
        return dbEventImportInfo;
    }

    @Override
    protected void checkDeviceConnection(DeviceProxy deviceProxy, String string, DeviceData deviceData, String string2) throws DevFailed {
        String string3 = deviceProxy.name();
        if (!device_channel_map.containsKey(string3)) {
            this.connect(deviceProxy, string, string2, deviceData);
            if (!device_channel_map.containsKey(string3)) {
                Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to connect to event channel for device", "EventConsumer.subscribe_event()");
            }
        }
    }

    private void connectToNotificationDaemon(DbEventImportInfo dbEventImportInfo) throws DevFailed {
        java.lang.Object object;
        boolean bl = dbEventImportInfo.channel_exported;
        if (bl) {
            object = this.orb.string_to_object(dbEventImportInfo.channel_ior);
            try {
                this.eventChannel = EventChannelHelper.narrow((Object)object);
                RelativeRoundtripTimeoutPolicy relativeRoundtripTimeoutPolicy = new RelativeRoundtripTimeoutPolicy(30000000L);
                this.eventChannel._set_policy_override(new Policy[]{relativeRoundtripTimeoutPolicy}, SetOverrideType.ADD_OVERRIDE);
            }
            catch (RuntimeException runtimeException) {
                Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to connect notification daemon (hint : make sure the notifd daemon is running on this host", "EventConsumer.connect_event_channel");
            }
            if (this.eventChannel == null) {
                bl = false;
            }
        }
        if (!bl) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to narrow EventChannel from notification daemon (hint : make sure the notifd daemon is running on this host", "EventConsumer.connect_event_channel");
        }
        try {
            this.consumerAdmin = this.eventChannel.default_consumer_admin();
        }
        catch (Exception exception) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Received " + exception.toString() + "\nduring eventChannel.default_consumer_admin() call", "EventConsumer.connect_event_channel");
        }
        if (this.consumerAdmin == null) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to get default consumer admin from notification daemon (hint : make sure the notifd daemon is running on this host", "EventConsumer.connect_event_channel");
        }
        object = new IntHolder();
        try {
            this.proxySupplier = this.consumerAdmin.obtain_notification_push_supplier(ClientType.STRUCTURED_EVENT, (IntHolder)object);
            if (this.proxySupplier == null) {
                Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to get a push supplier from notification daemon (hint : make sure the notifd daemon is running on this host", "EventConsumer.connect_event_channel");
            }
        }
        catch (TIMEOUT tIMEOUT) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to get a push supplier due to a Timeout", "EventConsumer.connect_event_channel");
        }
        catch (AdminLimitExceeded adminLimitExceeded) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to get a push supplier due to AdminLimitExceeded (hint : make sure the notifd daemon is running on this host", "EventConsumer.connect_event_channel");
        }
    }

    private StructuredProxyPushSupplier getStructuredProxyPushSupplier(String string) throws DevFailed {
        StructuredProxyPushSupplier structuredProxyPushSupplier = StructuredProxyPushSupplierHelper.narrow(this.proxySupplier);
        if (structuredProxyPushSupplier == null) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to narrow the push supplier due to AdminLimitExceeded (hint : make sure the notifd daemon is running on this host", "EventConsumer.connect_event_channel");
        }
        try {
            structuredProxyPushSupplier.connect_structured_push_consumer(this._this(this.orb));
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            Except.throw_event_system_failed("API_NotificationServiceFailed", nullPointerException + " detected when subscribing to " + string, "EventConsumer.connect_event_channel");
        }
        catch (AlreadyConnected alreadyConnected) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to connect the push supplier due to CosEventChannelAdmin.AlreadyConnected.AlreadyConnected  exception", "EventConsumer.connect_event_channel");
        }
        catch (TypeError typeError) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to connect the push supplier due to CosEventChannelAdmin.AlreadyConnected.TypeError  exception", "EventConsumer.connect_event_channel");
        }
        return structuredProxyPushSupplier;
    }

    private void connect(DeviceProxy deviceProxy, String string, String string2, DeviceData deviceData) throws DevFailed {
        java.lang.Object object;
        String string3 = deviceProxy.name();
        String string4 = null;
        try {
            string4 = deviceProxy.adm_name();
        }
        catch (DevFailed devFailed) {
            Except.throw_event_system_failed("API_BadConfigurationProperty", "Can't subscribe to event for device " + string3 + "\n Check that device server is running...", "NotifdEventConsumer.connect");
        }
        String string5 = string4;
        Database database = null;
        if (!channel_map.containsKey(string5)) {
            if (deviceProxy.use_db()) {
                database = deviceProxy.get_db_obj();
            }
            object = new EventConsumer.ConnectionStructure(deviceProxy.get_tango_host(), string5, string3, string, string2, database, deviceData, false);
            this.connect_event_channel((EventConsumer.ConnectionStructure)object);
        } else if (deviceProxy.use_db()) {
            database = deviceProxy.get_db_obj();
        }
        object = (EventChannelStruct)channel_map.get(string5);
        ((EventChannelStruct)object).adm_device_proxy = deviceProxy.get_adm_dev();
        ((EventChannelStruct)object).use_db = deviceProxy.use_db();
        ((EventChannelStruct)object).dbase = database;
        device_channel_map.put(string3, string5);
    }

    @Override
    protected synchronized void connect_event_channel(EventConsumer.ConnectionStructure connectionStructure) throws DevFailed {
        DeviceProxy deviceProxy = DeviceProxyFactory.get(connectionStructure.channelName, connectionStructure.dbase.getUrl().getTangoHost());
        DbEventImportInfo dbEventImportInfo = this.getEventImportInfo(connectionStructure.channelName, connectionStructure.dbase, deviceProxy);
        int n = dbEventImportInfo.host.indexOf(46);
        if (n > 0) {
            dbEventImportInfo.host = dbEventImportInfo.host.substring(0, n);
        }
        this.connectToNotificationDaemon(dbEventImportInfo);
        StructuredProxyPushSupplier structuredProxyPushSupplier = this.getStructuredProxyPushSupplier(connectionStructure.channelName);
        if (connectionStructure.reconnect) {
            EventChannelStruct eventChannelStruct = (EventChannelStruct)channel_map.get(connectionStructure.channelName);
            eventChannelStruct.eventChannel = this.eventChannel;
            eventChannelStruct.structuredProxyPushSupplier = structuredProxyPushSupplier;
            eventChannelStruct.last_heartbeat = System.currentTimeMillis();
            eventChannelStruct.heartbeat_skipped = false;
            eventChannelStruct.host = dbEventImportInfo.host;
            eventChannelStruct.has_notifd_closed_the_connection = 0;
            try {
                int n2 = eventChannelStruct.heartbeat_filter_id;
                Filter filter = eventChannelStruct.structuredProxyPushSupplier.get_filter(n2);
                eventChannelStruct.structuredProxyPushSupplier.remove_filter(n2);
                filter.destroy();
            }
            catch (FilterNotFound filterNotFound) {
                // empty catch block
            }
            String string = "$event_name == 'heartbeat'";
            eventChannelStruct.heartbeat_filter_id = this.add_filter_for_channel(eventChannelStruct, string);
            this.setEventChannelTimeoutMillis(eventChannelStruct.eventChannel, 3000);
        } else {
            EventChannelStruct eventChannelStruct = new EventChannelStruct();
            eventChannelStruct.eventChannel = this.eventChannel;
            eventChannelStruct.structuredProxyPushSupplier = structuredProxyPushSupplier;
            eventChannelStruct.last_heartbeat = System.currentTimeMillis();
            eventChannelStruct.heartbeat_skipped = false;
            eventChannelStruct.adm_device_proxy = deviceProxy;
            eventChannelStruct.host = dbEventImportInfo.host;
            eventChannelStruct.has_notifd_closed_the_connection = 0;
            eventChannelStruct.consumer = this;
            String string = "$event_name == 'heartbeat'";
            eventChannelStruct.heartbeat_filter_id = this.add_filter_for_channel(eventChannelStruct, string);
            channel_map.put(connectionStructure.channelName, eventChannelStruct);
            this.setEventChannelTimeoutMillis(eventChannelStruct.eventChannel, 3000);
        }
    }

    int add_filter_for_channel(EventChannelStruct eventChannelStruct, String string) throws DevFailed {
        ConstraintExp[] constraintExpArray;
        Filter filter = null;
        int n = -1;
        try {
            constraintExpArray = eventChannelStruct.eventChannel.default_filter_factory();
            filter = constraintExpArray.create_filter("EXTENDED_TCL");
        }
        catch (InvalidGrammar invalidGrammar) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Caught Invalid Grammar exception while creating heartbeat filter : check filter", "EventConsumer.add_filter_for_channel");
        }
        constraintExpArray = new ConstraintExp[]{new ConstraintExp()};
        constraintExpArray[0].event_types = new EventType[0];
        constraintExpArray[0].constraint_expr = string;
        try {
            if (filter != null) {
                filter.add_constraints(constraintExpArray);
                n = eventChannelStruct.structuredProxyPushSupplier.add_filter(filter);
            }
        }
        catch (InvalidConstraint invalidConstraint) {
            filter.destroy();
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Caught InvalidConstraint exception while adding constraint for heartbeat : check filter", "EventConsumer.add_filter_for_channel");
        }
        return n;
    }

    private String buildConstraintExpr(String string, String string2, String string3, String[] stringArray) {
        String string4 = "$domain_name == '" + string.toLowerCase() + "/" + string2.toLowerCase() + "'" + " and $event_name == '" + string3 + "'";
        if (stringArray != null && stringArray.length != 0) {
            string4 = string4 + " and ((";
            for (String string5 : stringArray) {
                string4 = string4 + string5;
            }
            string4 = string4 + " ) and $forced_event > 0.5 )";
        }
        return string4;
    }

    private boolean checkIfHostHasChanged(EventChannelStruct eventChannelStruct) {
        boolean bl = false;
        try {
            IORdump iORdump = new IORdump(eventChannelStruct.adm_device_proxy);
            String string = iORdump.get_hostname();
            int n = string.indexOf(46);
            if (n > 0) {
                string = string.substring(0, n);
            }
            if (!eventChannelStruct.host.equals(string)) {
                bl = true;
            }
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        return bl;
    }

    @Override
    protected void checkIfAlreadyConnected(DeviceProxy deviceProxy, String string, String string2, CallBack callBack, int n, boolean bl) throws DevFailed {
        if (deviceProxy == null || callBack == null && n < 0) {
            Except.throw_wrong_syntax_exception("API_InvalidArgs", "Device or callback pointer NULL and  event queue not used !!", "EventConsumer.subscribe_event()");
        }
        if (deviceProxy == null || deviceProxy.name() == null) {
            Except.throw_event_system_failed("API_NotificationServiceFailed", "Failed to connect to device", "EventConsumer.subscribe_event()");
        } else {
            String string3 = deviceProxy.name().toLowerCase() + "/" + string + "." + string2;
            if (event_callback_map.containsKey(string3)) {
                Except.throw_event_system_failed("API_MethodArgument", "Already connected to event " + string3, "EventConsumer.subscribe_event()");
            }
            if (bl && failed_event_callback_map.containsKey(string3)) {
                Except.throw_event_system_failed("API_MethodArgument", "Already trying to connect to event " + string3, "EventConsumer.subscribe_event()");
            }
        }
    }

    @Override
    protected String getEventSubscriptionCommandName() {
        return "EventSubscriptionChange";
    }

    @Override
    protected void setAdditionalInfoToEventCallBackStruct(EventCallBackStruct eventCallBackStruct, String string, String string2, String string3, String[] stringArray, EventChannelStruct eventChannelStruct) throws DevFailed {
        String string4 = this.buildConstraintExpr(string, string2, string3, stringArray);
        int n = this.add_filter_for_channel(eventChannelStruct, string4);
        eventCallBackStruct.filter_constraint = string4;
        eventCallBackStruct.filter_id = n;
        eventCallBackStruct.consumer = this;
    }

    private void pushServerNotRespondingException(EventChannelStruct eventChannelStruct, EventCallBackStruct eventCallBackStruct) {
        try {
            if (eventChannelStruct != null) {
                if (eventChannelStruct.consumer instanceof NotifdEventConsumer && !eventCallBackStruct.filter_ok) {
                    eventCallBackStruct.filter_id = NotifdEventConsumer.getInstance().add_filter_for_channel(eventChannelStruct, eventCallBackStruct.filter_constraint);
                    eventCallBackStruct.filter_ok = true;
                }
            } else {
                return;
            }
            CallBack callBack = eventCallBackStruct.callback;
            DevError[] devErrorArray = new DevError[]{new DevError()};
            devErrorArray[0].severity = ErrSeverity.ERR;
            devErrorArray[0].origin = "EventConsumer.KeepAliveThread";
            devErrorArray[0].reason = "API_EventTimeout";
            devErrorArray[0].desc = "Event channel is not responding any more, maybe the server or event system is down";
            String string = eventCallBackStruct.device.name() + "/" + eventCallBackStruct.attr_name.toLowerCase();
            EventData eventData = new EventData(eventChannelStruct.adm_device_proxy, string, eventCallBackStruct.event_name, 1, eventCallBackStruct.event_type, null, null, null, devErrorArray);
            eventData.device = eventCallBackStruct.device;
            eventData.name = eventCallBackStruct.device.name();
            eventData.event = eventCallBackStruct.event_name;
            if (eventCallBackStruct.use_ev_queue) {
                EventQueue eventQueue = eventCallBackStruct.device.getEventQueue();
                eventQueue.insert_event(eventData);
            } else {
                callBack.push_event(eventData);
            }
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
    }

    @Override
    protected void checkIfHeartbeatSkipped(String string, EventChannelStruct eventChannelStruct) {
        if (KeepAliveThread.heartbeatHasBeenSkipped(eventChannelStruct) || eventChannelStruct.heartbeat_skipped || eventChannelStruct.notifd_failed) {
            eventChannelStruct.heartbeat_skipped = true;
            DevError devError = null;
            try {
                eventChannelStruct.eventChannel.MyFactory();
                if (this.checkIfHostHasChanged(eventChannelStruct)) {
                    eventChannelStruct.notifd_failed = true;
                }
            }
            catch (RuntimeException runtimeException) {
                devError = new DevError();
                devError.severity = ErrSeverity.ERR;
                devError.origin = "NotifdEventConsumer.checkIfHeartbeatSkipped()";
                devError.reason = "API_EventException";
                devError.desc = "Connection failed with notify daemon";
                int n = runtimeException.toString().indexOf(":");
                if (n > 0) {
                    devError.desc = devError.desc + "  (" + runtimeException.toString().substring(0, n) + ")";
                }
                eventChannelStruct.notifd_failed = true;
                try {
                    DeviceProxyFactory.get(string, eventChannelStruct.dbase.getUrl().getTangoHost()).set_evt_import_info(null);
                }
                catch (DevFailed devFailed) {
                    System.err.println("API received a DevFailed :\t" + devFailed.errors[0].desc);
                }
            }
            if (!eventChannelStruct.use_db) {
                eventChannelStruct.notifd_failed = true;
            }
            if (!eventChannelStruct.notifd_failed && eventChannelStruct.has_notifd_closed_the_connection >= 3) {
                eventChannelStruct.notifd_failed = true;
            }
            if (eventChannelStruct.notifd_failed) {
                boolean bl = eventChannelStruct.notifd_failed = !this.reconnect_to_channel(string);
                if (!eventChannelStruct.notifd_failed) {
                    this.reconnect_to_event(string);
                }
            }
            Enumeration<EventCallBackStruct> enumeration = EventConsumer.getEventCallbackMap().elements();
            while (enumeration.hasMoreElements()) {
                EventCallBackStruct eventCallBackStruct = enumeration.nextElement();
                if (!eventCallBackStruct.channel_name.equals(string)) continue;
                if (devError != null) {
                    this.pushReceivedException(eventChannelStruct, eventCallBackStruct, devError);
                } else {
                    this.pushServerNotRespondingException(eventChannelStruct, eventCallBackStruct);
                }
                if (eventCallBackStruct.event_name.equals(eventNames[6]) || eventChannelStruct.notifd_failed || !eventChannelStruct.consumer.reSubscribe(eventChannelStruct, eventCallBackStruct)) continue;
                this.readAttributeAndPush(eventChannelStruct, eventCallBackStruct);
            }
        } else {
            eventChannelStruct.has_notifd_closed_the_connection = 0;
        }
    }

    @Override
    protected boolean reSubscribe(EventChannelStruct eventChannelStruct, EventCallBackStruct eventCallBackStruct) {
        boolean bl = true;
        try {
            DeviceData deviceData = new DeviceData();
            String[] stringArray = new String[]{eventCallBackStruct.device.name(), eventCallBackStruct.attr_name, "subscribe", eventCallBackStruct.event_name};
            deviceData.insert(stringArray);
            eventChannelStruct.adm_device_proxy.command_inout("EventSubscriptionChange", deviceData);
            eventChannelStruct.heartbeat_skipped = false;
            eventCallBackStruct.last_subscribed = eventChannelStruct.last_subscribed = System.currentTimeMillis();
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    void reconnect_to_event(String string) {
        Enumeration enumeration = event_callback_map.elements();
        while (enumeration.hasMoreElements()) {
            EventCallBackStruct eventCallBackStruct = (EventCallBackStruct)enumeration.nextElement();
            if (!eventCallBackStruct.channel_name.equals(string) || eventCallBackStruct.callback == null) continue;
            try {
                EventChannelStruct eventChannelStruct = (EventChannelStruct)channel_map.get(string);
                eventCallBackStruct.filter_id = this.add_filter_for_channel(eventChannelStruct, eventCallBackStruct.filter_constraint);
                eventCallBackStruct.filter_ok = true;
            }
            catch (DevFailed devFailed) {
                eventCallBackStruct.filter_ok = false;
            }
        }
    }

    private void setEventChannelTimeoutMillis(EventChannel eventChannel, int n) {
        RelativeRoundtripTimeoutPolicy relativeRoundtripTimeoutPolicy = new RelativeRoundtripTimeoutPolicy(10000 * n);
        eventChannel._set_policy_override(new Policy[]{relativeRoundtripTimeoutPolicy}, SetOverrideType.ADD_OVERRIDE);
    }

    private void cleanup_heartbeat_filters() {
        Enumeration enumeration = channel_map.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            EventChannelStruct eventChannelStruct = (EventChannelStruct)channel_map.get(string);
            if (!(eventChannelStruct.consumer instanceof NotifdEventConsumer)) continue;
            try {
                int n = eventChannelStruct.heartbeat_filter_id;
                Filter filter = eventChannelStruct.structuredProxyPushSupplier.get_filter(n);
                eventChannelStruct.structuredProxyPushSupplier.remove_filter(n);
                filter.destroy();
            }
            catch (FilterNotFound filterNotFound) {}
        }
    }

    @Override
    protected void removeFilters(EventCallBackStruct eventCallBackStruct) throws DevFailed {
        try {
            StructuredProxyPushSupplier structuredProxyPushSupplier;
            Filter filter;
            EventChannelStruct eventChannelStruct = (EventChannelStruct)channel_map.get(eventCallBackStruct.channel_name);
            if (eventChannelStruct != null && (filter = (structuredProxyPushSupplier = eventChannelStruct.structuredProxyPushSupplier).get_filter(eventCallBackStruct.filter_id)) != null) {
                structuredProxyPushSupplier.remove_filter(eventCallBackStruct.filter_id);
                filter.destroy();
            }
        }
        catch (FilterNotFound filterNotFound) {
            Except.throw_event_system_failed("API_EventNotFound", "Failed to unsubscribe event, caught exception while calling remove_filter() (hint: check notification daemon is running)", "EventConsumer.unsubscribe_event()");
        }
    }

    @Override
    protected void unsubscribeTheEvent(EventCallBackStruct eventCallBackStruct) {
    }

    boolean reconnect_to_channel(String string) {
        boolean bl = true;
        Enumeration enumeration = event_callback_map.elements();
        while (enumeration.hasMoreElements()) {
            EventCallBackStruct eventCallBackStruct = (EventCallBackStruct)enumeration.nextElement();
            if (!eventCallBackStruct.channel_name.equals(string) || eventCallBackStruct.callback == null) continue;
            try {
                EventChannelStruct eventChannelStruct = (EventChannelStruct)channel_map.get(string);
                eventChannelStruct.adm_device_proxy.ping();
                this.connect_event_channel(new EventConsumer.ConnectionStructure(eventCallBackStruct.device.get_tango_host(), string, eventChannelStruct.dbase, true));
                bl = true;
            }
            catch (DevFailed devFailed) {
                bl = false;
            }
            break;
        }
        return bl;
    }
}

