/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.CallBack;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.EventCallBackStruct;
import fr.esrf.TangoApi.events.EventChannelStruct;
import fr.esrf.TangoApi.events.EventConsumer;
import fr.esrf.TangoApi.events.NotifdEventConsumer;
import fr.esrf.TangoApi.events.ZMQutils;
import fr.esrf.TangoApi.events.ZmqEventConsumer;
import java.util.Hashtable;

public class EventConsumerUtil {
    private static EventConsumerUtil instance = null;
    private static boolean zmqTested = false;
    private static boolean zmqLoadable = true;

    public static EventConsumerUtil getInstance() {
        if (instance == null) {
            instance = new EventConsumerUtil();
        }
        return instance;
    }

    private EventConsumerUtil() {
    }

    private EventConsumer isChannelAlreadyConnected(DeviceProxy deviceProxy) {
        try {
            String string = deviceProxy.adm_name();
            EventChannelStruct eventChannelStruct = EventConsumer.getChannelMap().get(string);
            if (eventChannelStruct == null) {
                return null;
            }
            return eventChannelStruct.consumer;
        }
        catch (DevFailed devFailed) {
            return null;
        }
    }

    public static boolean isZmqLoadable() {
        if (!zmqTested) {
            String string = System.getenv("ZMQ_DISABLE");
            if (string == null) {
                string = System.getProperty("ZMQ_DISABLE");
            }
            if (string == null || !string.equals("true")) {
                try {
                    ZMQutils.getInstance();
                    System.out.println("====================== ZMQ (" + ZMQutils.getZmqVersion() + ") event system is available ============================");
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    System.err.println("======================================================================");
                    System.err.println("  " + noClassDefFoundError);
                    System.err.println("  Event system will be available only for notifd notification system ");
                    System.err.println("======================================================================");
                    zmqLoadable = false;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    System.err.println("======================================================================");
                    System.err.println("  " + unsatisfiedLinkError);
                    System.err.println("  Event system will be available only for notifd notification system ");
                    System.err.println("======================================================================");
                    zmqLoadable = false;
                }
            } else {
                System.err.println("======================================================================");
                System.err.println("  ZMQ event system not enabled");
                System.err.println("  Event system will be available only for notifd notification system ");
                System.err.println("======================================================================");
                zmqLoadable = false;
            }
            zmqTested = true;
        }
        return zmqLoadable;
    }

    public int subscribe_event(DeviceProxy deviceProxy, String string, int n, CallBack callBack, String[] stringArray, boolean bl) throws DevFailed {
        return this.subscribe_event(deviceProxy, string, n, callBack, -1, stringArray, bl);
    }

    public int subscribe_event(DeviceProxy deviceProxy, String string, int n, int n2, String[] stringArray, boolean bl) throws DevFailed {
        return this.subscribe_event(deviceProxy, string, n, null, n2, stringArray, bl);
    }

    public int subscribe_event(DeviceProxy deviceProxy, String string, int n, CallBack callBack, int n2, String[] stringArray, boolean bl) throws DevFailed {
        int n3;
        ApiUtil.printTrace("trying to subscribe_event to " + deviceProxy.name() + "/" + string);
        EventConsumer eventConsumer = this.isChannelAlreadyConnected(deviceProxy);
        if (eventConsumer != null) {
            n3 = eventConsumer.subscribe_event(deviceProxy, string, n, callBack, n2, stringArray, bl);
        } else if (EventConsumerUtil.isZmqLoadable()) {
            try {
                n3 = ZmqEventConsumer.getInstance().subscribe_event(deviceProxy, string, n, callBack, n2, stringArray, bl);
            }
            catch (DevFailed devFailed) {
                ApiUtil.printTrace(devFailed.errors[0].desc);
                if (devFailed.errors[0].desc.equals("Command ZmqEventSubscriptionChange not found")) {
                    n3 = this.subscribeEventWithNotifd(deviceProxy, string, n, callBack, n2, stringArray, bl);
                }
                throw devFailed;
            }
        } else {
            n3 = this.subscribeEventWithNotifd(deviceProxy, string, n, callBack, n2, stringArray, bl);
        }
        return n3;
    }

    private int subscribeEventWithNotifd(DeviceProxy deviceProxy, String string, int n, CallBack callBack, int n2, String[] stringArray, boolean bl) throws DevFailed {
        int n3 = NotifdEventConsumer.getInstance().subscribe_event(deviceProxy, string, n, callBack, n2, stringArray, bl);
        ApiUtil.printTrace(deviceProxy.name() + "/" + string + "  connected to Notifd event system");
        return n3;
    }

    public void unsubscribe_event(int n) throws DevFailed {
        Hashtable<String, EventCallBackStruct> hashtable = EventConsumer.getEventCallbackMap();
        EventCallBackStruct eventCallBackStruct = EventConsumer.getCallBackStruct(hashtable, n);
        eventCallBackStruct.consumer.unsubscribe_event(n);
    }
}

