/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.StringTokenizer;

class TangoEnv {
    private static String tango_host = null;
    private static String super_tango = null;
    private static String access_devname = null;
    private static String default_timeout = null;
    private static String orb_max_msg_size = null;
    private static boolean _osIsUnix = true;
    private static boolean _osIsUnixTested = false;

    TangoEnv() {
    }

    static String getTangoHost() throws DevFailed {
        if (tango_host == null && (tango_host = System.getProperty("TANGO_HOST")) == null && (tango_host = System.getenv("TANGO_HOST")) == null && (tango_host = TangoEnv.getFromEnvFile("TANGO_HOST")) == null) {
            Except.throw_connection_failed("TangoApi_TANGO_HOST_NOT_SET", "Property \"TANGO_HOST\" not exported", "TangoEnv.getTangoHost()");
        }
        return tango_host;
    }

    static boolean isSuperTango() {
        if (super_tango == null && (super_tango = System.getProperty("SUPER_TANGO")) == null && (super_tango = System.getenv("SUPER_TANGO")) == null && (super_tango = TangoEnv.getFromEnvFile("SUPER_TANGO")) == null) {
            super_tango = "false";
        }
        return super_tango.trim().toLowerCase().equals("true");
    }

    static String getAccessDevname() {
        if (access_devname == null && (access_devname = System.getProperty("ACCESS_DEVNAME")) == null && (access_devname = System.getenv("ACCESS_DEVNAME")) == null) {
            access_devname = TangoEnv.getFromEnvFile("ACCESS_DEVNAME");
        }
        return access_devname;
    }

    static String getStrDefaultTimeout() {
        if (default_timeout == null && (default_timeout = System.getProperty("TANGO_TIMEOUT")) == null && (default_timeout = System.getenv("TANGO_TIMEOUT")) == null) {
            default_timeout = TangoEnv.getFromEnvFile("TANGO_TIMEOUT");
        }
        return default_timeout;
    }

    static String getORBgiopMaxMsgSize() {
        if (orb_max_msg_size == null && (orb_max_msg_size = System.getProperty("ORBgiopMaxMsgSize")) == null && (orb_max_msg_size = System.getenv("ORBgiopMaxMsgSize")) == null) {
            orb_max_msg_size = TangoEnv.getFromEnvFile("ORBgiopMaxMsgSize");
        }
        return orb_max_msg_size;
    }

    private static String getFromEnvFile(String string) {
        if (TangoEnv.osIsUnix()) {
            String string2 = System.getenv("HOME");
            String string3 = TangoEnv.getFromEnvFile(string, string2 + "/.tangorc");
            if (string3 != null) {
                return string3;
            }
            String string4 = System.getProperty("TANGO_RC");
            if (string4 == null) {
                string4 = "/etc/tangorc";
            }
            return TangoEnv.getFromEnvFile(string, string4);
        }
        String string5 = System.getProperty("TANGO_RC");
        if (string5 == null) {
            String string6 = System.getenv("TANGO_ROOT");
            if (string6 == null) {
                return null;
            }
            string5 = string6 + "/tangorc";
        }
        return TangoEnv.getFromEnvFile(string, string5);
    }

    private static String getFromEnvFile(String string, String string2) {
        try {
            String string3 = TangoEnv.readFile(string2);
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                int n;
                String string4 = stringTokenizer.nextToken().trim();
                if (string4.startsWith("#") || (n = string4.indexOf(string + "=")) < 0) continue;
                return string4.substring(n + string.length() + 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static boolean osIsUnix() {
        if (!_osIsUnixTested) {
            try {
                String string = System.getProperty("os.name");
                _osIsUnix = !string.toLowerCase().startsWith("windows");
            }
            catch (Exception exception) {
                _osIsUnix = false;
            }
        }
        return _osIsUnix;
    }

    private static String readFile(String string) throws FileNotFoundException, SecurityException, IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        int n = fileInputStream.available();
        byte[] byArray = new byte[n];
        n = fileInputStream.read(byArray);
        fileInputStream.close();
        return new String(byArray);
    }
}

