/*
 * Decompiled with CFR 0.152.
 */
package atkpanel;

import atkpanel.BooleanSpectrumPanel;
import atkpanel.DevStateSpectrumPanel;
import atkpanel.ImagePanel;
import atkpanel.RawImagePanel;
import atkpanel.SpectrumPanel;
import atkpanel.StringImagePanel;
import atkpanel.StringSpectrumPanel;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.INumberImage;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

class RefresherUtil {
    private AttributeList spectOrImageRefresherAttList = new AttributeList();
    private boolean isRefreshing = false;

    RefresherUtil() {
    }

    void startTabsRefresher() {
        this.isRefreshing = true;
        if (!this.spectOrImageRefresherAttList.isEmpty()) {
            this.spectOrImageRefresherAttList.startRefresher();
        }
    }

    void stopTabsRefresher() {
        this.isRefreshing = false;
        this.spectOrImageRefresherAttList.stopRefresher();
    }

    void setTabsRefreshInterval(int refIt) {
        this.spectOrImageRefresherAttList.setRefreshInterval(refIt);
    }

    boolean isRefreshing() {
        return this.isRefreshing;
    }

    void enableComponentRefresh(Component comp) {
        JPanel specComp;
        INumberImage iatt;
        JPanel imgComp;
        boolean previousState = this.isRefreshing;
        this.stopTabsRefresher();
        if (comp instanceof ImagePanel) {
            imgComp = (ImagePanel)comp;
            iatt = ((ImagePanel)imgComp).getModel();
            this.spectOrImageRefresherAttList.add((IEntity)iatt);
        }
        if (comp instanceof SpectrumPanel) {
            specComp = (SpectrumPanel)comp;
            iatt = ((SpectrumPanel)specComp).getModel();
            this.spectOrImageRefresherAttList.add((IEntity)iatt);
        }
        if (comp instanceof StringSpectrumPanel) {
            specComp = (StringSpectrumPanel)comp;
            iatt = ((StringSpectrumPanel)specComp).getModel();
            this.spectOrImageRefresherAttList.add((IEntity)iatt);
        }
        if (comp instanceof StringImagePanel) {
            imgComp = (StringImagePanel)comp;
            iatt = ((StringImagePanel)imgComp).getModel();
            this.spectOrImageRefresherAttList.add((IEntity)iatt);
        }
        if (comp instanceof DevStateSpectrumPanel) {
            DevStateSpectrumPanel dssComp = (DevStateSpectrumPanel)comp;
            iatt = dssComp.getModel();
            this.spectOrImageRefresherAttList.add((IEntity)iatt);
        }
        if (comp instanceof RawImagePanel) {
            RawImagePanel rawImgComp = (RawImagePanel)comp;
            iatt = rawImgComp.getModel();
            this.spectOrImageRefresherAttList.add((IEntity)iatt);
        }
        if (comp instanceof BooleanSpectrumPanel) {
            BooleanSpectrumPanel bssComp = (BooleanSpectrumPanel)comp;
            iatt = bssComp.getModel();
            this.spectOrImageRefresherAttList.add((IEntity)iatt);
        }
        if (previousState) {
            this.startTabsRefresher();
        }
    }

    void refreshComponent(Component comp) {
        INumberImage iatt;
        if (comp instanceof ImagePanel) {
            ImagePanel imgComp = (ImagePanel)comp;
            iatt = imgComp.getModel();
            iatt.refresh();
        }
        if (comp instanceof SpectrumPanel) {
            SpectrumPanel spectComp = (SpectrumPanel)comp;
            iatt = spectComp.getModel();
            iatt.refresh();
        }
        if (comp instanceof StringSpectrumPanel) {
            StringSpectrumPanel strSpectComp = (StringSpectrumPanel)comp;
            iatt = strSpectComp.getModel();
            iatt.refresh();
        }
        if (comp instanceof StringImagePanel) {
            StringImagePanel strImageComp = (StringImagePanel)comp;
            iatt = strImageComp.getModel();
            iatt.refresh();
        }
        if (comp instanceof DevStateSpectrumPanel) {
            DevStateSpectrumPanel dssComp = (DevStateSpectrumPanel)comp;
            iatt = dssComp.getModel();
            iatt.refresh();
        }
        if (comp instanceof BooleanSpectrumPanel) {
            BooleanSpectrumPanel bssComp = (BooleanSpectrumPanel)comp;
            iatt = bssComp.getModel();
            iatt.refresh();
        }
        if (comp instanceof RawImagePanel) {
            RawImagePanel rawImgComp = (RawImagePanel)comp;
            iatt = rawImgComp.getModel();
            iatt.refresh();
        }
    }

    void disableRefreshComponent(Component comp) {
        JPanel specComp;
        INumberImage iatt;
        JPanel imgComp;
        boolean previousState = this.isRefreshing;
        this.stopTabsRefresher();
        if (comp instanceof ImagePanel) {
            imgComp = (ImagePanel)comp;
            iatt = ((ImagePanel)imgComp).getModel();
            this.spectOrImageRefresherAttList.remove(iatt.getName());
        }
        if (comp instanceof SpectrumPanel) {
            specComp = (SpectrumPanel)comp;
            iatt = ((SpectrumPanel)specComp).getModel();
            this.spectOrImageRefresherAttList.remove(iatt.getName());
        }
        if (comp instanceof StringSpectrumPanel) {
            specComp = (StringSpectrumPanel)comp;
            iatt = ((StringSpectrumPanel)specComp).getModel();
            this.spectOrImageRefresherAttList.remove(iatt.getName());
        }
        if (comp instanceof StringImagePanel) {
            imgComp = (StringImagePanel)comp;
            iatt = ((StringImagePanel)imgComp).getModel();
            this.spectOrImageRefresherAttList.remove(iatt.getName());
        }
        if (comp instanceof DevStateSpectrumPanel) {
            DevStateSpectrumPanel dssComp = (DevStateSpectrumPanel)comp;
            iatt = dssComp.getModel();
            this.spectOrImageRefresherAttList.remove(iatt.getName());
        }
        if (comp instanceof BooleanSpectrumPanel) {
            BooleanSpectrumPanel bssComp = (BooleanSpectrumPanel)comp;
            iatt = bssComp.getModel();
            this.spectOrImageRefresherAttList.remove(iatt.getName());
        }
        if (comp instanceof RawImagePanel) {
            RawImagePanel rawImgComp = (RawImagePanel)comp;
            iatt = rawImgComp.getModel();
            this.spectOrImageRefresherAttList.remove(iatt.getName());
        }
        if (previousState) {
            this.startTabsRefresher();
        }
    }

    void refreshAllComponents(JTabbedPane jtabbedPane) {
        Component[] components = jtabbedPane.getComponents();
        for (int i = 0; i < components.length; ++i) {
            this.refreshComponent(components[i]);
        }
    }
}

