/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.GraphicsUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDRotatable;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import fr.esrf.tangoatk.widget.util.jdraw.JLXObject;
import fr.esrf.tangoatk.widget.util.jdraw.JLXPath;
import fr.esrf.tangoatk.widget.util.jdraw.LXObject;
import fr.esrf.tangoatk.widget.util.jdraw.UndoPattern;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.io.IOException;

public class JDLine
extends JDObject
implements JDRotatable {
    public static final int ARROW_NONE = 0;
    public static final int ARROW1_LEFT = 1;
    public static final int ARROW1_RIGHT = 2;
    public static final int ARROW1_BOTH = 3;
    public static final int ARROW1_CENTER = 4;
    public static final int ARROW2_LEFT = 5;
    public static final int ARROW2_RIGHT = 6;
    public static final int ARROW2_BOTH = 7;
    public static final int ARROW2_CENTER = 8;
    static final int arrowModeDefault = 0;
    static final int arrowWidthDefault = 7;
    private int arrowMode = 0;
    Polygon[] arrows = null;
    int arrowWidth;
    int[] ashx;
    int[] ashy;

    public JDLine(String string, int n, int n2, int n3, int n4) {
        this.initDefault();
        this.summit = new Point2D.Double[2];
        this.summit[0] = new Point2D.Double(n, n2);
        this.summit[1] = new Point2D.Double(n3, n4);
        this.name = string;
        this.updateShape();
        Point2D.Double double_ = new Point2D.Double((n + n3) / 2, (n2 + n4) / 2);
        this.setOrigin(double_);
    }

    JDLine(JDLine jDLine, int n, int n2) {
        this.cloneObject(jDLine, n, n2);
        this.arrowMode = jDLine.arrowMode;
        this.arrowWidth = jDLine.arrowWidth;
        this.ashx = new int[4];
        this.ashy = new int[4];
        this.updateShape();
    }

    @Override
    public JDObject copy(int n, int n2) {
        return new JDLine(this, n, n2);
    }

    JDLine(JLXObject jLXObject, JLXPath jLXPath) {
        this.initDefault();
        this.loadObject(jLXObject);
        double d = jLXObject.boundRect.getX();
        double d2 = jLXObject.boundRect.getY();
        double d3 = jLXObject.boundRect.getWidth();
        double d4 = jLXObject.boundRect.getHeight();
        this.setOrigin(new Point2D.Double(d + d3 / 2.0, d2 + d4 / 2.0));
        this.summit = new Point2D.Double[2];
        this.createSummit();
        for (int i = 0; i < 2; ++i) {
            double[] dArray = (double[])jLXPath.path.get(i);
            this.summit[i].x = this.origin.x + dArray[0];
            this.summit[i].y = this.origin.y + dArray[1];
        }
        this.arrowMode = jLXPath.arrow;
        this.updateShape();
    }

    JDLine(LXObject lXObject, double d, double d2, double d3, double d4, int n) {
        this.initDefault();
        this.loadObject(lXObject);
        double d5 = lXObject.boundRect.getX();
        double d6 = lXObject.boundRect.getY();
        double d7 = lXObject.boundRect.getWidth();
        double d8 = lXObject.boundRect.getHeight();
        this.setOrigin(new Point2D.Double(d5 + d7 / 2.0, d6 + d8 / 2.0));
        this.summit = new Point2D.Double[2];
        this.createSummit();
        this.summit[0].x = d;
        this.summit[0].y = d2;
        this.summit[1].x = d3;
        this.summit[1].y = d4;
        this.arrowMode = n;
        this.updateShape();
    }

    @Override
    void initDefault() {
        super.initDefault();
        this.ashx = new int[4];
        this.ashy = new int[4];
        this.arrowMode = 0;
        this.arrowWidth = 7;
    }

    public void setArrow(int n) {
        this.arrowMode = n;
        this.updateShape();
    }

    public int getArrow() {
        return this.arrowMode;
    }

    public void setArrowSize(int n) {
        this.arrowWidth = n;
        this.updateShape();
    }

    public int getArrowSize() {
        return this.arrowWidth;
    }

    @Override
    public void paint(JDrawEditor jDrawEditor, Graphics graphics) {
        if (!this.visible) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.prepareRendering(graphics2D);
        if (this.lineWidth > 0) {
            graphics.setColor(this.foreground);
            BasicStroke basicStroke = GraphicsUtils.createStrokeForLine(this.lineWidth, this.lineStyle);
            if (basicStroke != null) {
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setStroke(basicStroke);
                graphics2D.drawLine(this.ptsx[0], this.ptsy[0], this.ptsx[1], this.ptsy[1]);
                graphics2D.setStroke(stroke);
            } else {
                graphics2D.drawLine(this.ptsx[0], this.ptsy[0], this.ptsx[1], this.ptsy[1]);
            }
        }
        if (this.arrows != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            for (int i = 0; i < this.arrows.length; ++i) {
                graphics2D.setColor(this.foreground);
                graphics2D.fillPolygon(this.arrows[i]);
            }
        }
    }

    @Override
    public boolean hasShadow() {
        return false;
    }

    @Override
    Rectangle getShadowBoundRect() {
        return null;
    }

    @Override
    int getSummitMotion(int n) {
        return 3;
    }

    @Override
    public void moveSummit(int n, double d, double d2) {
        this.summit[n].x = d;
        this.summit[n].y = d2;
        this.updateShape();
    }

    @Override
    public boolean isInsideObject(int n, int n2) {
        if (!super.isInsideObject(n, n2)) {
            return false;
        }
        return this.isPointOnLine(n, n2, (int)this.summit[0].x, (int)this.summit[0].y, (int)this.summit[1].x, (int)this.summit[1].y);
    }

    @Override
    Rectangle getRepaintRect() {
        Rectangle rectangle = super.getRepaintRect();
        if (this.arrowMode != 0) {
            rectangle.x -= this.arrowWidth;
            rectangle.y -= this.arrowWidth;
            rectangle.width += 2 * this.arrowWidth;
            rectangle.height += 2 * this.arrowWidth;
        }
        return rectangle;
    }

    @Override
    public void setLineWidth(int n) {
        this.lineWidth = n;
        this.updateShape();
    }

    @Override
    public void rotate(double d, double d2, double d3) {
        double d4 = Math.sin(d);
        double d5 = Math.cos(d);
        for (int i = 0; i < this.summit.length; ++i) {
            double d6 = this.summit[i].x - d2;
            double d7 = this.summit[i].y - d3;
            this.summit[i].x = d6 * d5 + d7 * d4 + d2;
            this.summit[i].y = -d6 * d4 + d7 * d5 + d3;
        }
        this.updateShape();
    }

    @Override
    void recordObject(StringBuffer stringBuffer, int n) {
        StringBuffer stringBuffer2 = this.recordObjectHeader(stringBuffer, n);
        if (this.arrowWidth != 7) {
            stringBuffer.append(stringBuffer2).append("arrowWidth:").append(this.arrowWidth).append("\n");
        }
        if (this.arrowMode != 0) {
            stringBuffer.append(stringBuffer2).append("arrowMode:").append(this.arrowMode).append("\n");
        }
        this.closeObjectHeader(stringBuffer, n);
    }

    JDLine(JDFileLoader jDFileLoader) throws IOException {
        this.initDefault();
        int n = jDFileLoader.getCurrentLine();
        jDFileLoader.startBlock();
        this.summit = jDFileLoader.parseSummitArray();
        if (this.summit.length != 2) {
            throw new IOException("Invalid summit number for JDLine at line " + n);
        }
        while (!jDFileLoader.isEndBlock()) {
            String string = jDFileLoader.parseProperyName();
            if (string.equals("arrowMode")) {
                this.arrowMode = (int)jDFileLoader.parseDouble();
                continue;
            }
            if (string.equals("arrowWidth")) {
                this.arrowWidth = (int)jDFileLoader.parseDouble();
                continue;
            }
            this.loadDefaultPropery(jDFileLoader, string);
        }
        jDFileLoader.endBlock();
        this.updateShape();
    }

    @Override
    UndoPattern getUndoPattern() {
        UndoPattern undoPattern = new UndoPattern(4);
        this.fillUndoPattern(undoPattern);
        undoPattern.arrowMode = this.arrowMode;
        undoPattern.arrowWidth = this.arrowWidth;
        return undoPattern;
    }

    JDLine(UndoPattern undoPattern) {
        this.initDefault();
        this.applyUndoPattern(undoPattern);
        this.arrowMode = undoPattern.arrowMode;
        this.arrowWidth = undoPattern.arrowWidth;
        this.updateShape();
    }

    @Override
    void updateShape() {
        this.computeBoundRect();
        this.ptsx = new int[this.summit.length];
        this.ptsy = new int[this.summit.length];
        for (int i = 0; i < this.summit.length; ++i) {
            this.ptsx[i] = (int)this.summit[i].x;
            this.ptsy[i] = (int)this.summit[i].y;
        }
        if (this.arrowMode != 0) {
            double d = -(this.ptsy[1] - this.ptsy[0]);
            double d2 = this.ptsx[1] - this.ptsx[0];
            double d3 = Math.sqrt(d * d + d2 * d2);
            double d4 = this.arrowWidth;
            double d5 = this.lineWidth;
            if (d3 < 1.0) {
                this.arrows = null;
            } else {
                int n = 0;
                double d6 = (double)(this.ptsx[1] - this.ptsx[0]) * d4 / d3;
                double d7 = (double)(this.ptsy[1] - this.ptsy[0]) * d4 / d3;
                double d8 = 0.0;
                double d9 = 0.0;
                if (this.lineWidth > 1) {
                    d8 = (double)(this.ptsx[1] - this.ptsx[0]) * (d5 + 1.0) / d3;
                    d9 = (double)(this.ptsy[1] - this.ptsy[0]) * (d5 + 1.0) / d3;
                }
                this.arrows = this.arrowMode == 3 || this.arrowMode == 7 ? new Polygon[2] : new Polygon[1];
                if (this.arrowMode == 3 || this.arrowMode == 1) {
                    this.ashx[0] = (int)Math.round((double)this.ptsx[0] + d6 + -d / d3 * d4);
                    this.ashy[0] = (int)Math.round((double)this.ptsy[0] + d7 + -d2 / d3 * d4);
                    this.ashx[1] = (int)Math.round((double)this.ptsx[0] + d6 + d / d3 * d4);
                    this.ashy[1] = (int)Math.round((double)this.ptsy[0] + d7 + d2 / d3 * d4);
                    this.ashx[2] = this.ptsx[0];
                    this.ashy[2] = this.ptsy[0];
                    this.ptsx[0] = this.ptsx[0] + (int)Math.round(d8);
                    this.ptsy[0] = this.ptsy[0] + (int)Math.round(d9);
                    this.arrows[n] = new Polygon(this.ashx, this.ashy, 3);
                    ++n;
                }
                if (this.arrowMode == 3 || this.arrowMode == 2) {
                    this.ashx[0] = (int)Math.round((double)this.ptsx[1] - d6 + -d / d3 * d4);
                    this.ashy[0] = (int)Math.round((double)this.ptsy[1] - d7 + -d2 / d3 * d4);
                    this.ashx[1] = (int)Math.round((double)this.ptsx[1] - d6 + d / d3 * d4);
                    this.ashy[1] = (int)Math.round((double)this.ptsy[1] - d7 + d2 / d3 * d4);
                    this.ashx[2] = this.ptsx[1];
                    this.ashy[2] = this.ptsy[1];
                    this.ptsx[1] = this.ptsx[1] - (int)Math.round(d8);
                    this.ptsy[1] = this.ptsy[1] - (int)Math.round(d9);
                    this.arrows[n] = new Polygon(this.ashx, this.ashy, 3);
                }
                if (this.arrowMode == 4) {
                    double d10 = (double)(this.ptsx[1] + this.ptsx[0]) / 2.0;
                    double d11 = (double)(this.ptsy[1] + this.ptsy[0]) / 2.0;
                    this.ashx[0] = (int)Math.round(d10 + -d / d3 * d4);
                    this.ashy[0] = (int)Math.round(d11 + -d2 / d3 * d4);
                    this.ashx[1] = (int)Math.round(d10 + d / d3 * d4);
                    this.ashy[1] = (int)Math.round(d11 + d2 / d3 * d4);
                    this.ashx[2] = (int)Math.round(d10 + d6);
                    this.ashy[2] = (int)Math.round(d11 + d7);
                    this.arrows[n] = new Polygon(this.ashx, this.ashy, 3);
                }
                if (this.arrowMode == 7 || this.arrowMode == 5) {
                    this.ashx[0] = (int)Math.round((double)this.ptsx[0] + d6 + -d / d3 * d4 + d6 / 2.0);
                    this.ashy[0] = (int)Math.round((double)this.ptsy[0] + d7 + -d2 / d3 * d4 + d7 / 2.0);
                    this.ashx[1] = (int)Math.round((double)this.ptsx[0] + d6);
                    this.ashy[1] = (int)Math.round((double)this.ptsy[0] + d7);
                    this.ashx[2] = (int)Math.round((double)this.ptsx[0] + d6 + d / d3 * d4 + d6 / 2.0);
                    this.ashy[2] = (int)Math.round((double)this.ptsy[0] + d7 + d2 / d3 * d4 + d7 / 2.0);
                    this.ashx[3] = this.ptsx[0];
                    this.ashy[3] = this.ptsy[0];
                    this.arrows[n] = new Polygon(this.ashx, this.ashy, 4);
                    ++n;
                    this.ptsx[0] = this.ptsx[0] + (int)Math.round(d8);
                    this.ptsy[0] = this.ptsy[0] + (int)Math.round(d9);
                }
                if (this.arrowMode == 7 || this.arrowMode == 6) {
                    this.ashx[0] = (int)Math.round((double)this.ptsx[1] - d6 + -d / d3 * d4 - d6 / 2.0);
                    this.ashy[0] = (int)Math.round((double)this.ptsy[1] - d7 + -d2 / d3 * d4 - d7 / 2.0);
                    this.ashx[1] = (int)Math.round((double)this.ptsx[1] - d6);
                    this.ashy[1] = (int)Math.round((double)this.ptsy[1] - d7);
                    this.ashx[2] = (int)Math.round((double)this.ptsx[1] - d6 + d / d3 * d4 - d6 / 2.0);
                    this.ashy[2] = (int)Math.round((double)this.ptsy[1] - d7 + d2 / d3 * d4 - d7 / 2.0);
                    this.ashx[3] = this.ptsx[1];
                    this.ashy[3] = this.ptsy[1];
                    this.ptsx[1] = this.ptsx[1] - (int)Math.round(d8);
                    this.ptsy[1] = this.ptsy[1] - (int)Math.round(d9);
                    this.arrows[n] = new Polygon(this.ashx, this.ashy, 4);
                }
                if (this.arrowMode == 8) {
                    int n2 = (this.ptsx[1] + this.ptsx[0]) / 2;
                    int n3 = (this.ptsy[1] + this.ptsy[0]) / 2;
                    this.ashx[0] = n2 + (int)(-d / d3 * d4) - (int)(d6 / 2.0);
                    this.ashy[0] = n3 + (int)(-d2 / d3 * d4) - (int)(d7 / 2.0);
                    this.ashx[1] = n2;
                    this.ashy[1] = n3;
                    this.ashx[2] = n2 + (int)(d / d3 * d4) - (int)(d6 / 2.0);
                    this.ashy[2] = n3 + (int)(d2 / d3 * d4) - (int)(d7 / 2.0);
                    this.ashx[3] = n2 + (int)d6;
                    this.ashy[3] = n3 + (int)d7;
                    this.arrows[n] = new Polygon(this.ashx, this.ashy, 4);
                }
            }
        } else {
            this.arrows = null;
        }
    }
}

