/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.GraphicsUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyConvert;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyline;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangular;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import fr.esrf.tangoatk.widget.util.jdraw.JLXObject;
import fr.esrf.tangoatk.widget.util.jdraw.LXObject;
import fr.esrf.tangoatk.widget.util.jdraw.UndoPattern;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.io.IOException;

public class JDEllipse
extends JDRectangular
implements JDPolyConvert {
    public static final int ARC_OPEN = 0;
    public static final int ARC_CLOSED = 1;
    public static final int ARC_PIE = 2;
    static final int stepDefault = 36;
    static final int angleStartDefault = 0;
    static final int angleExtentDefault = 360;
    static final int arcTypeDefault = 0;
    int step;
    int arcType;
    int angleStart;
    int angleExtent;
    int sAngleStart;
    private boolean useOval = false;
    private double x1;
    private double y1;
    private double width;
    private double height;

    public JDEllipse(String string, int n, int n2, int n3, int n4) {
        this.initDefault();
        this.setOrigin(new Point2D.Double(n, n2));
        this.summit = new Point2D.Double[8];
        this.name = string;
        this.createSummit();
        this.computeSummitCoordinates(n, n2, n3, n4);
        this.updateShape();
    }

    JDEllipse(JDEllipse jDEllipse, int n, int n2) {
        this.cloneObject(jDEllipse, n, n2);
        this.step = jDEllipse.step;
        this.arcType = jDEllipse.arcType;
        this.angleStart = jDEllipse.angleStart;
        this.angleExtent = jDEllipse.angleExtent;
        this.updateShape();
    }

    JDEllipse(JLXObject jLXObject, int n, int n2, int n3) {
        this.initDefault();
        this.loadObject(jLXObject);
        double d = jLXObject.boundRect.getX();
        double d2 = jLXObject.boundRect.getY();
        double d3 = jLXObject.boundRect.getWidth();
        double d4 = jLXObject.boundRect.getHeight();
        this.setOrigin(new Point2D.Double(d + d3 / 2.0, d2 + d4 / 2.0));
        this.summit = new Point2D.Double[8];
        this.createSummit();
        this.summit[0].x = d;
        this.summit[0].y = d2;
        this.summit[1].x = d + d3 / 2.0;
        this.summit[1].y = d2;
        this.summit[2].x = d + d3;
        this.summit[2].y = d2;
        this.summit[3].x = d + d3;
        this.summit[3].y = d2 + d4 / 2.0;
        this.summit[4].x = d + d3;
        this.summit[4].y = d2 + d4;
        this.summit[5].x = d + d3 / 2.0;
        this.summit[5].y = d2 + d4;
        this.summit[6].x = d;
        this.summit[6].y = d2 + d4;
        this.summit[7].x = d;
        this.summit[7].y = d2 + d4 / 2.0;
        this.step = 36;
        this.angleStart = n;
        this.angleExtent = n2;
        this.arcType = this.fillStyle == 0 ? 0 : (n3 == 1 ? 1 : 2);
        this.updateShape();
    }

    JDEllipse(LXObject lXObject, int n, int n2, int n3) {
        this.initDefault();
        this.loadObject(lXObject);
        double d = lXObject.boundRect.getX();
        double d2 = lXObject.boundRect.getY();
        double d3 = lXObject.boundRect.getWidth();
        double d4 = lXObject.boundRect.getHeight();
        this.setOrigin(new Point2D.Double(d + d3 / 2.0, d2 + d4 / 2.0));
        this.summit = new Point2D.Double[8];
        this.createSummit();
        this.summit[0].x = d;
        this.summit[0].y = d2;
        this.summit[1].x = d + d3 / 2.0;
        this.summit[1].y = d2;
        this.summit[2].x = d + d3;
        this.summit[2].y = d2;
        this.summit[3].x = d + d3;
        this.summit[3].y = d2 + d4 / 2.0;
        this.summit[4].x = d + d3;
        this.summit[4].y = d2 + d4;
        this.summit[5].x = d + d3 / 2.0;
        this.summit[5].y = d2 + d4;
        this.summit[6].x = d;
        this.summit[6].y = d2 + d4;
        this.summit[7].x = d;
        this.summit[7].y = d2 + d4 / 2.0;
        this.step = 36;
        this.angleStart = n;
        this.angleExtent = n2;
        this.arcType = this.fillStyle == 0 ? 0 : (n3 == 1 ? 1 : 2);
        this.updateShape();
    }

    @Override
    void initDefault() {
        super.initDefault();
        this.step = 36;
        this.arcType = 0;
        this.angleStart = 0;
        this.angleExtent = 360;
    }

    @Override
    public JDObject copy(int n, int n2) {
        return new JDEllipse(this, n, n2);
    }

    @Override
    public boolean isInsideObject(int n, int n2) {
        if (!super.isInsideObject(n, n2)) {
            return false;
        }
        boolean bl = false;
        int n3 = 0;
        if (this.fillStyle != 0) {
            Polygon polygon = new Polygon(this.ptsx, this.ptsy, this.ptsx.length);
            bl = polygon.contains(n, n2);
        } else {
            while (n3 < this.ptsx.length - 1 && !bl) {
                bl = this.isPointOnLine(n, n2, this.ptsx[n3], this.ptsy[n3], this.ptsx[n3 + 1], this.ptsy[n3 + 1]);
                if (bl) continue;
                ++n3;
            }
            if (!bl) {
                bl = this.isPointOnLine(n, n2, this.ptsx[n3], this.ptsy[n3], this.ptsx[0], this.ptsy[0]);
            }
        }
        return bl;
    }

    @Override
    void updateShape() {
        this.computeBoundRect();
        this.makePolygon();
        if (this.hasShadow()) {
            this.computeShadow(this.isClosed());
            this.computeShadowColors();
        }
    }

    @Override
    public JDPolyline convertToPolyline() {
        JDPolyline jDPolyline = this.buildDefaultPolyline();
        jDPolyline.setClosed(this.isClosed());
        jDPolyline.updateShape();
        return jDPolyline;
    }

    boolean isClosed() {
        return this.angleExtent == 360 || this.arcType != 0;
    }

    @Override
    public void rotate90(double d, double d2) {
        this.angleStart += 90;
        this.angleStart %= 360;
        super.rotate90(d, d2);
    }

    @Override
    public void restoreTransform() {
        this.angleStart = this.sAngleStart;
        super.restoreTransform();
    }

    @Override
    public void saveTransform() {
        this.sAngleStart = this.angleStart;
        super.saveTransform();
    }

    @Override
    void computeBoundRect() {
        double d = -65536.0;
        double d2 = -65536.0;
        double d3 = 65536.0;
        double d4 = 65536.0;
        for (int i = 0; i < this.summit.length; ++i) {
            if (this.summit[i].x < d3) {
                d3 = this.summit[i].x;
            }
            if (this.summit[i].x > d) {
                d = this.summit[i].x;
            }
            if (this.summit[i].y < d4) {
                d4 = this.summit[i].y;
            }
            if (!(this.summit[i].y > d2)) continue;
            d2 = this.summit[i].y;
        }
        this.x1 = d3;
        this.y1 = d4;
        this.width = d - d3;
        this.height = d2 - d4;
        this.boundRect.setRect((int)d3, (int)d4, (int)(d - d3) + 1, (int)(d2 - d4) + 1);
    }

    JDEllipse(JDFileLoader jDFileLoader) throws IOException {
        this.initDefault();
        jDFileLoader.startBlock();
        this.summit = jDFileLoader.parseRectangularSummitArray();
        while (!jDFileLoader.isEndBlock()) {
            String string = jDFileLoader.parseProperyName();
            if (string.equals("step")) {
                this.step = (int)jDFileLoader.parseDouble();
                continue;
            }
            if (string.equals("angle_start")) {
                this.angleStart = (int)jDFileLoader.parseDouble();
                continue;
            }
            if (string.equals("angle_extent")) {
                this.angleExtent = (int)jDFileLoader.parseDouble();
                continue;
            }
            if (string.equals("arc_type")) {
                this.arcType = (int)jDFileLoader.parseDouble();
                continue;
            }
            this.loadDefaultPropery(jDFileLoader, string);
        }
        jDFileLoader.endBlock();
        this.updateShape();
    }

    @Override
    void recordObject(StringBuffer stringBuffer, int n) {
        StringBuffer stringBuffer2 = this.recordObjectHeader(stringBuffer, n);
        if (this.step != 36) {
            stringBuffer.append(stringBuffer2).append("step:").append(this.step).append("\n");
        }
        if (this.angleStart != 0) {
            stringBuffer.append(stringBuffer2).append("angle_start:").append(this.angleStart).append("\n");
        }
        if (this.angleExtent != 360) {
            stringBuffer.append(stringBuffer2).append("angle_extent:").append(this.angleExtent).append("\n");
        }
        if (this.arcType != 0) {
            stringBuffer.append(stringBuffer2).append("arc_type:").append(this.arcType).append("\n");
        }
        this.closeObjectHeader(stringBuffer, n);
    }

    @Override
    UndoPattern getUndoPattern() {
        UndoPattern undoPattern = new UndoPattern(1);
        this.fillUndoPattern(undoPattern);
        undoPattern.step = this.step;
        undoPattern.arcType = this.arcType;
        undoPattern.angleStart = this.angleStart;
        undoPattern.angleExtent = this.angleExtent;
        return undoPattern;
    }

    JDEllipse(UndoPattern undoPattern) {
        this.initDefault();
        this.applyUndoPattern(undoPattern);
        this.step = undoPattern.step;
        this.arcType = undoPattern.arcType;
        this.angleStart = undoPattern.angleStart;
        this.angleExtent = undoPattern.angleExtent;
        this.updateShape();
    }

    public void setStep(int n) {
        this.step = n;
        this.updateShape();
    }

    public int getStep() {
        return this.step;
    }

    public void setArcType(int n) {
        this.arcType = n;
        this.updateShape();
    }

    public int getArcType() {
        return this.arcType;
    }

    public void setAngleStart(int n) {
        this.angleStart = n;
        this.updateShape();
    }

    public int getAngleStart() {
        return this.angleStart;
    }

    public void setAngleExtent(int n) {
        this.angleExtent = n;
        this.updateShape();
    }

    public int getAngleExtent() {
        return this.angleExtent;
    }

    @Override
    public void paint(JDrawEditor jDrawEditor, Graphics graphics) {
        Object object;
        if (!this.visible) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.prepareRendering(graphics2D);
        if (this.fillStyle != 0 && this.isClosed() && (object = GraphicsUtils.createPatternForFilling(this)) != null) {
            graphics2D.setPaint((Paint)object);
            if (this.useOval) {
                graphics.fillOval((int)(this.x1 + 0.5), (int)(this.y1 + 0.5), (int)(this.width + 1.0), (int)(this.height + 1.0));
            } else {
                graphics.fillPolygon(this.ptsx, this.ptsy, this.ptsx.length);
            }
        }
        if (this.lineWidth > 0) {
            graphics.setColor(this.foreground);
            object = GraphicsUtils.createStrokeForLine(this.lineWidth, this.lineStyle);
            Stroke stroke = null;
            if (object != null) {
                stroke = graphics2D.getStroke();
                graphics2D.setStroke((Stroke)object);
            }
            if (this.isClosed()) {
                if (this.useOval) {
                    graphics.drawOval((int)(this.x1 + 0.5), (int)(this.y1 + 0.5), (int)this.width, (int)this.height);
                } else {
                    graphics.drawPolygon(this.ptsx, this.ptsy, this.ptsx.length);
                }
            } else {
                graphics.drawPolyline(this.ptsx, this.ptsy, this.ptsx.length);
            }
            if (object != null) {
                graphics2D.setStroke(stroke);
            }
        }
        this.paintShadows(graphics);
    }

    private void computeSummitCoordinates(int n, int n2, int n3, int n4) {
        this.summit[0].x = n;
        this.summit[0].y = n2;
        this.summit[2].x = n + n3;
        this.summit[2].y = n2;
        this.summit[4].x = n + n3;
        this.summit[4].y = n2 + n4;
        this.summit[6].x = n;
        this.summit[6].y = n2 + n4;
        this.centerSummit();
    }

    private void makePolygon() {
        double d = this.width / 2.0;
        double d2 = this.height / 2.0;
        double d3 = this.x1 + d;
        double d4 = this.y1 + d2;
        d -= 0.5;
        d2 -= 0.5;
        int n = this.arcType == 2 && this.angleExtent != 360 ? this.step + 1 : this.step;
        this.ptsx = new int[n];
        this.ptsy = new int[n];
        double d5 = (double)this.angleExtent / 180.0 * Math.PI / (double)this.step;
        double d6 = (double)this.angleStart / 180.0 * Math.PI;
        for (int i = 0; i < this.step; ++i) {
            double d7 = d * Math.cos(d6 + d5 * (double)i);
            double d8 = d2 * Math.sin(d6 + d5 * (double)i);
            this.ptsx[i] = (int)(d3 + d7);
            this.ptsy[i] = (int)(d4 + d8);
        }
        if (this.arcType == 2 && this.angleExtent != 360) {
            this.ptsx[i] = (int)d3;
            this.ptsy[i] = (int)d4;
        }
        this.useOval = this.angleExtent == 360 && this.step == 36;
    }
}

