/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.DevStateSpectrumEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IDevStateSpectrum;
import fr.esrf.tangoatk.core.IDevStateSpectrumListener;
import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DevStateSpectrumViewer
extends JPanel
implements IDevStateSpectrumListener,
PropertyChangeListener {
    public static final String TOOLTIP_NONE = "None";
    public static final String TOOLTIP_ATTNAME = "Name";
    private Vector<JLabel> labelJLabels = null;
    private Vector<JLabel> colorJLabels = null;
    private Vector<JLabel> stateJLabels = null;
    private Font globalFont = new Font("Dialog", 0, 12);
    private boolean stateLabelVisible = true;
    private boolean stateStringVisible = true;
    private String toolTipMode = "Name";
    private IDevStateSpectrum model = null;
    String[] modelStateLabels = null;
    String modelLabel = null;

    public DevStateSpectrumViewer() {
        this.setLayout(new GridBagLayout());
    }

    public IDevStateSpectrum getModel() {
        return this.model;
    }

    public void setModel(IDevStateSpectrum iDevStateSpectrum) {
        this.clearModel();
        if (iDevStateSpectrum == null) {
            return;
        }
        this.model = iDevStateSpectrum;
        if (!this.model.areAttPropertiesLoaded()) {
            this.model.loadAttProperties();
        }
        this.modelStateLabels = this.model.getStateLabels();
        this.modelLabel = this.model.getLabel();
        this.model.getProperty("label").addPresentationListener((PropertyChangeListener)this);
        this.initComponents();
        this.setVisible(true);
        this.model.addDevStateSpectrumListener((IDevStateSpectrumListener)this);
        this.model.refresh();
    }

    public void clearModel() {
        if (this.model != null) {
            this.model.removeDevStateSpectrumListener((IDevStateSpectrumListener)this);
            this.model.getProperty("label").removePresentationListener((PropertyChangeListener)this);
            this.removeComponents();
            this.model = null;
            this.modelStateLabels = null;
            this.modelLabel = null;
        }
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        String[] stringArray = this.model.getDeviceValue();
        if (stringArray == null || stringArray.length <= 0) {
            return;
        }
        this.labelJLabels = new Vector();
        this.colorJLabels = new Vector();
        this.stateJLabels = new Vector();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        while (n < stringArray.length) {
            JLabel jLabel = new JLabel();
            JLabel jLabel2 = new JLabel();
            JLabel jLabel3 = new JLabel();
            String string = null;
            if (this.toolTipMode.equals(TOOLTIP_ATTNAME)) {
                string = this.model.getName() + "[" + n + "]";
            }
            jLabel.setFont(this.globalFont);
            jLabel.setBackground(this.getBackground());
            jLabel.setToolTipText(string);
            jLabel3.setFont(this.globalFont);
            jLabel3.setBackground(this.getBackground());
            jLabel3.setText(stringArray[n]);
            jLabel3.setToolTipText(string);
            jLabel2.setPreferredSize(new Dimension(40, 14));
            jLabel2.setOpaque(true);
            jLabel2.setBackground(ATKConstant.getColor4State(stringArray[n]));
            jLabel2.setToolTipText(string);
            if (this.modelStateLabels != null && n < this.modelStateLabels.length) {
                jLabel.setText(this.modelStateLabels[n]);
            } else {
                jLabel.setText(this.modelLabel + "[" + n + "]");
            }
            this.labelJLabels.add(jLabel);
            this.colorJLabels.add(jLabel2);
            this.stateJLabels.add(jLabel3);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.add((Component)jLabel2, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.add((Component)jLabel3, gridBagConstraints);
            jLabel.setVisible(this.stateLabelVisible);
            jLabel3.setVisible(this.stateStringVisible);
        }
    }

    private void removeComponents() {
        if (this.labelJLabels != null) {
            this.labelJLabels.removeAllElements();
        }
        if (this.colorJLabels != null) {
            this.colorJLabels.removeAllElements();
        }
        if (this.stateJLabels != null) {
            this.stateJLabels.removeAllElements();
        }
        this.removeAll();
        this.labelJLabels = null;
        this.colorJLabels = null;
        this.stateJLabels = null;
    }

    public Font getGlobalFont() {
        return this.globalFont;
    }

    public void setGlobalFont(Font font) {
        JLabel jLabel = null;
        if (font == null) {
            return;
        }
        this.globalFont = font;
        if (this.model == null) {
            return;
        }
        int n = this.model.getValue().length;
        for (int i = 0; i < n; ++i) {
            if (this.labelJLabels != null) {
                try {
                    jLabel = this.labelJLabels.get(i);
                    jLabel.setFont(this.globalFont);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.stateJLabels == null) continue;
            try {
                jLabel = this.stateJLabels.get(i);
                jLabel.setFont(this.globalFont);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean getStateLabelVisible() {
        return this.stateLabelVisible;
    }

    public void setStateLabelVisible(boolean bl) {
        if (this.stateLabelVisible != bl) {
            this.stateLabelVisible = bl;
            this.changeStateLabelVisibility();
        }
    }

    private void changeStateLabelVisibility() {
        JLabel jLabel = null;
        if (this.labelJLabels == null) {
            return;
        }
        for (int i = 0; i < this.labelJLabels.size(); ++i) {
            try {
                jLabel = this.labelJLabels.get(i);
                jLabel.setVisible(this.stateLabelVisible);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean getStateStringVisible() {
        return this.stateStringVisible;
    }

    public void setStateStringVisible(boolean bl) {
        if (this.stateStringVisible != bl) {
            this.stateStringVisible = bl;
            this.changeStateStringVisibility();
        }
    }

    private void changeStateStringVisibility() {
        JLabel jLabel = null;
        if (this.stateJLabels == null) {
            return;
        }
        for (int i = 0; i < this.stateJLabels.size(); ++i) {
            try {
                jLabel = this.stateJLabels.get(i);
                jLabel.setVisible(this.stateStringVisible);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getToolTipMode() {
        return this.toolTipMode;
    }

    public void setToolTipMode(String string) {
        if (string.equalsIgnoreCase(this.toolTipMode)) {
            return;
        }
        this.toolTipMode = string.equalsIgnoreCase(TOOLTIP_ATTNAME) ? TOOLTIP_ATTNAME : TOOLTIP_NONE;
    }

    public void devStateSpectrumChange(DevStateSpectrumEvent devStateSpectrumEvent) {
        String[] stringArray = devStateSpectrumEvent.getValue();
        if (stringArray == null) {
            this.setAllStates("UNKNOWN");
        } else {
            this.updateSpectrumValues(stringArray);
        }
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public void errorChange(ErrorEvent errorEvent) {
        this.setAllStates("UNKNOWN");
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Property property = (Property)propertyChangeEvent.getSource();
        if (this.model != null && property.getName().equalsIgnoreCase("label")) {
            this.setNewAttLabel(property.getValue().toString());
        }
    }

    private void updateSpectrumValues(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.colorJLabels != null) {
                try {
                    JLabel jLabel = this.colorJLabels.get(i);
                    jLabel.setBackground(ATKConstant.getColor4State(stringArray[i], this.model.getInvertedOpenCloseForElement(i), this.model.getInvertedInsertExtractForElement(i)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.stateJLabels == null) continue;
            try {
                JLabel jLabel = this.stateJLabels.get(i);
                jLabel.setText(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setAllStates(String string) {
        int n;
        if (this.colorJLabels == null || this.stateJLabels == null) {
            return;
        }
        for (n = 0; n < this.colorJLabels.size(); ++n) {
            try {
                JLabel jLabel = this.colorJLabels.get(n);
                jLabel.setBackground(ATKConstant.getColor4State(string, this.model.getInvertedOpenCloseForElement(n), this.model.getInvertedInsertExtractForElement(n)));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (n = 0; n < this.stateJLabels.size(); ++n) {
            try {
                JLabel jLabel = this.stateJLabels.get(n);
                jLabel.setText(string);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setNewAttLabel(String string) {
        this.modelLabel = string;
        if (this.labelJLabels == null) {
            return;
        }
        for (int i = 0; i < this.labelJLabels.size(); ++i) {
            JLabel jLabel = this.labelJLabels.get(i);
            if (this.modelStateLabels != null && i < this.modelStateLabels.length) continue;
            jLabel.setText(this.modelLabel + "[" + i + "]");
        }
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AttributeList attributeList = new AttributeList();
                IDevStateSpectrum iDevStateSpectrum = null;
                try {
                    iDevStateSpectrum = (IDevStateSpectrum)attributeList.add("sr/rf-cavi/cav12/SubDevicesStates");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (iDevStateSpectrum == null) {
                    System.exit(-1);
                }
                attributeList.startRefresher();
                JFrame jFrame = new JFrame();
                DevStateSpectrumViewer devStateSpectrumViewer = new DevStateSpectrumViewer();
                devStateSpectrumViewer.setModel(iDevStateSpectrum);
                jFrame.setContentPane(devStateSpectrumViewer);
                jFrame.pack();
                jFrame.setVisible(true);
            }
        });
    }
}

