/*
 * Decompiled with CFR 0.152.
 */
package pogo.class2www;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import pogo.class2www.Family;
import pogo.class2www.Module;
import pogo.gene.PogoUtil;

public class Utils {
    private static Utils instance = null;
    private static final int CMD_TIMEOUT = 60000;
    private static String template_home = null;

    private Utils() {
    }

    public static Utils getInstance() {
        if (instance == null) {
            instance = new Utils();
        }
        return instance;
    }

    public String getModuleFile(String cvsroot) throws DevFailed {
        String code = "";
        try {
            this.checkOutModule("CVSROOT/modules", cvsroot);
            code = PogoUtil.readFile("CVSROOT/modules");
            String cmd = "rm -R CVSROOT";
            PogoUtil.executeShellCmd(cmd);
        }
        catch (Exception e) {
            Except.throw_exception(e.toString(), e.toString(), "Utils.getModuleFile()");
        }
        return code;
    }

    public void checkOutModule(String module, String cvsroot) {
        this.checkOutModule(module, cvsroot, null);
    }

    public void checkOutModule(String module, String cvsroot, String tag) {
        try {
            String cmd = "cvs -d " + cvsroot + " co ";
            if (tag != null) {
                cmd = cmd + "-r " + tag + "  ";
            }
            cmd = cmd + module;
            System.out.println(cmd);
            this.executeShellCmd(cmd, 60000);
            System.out.println(cmd + "  done");
        }
        catch (Exception e) {
            System.err.println("Utils.checkOutModule():\t" + e);
        }
    }

    public String executeShellCmd(String cmd, int timeout) throws IOException, InterruptedException, Exception {
        String str;
        Process proc = Runtime.getRuntime().exec(cmd);
        ProcessTimeout pto = new ProcessTimeout(proc, timeout);
        InputStream istr = proc.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(istr));
        String sb = "";
        while ((str = br.readLine()) != null) {
            sb = sb + str + "\n";
        }
        proc.waitFor();
        int retVal = proc.exitValue();
        if (retVal != 0) {
            if (pto.timedOut()) {
                throw new Exception("the shell command\n" + cmd + "\nexits on timeout !\n\n");
            }
            InputStream errstr = proc.getErrorStream();
            br = new BufferedReader(new InputStreamReader(errstr));
            while ((str = br.readLine()) != null) {
                System.out.println(str);
                sb = sb + str + "\n";
            }
            throw new Exception("the shell command\n" + cmd + "\nreturns : " + retVal + " !\n\n" + sb);
        }
        return sb;
    }

    public static String removeHtmlTag(String code) {
        String[] tags;
        for (String tag : tags = new String[]{"<td", "<tr", "</td", "</tr", "<p"}) {
            int start;
            while ((start = code.indexOf(tag)) >= 0) {
                int end = code.indexOf(">", start);
                if (end > 0) {
                    code = code.substring(0, start) + code.substring(end + 1);
                    continue;
                }
                code = code.substring(0, start);
            }
        }
        return code;
    }

    public Vector sort(Vector v) {
        MyCompare compare = new MyCompare();
        Collections.sort(v, compare);
        return v;
    }

    public static String readTemplateFile(String filename) {
        String code = null;
        if (template_home == null) {
            template_home = System.getProperty("TEMPL_HOME");
        }
        try {
            code = PogoUtil.readFile(template_home + "/html/" + filename);
            int pos = code.indexOf("</Body>");
            if (pos > 0) {
                code = code.substring(0, pos);
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
        return code;
    }

    private class ProcessTimeout
    extends Thread {
        private Process process;
        private int timeout;
        private long t0;
        private boolean failed = false;

        public ProcessTimeout(Process process, int timeout) {
            this.process = process;
            this.timeout = timeout;
            this.t0 = System.currentTimeMillis();
            this.start();
        }

        public boolean timedOut() {
            return this.failed;
        }

        @Override
        public void run() {
            boolean finished = false;
            while (!finished) {
                try {
                    int ret = this.process.exitValue();
                    finished = true;
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - this.t0 > (long)this.timeout) {
                    this.process.destroy();
                    this.failed = true;
                }
                try {
                    Thread.sleep(this.timeout / 10);
                }
                catch (Exception exception) {}
            }
        }
    }

    class MyCompare
    implements Comparator {
        MyCompare() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof String && o2 instanceof String) {
                String s1 = o1.toString().toLowerCase();
                String s2 = o2.toString().toLowerCase();
                if (s1 == null) {
                    return 1;
                }
                if (s2 == null) {
                    return -1;
                }
                return s1.compareTo(s2);
            }
            if (o1 instanceof Family && o2 instanceof Family) {
                String s1 = ((Family)o1).name;
                String s2 = ((Family)o2).name;
                return s1.compareTo(s2);
            }
            if (o1 instanceof Module && o2 instanceof Module) {
                Module m1 = (Module)o1;
                Module m2 = (Module)o2;
                String s1 = m1.server != null ? m1.server.class_name : m1.name;
                String s2 = m2.server != null ? m2.server.class_name : m2.name;
                return s1.compareTo(s2);
            }
            return 0;
        }
    }
}

