/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.Pipe;
import fr.esrf.tango.pogo.pogoDsl.Property;
import fr.esrf.tango.pogo.pogoDsl.State;
import java.awt.Component;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import org.tango.pogo.pogo_gui.tools.ParserTool;
import org.tango.pogo.pogo_gui.tools.PogoException;
import org.tango.pogo.pogo_gui.tools.Utils;

public class PogoEditor {
    private static PogoEditor instance = null;
    private static String shellEditor = null;
    private static final String[] exeFiles = new String[]{"nedit-client", "nedit-nc"};

    public static PogoEditor getInstance() {
        if (instance == null) {
            instance = new PogoEditor();
        }
        return instance;
    }

    private PogoEditor() {
        String os = System.getProperty("os.name");
        System.out.println("Running under " + os);
        if (os.toLowerCase().startsWith("shellEditor")) {
            shellEditor = null;
        } else {
            shellEditor = System.getenv("EDITOR");
            if (shellEditor != null) {
                if (shellEditor.startsWith("nedit")) {
                    String path = System.getenv("PATH");
                    StringTokenizer stk = new StringTokenizer(path, ":");
                    ArrayList<String> lines = new ArrayList<String>();
                    while (stk.hasMoreTokens()) {
                        lines.add(stk.nextToken());
                    }
                    String[] stringArray = exeFiles;
                    int n = exeFiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String exeFile = stringArray[n2];
                        shellEditor = this.getEditorExeFile(exeFile, lines);
                        if (shellEditor != null) break;
                        ++n2;
                    }
                    if (shellEditor != null) {
                        System.out.println("using " + shellEditor + " editor");
                    } else {
                        System.out.println("no shellEditor available.");
                    }
                } else if (shellEditor.equals("gedit") || shellEditor.equals("geany")) {
                    System.out.println("using " + shellEditor + " editor");
                } else {
                    shellEditor = null;
                }
            }
            if (shellEditor == null) {
                System.out.println("will Launch default desktop editor....");
            }
        }
    }

    private String getEditorExeFile(String exeFile, List<String> lines) {
        for (String line : lines) {
            String filename = String.valueOf(line) + "/" + exeFile;
            if (!new File(filename).exists()) continue;
            return filename;
        }
        return null;
    }

    private int getLineNumber(String filename, String signature) {
        int end;
        String code = "";
        try {
            code = ParserTool.readFile(filename);
        }
        catch (Exception e) {
            PogoException.popup((Component)new JFrame(), e);
        }
        int start = 0;
        int idx = 0;
        while ((end = code.indexOf(10, start)) > 0) {
            String line = code.substring(start, end);
            if (line.contains(signature)) {
                return idx + 1;
            }
            start = end + 1;
            ++idx;
        }
        System.out.println(String.valueOf(signature) + " not found !");
        return -1;
    }

    private int getLineNumber(String filename, String className, int lang, Property prop, boolean is_dev) {
        String signature = null;
        switch (lang) {
            case 1: {
                signature = "void " + className;
                if (!is_dev) {
                    signature = String.valueOf(signature) + "Class";
                }
                signature = String.valueOf(signature) + "::get_";
                signature = is_dev ? String.valueOf(signature) + "device" : String.valueOf(signature) + "class";
                signature = String.valueOf(signature) + "_property(";
                break;
            }
            case 0: {
                signature = "@" + (is_dev ? "Device" : "Class") + "Property(name=\"" + prop.getName() + "\"";
                break;
            }
            case 2: {
                signature = "'" + prop.getName() + "':";
            }
        }
        if (signature == null) {
            return -1;
        }
        return this.getLineNumber(filename, signature);
    }

    private int getLineNumber(String filename, String className, int lang, Command cmd) {
        String signature = null;
        switch (lang) {
            case 1: {
                signature = String.valueOf(className) + "::" + cmd.getExecMethod() + "(";
                break;
            }
            case 0: {
                signature = "* Execute command \"" + cmd.getName() + "\"";
                break;
            }
            case 2: {
                signature = "def " + cmd.getName() + "(self):";
            }
        }
        if (signature == null) {
            return -1;
        }
        return this.getLineNumber(filename, signature);
    }

    private int getLineNumber(String filename, String className, int lang, Attribute attribute) {
        String signature = null;
        switch (lang) {
            case 1: {
                signature = String.valueOf(className) + "::read_" + attribute.getName() + "(Tango::Attribute &attr)";
                break;
            }
            case 0: {
                if (Utils.isTrue(attribute.getIsDynamic())) {
                    signature = "public AttributeValue getValue() throws DevFailed {";
                    break;
                }
                signature = "@Attribute(name=\"" + attribute.getName() + "\"";
                break;
            }
            case 2: {
                signature = "def read_" + attribute.getName() + "(self, attr):";
            }
        }
        if (signature == null) {
            return -1;
        }
        return this.getLineNumber(filename, signature);
    }

    private int getLineNumber(String filename, String className, int lang, Pipe pipe) {
        String signature = null;
        switch (lang) {
            case 1: {
                signature = String.valueOf(className) + "::read_" + pipe.getName() + "(Tango::Pipe &pipe)";
                break;
            }
            case 0: {
                signature = "@Pipe(name=\"" + pipe.getName() + "\"";
                break;
            }
            case 2: {
                signature = "def read_" + pipe.getName() + "(self, pipe):";
            }
        }
        if (signature == null) {
            return -1;
        }
        return this.getLineNumber(filename, signature);
    }

    private int getLineNumber(String filename, String className, int lang) {
        String signature = null;
        switch (lang) {
            case 1: {
                signature = "namespace " + className + "_ns";
                break;
            }
            case 0: {
                signature = "public class " + className + " {";
                break;
            }
            case 2: {
                signature = "class " + className + " {";
            }
        }
        if (signature == null) {
            return -1;
        }
        return this.getLineNumber(filename, signature);
    }

    public void editFile(String[] data, Property prop, boolean is_dev) throws PogoException {
        String className = data[0];
        String path = data[1];
        int lang = Utils.getLanguage(data[2]);
        String filename = null;
        switch (lang) {
            case 1: {
                if (is_dev) {
                    filename = String.valueOf(path) + "/" + className + ".cpp";
                    break;
                }
                filename = String.valueOf(path) + "/" + className + "Class.cpp";
                break;
            }
            case 0: {
                filename = String.valueOf(path) + "/org/tango/" + className.toLowerCase() + "/" + className + ".java";
                break;
            }
            case 2: {
                filename = String.valueOf(path) + "/" + className + ".py";
            }
        }
        if (filename != null) {
            int linenum = this.getLineNumber(filename, className, lang, prop, is_dev);
            this.startEditor(filename, linenum);
        }
    }

    public void editFile(String[] data, Attribute attribute) throws PogoException {
        String className = data[0];
        String path = data[1];
        int lang = Utils.getLanguage(data[2]);
        String filename = null;
        switch (lang) {
            case 1: {
                filename = String.valueOf(path) + "/" + className + ".cpp";
                break;
            }
            case 0: {
                filename = String.valueOf(path) + "/org/tango/" + className.toLowerCase() + "/";
                filename = Utils.isTrue(attribute.getIsDynamic()) ? String.valueOf(filename) + attribute.getName() : String.valueOf(filename) + className;
                filename = String.valueOf(filename) + ".java";
                break;
            }
            case 2: {
                filename = String.valueOf(path) + "/" + className + ".py";
            }
        }
        if (filename != null) {
            int lineNumber = this.getLineNumber(filename, className, lang, attribute);
            this.startEditor(filename, lineNumber);
        }
    }

    public void editFile(String[] data, Pipe pipe) throws PogoException {
        String className = data[0];
        String path = data[1];
        int lang = Utils.getLanguage(data[2]);
        String filename = null;
        switch (lang) {
            case 1: {
                filename = String.valueOf(path) + "/" + className + ".cpp";
                break;
            }
            case 0: {
                filename = String.valueOf(path) + "/org/tango/" + className.toLowerCase() + "/" + className;
                filename = String.valueOf(filename) + ".java";
                break;
            }
            case 2: {
                filename = String.valueOf(path) + "/" + className + ".py";
            }
        }
        if (filename != null) {
            int lineNumber = this.getLineNumber(filename, className, lang, pipe);
            this.startEditor(filename, lineNumber);
        }
    }

    public void editFile(String[] data, Command cmd) throws PogoException {
        String className = data[0];
        String path = data[1];
        int lang = Utils.getLanguage(data[2]);
        String filename = null;
        switch (lang) {
            case 1: {
                filename = String.valueOf(path) + "/" + className + ".cpp";
                break;
            }
            case 0: {
                filename = String.valueOf(path) + "/org/tango/" + className.toLowerCase() + "/" + className + ".java";
                break;
            }
            case 2: {
                filename = String.valueOf(path) + "/" + className + ".py";
            }
        }
        if (filename != null) {
            int linenum = this.getLineNumber(filename, className, lang, cmd);
            this.startEditor(filename, linenum);
        }
    }

    public void editFile(String[] data, State state) throws PogoException {
        String className = data[0];
        String path = data[1];
        int lang = Utils.getLanguage(data[2]);
        String filename = null;
        switch (lang) {
            case 1: {
                filename = String.valueOf(path) + "/" + className + "StateMachine.cpp";
                break;
            }
            case 0: {
                filename = String.valueOf(path) + "/org/tango/" + className.toLowerCase() + "/" + className + ".java";
                break;
            }
            case 2: {
                filename = String.valueOf(path) + "/" + className + ".py";
            }
        }
        if (filename != null) {
            int linenum = this.getLineNumber(filename, className, lang);
            this.startEditor(filename, linenum);
        }
    }

    private void startEditor(String filename, int lineNumber) throws PogoException {
        if (shellEditor == null) {
            this.launchDesktopEditor(filename);
        } else if (lineNumber >= 0) {
            String shell_cmd = shellEditor.startsWith("nedit") ? String.valueOf(shellEditor) + " -noask -line " + lineNumber + " " + filename : String.valueOf(shellEditor) + " +" + lineNumber + " " + filename;
            try {
                Utils.executeShellCmdAndReturn(shell_cmd);
            }
            catch (IOException e) {
                throw new PogoException(e.toString());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void launchDesktopEditor(String fileName) throws PogoException {
        if (!Desktop.isDesktopSupported()) throw new PogoException("Desktop  not supported");
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.OPEN)) throw new PogoException("Desktop.Action.EDIT not supported");
        try {
            desktop.open(new File(fileName));
            return;
        }
        catch (Exception e) {
            PogoException.popup((Component)new JFrame(), e);
        }
    }
}

