/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class KeyWordsDialog
extends JDialog {
    private int returnValue = 0;
    private JTextArea keyWordsTextArea;

    public KeyWordsDialog(JDialog parent, List<String> keyWords) {
        super((Dialog)parent, true);
        this.initComponents();
        if (keyWords != null) {
            String s = "";
            for (String keyWord : keyWords) {
                s = String.valueOf(s) + keyWord + "\n";
            }
            this.keyWordsTextArea.setText(s);
        }
        this.pack();
        ATKGraphicsUtils.centerDialog(this);
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        JLabel titleLabel = new JLabel();
        JPanel bottomPanel = new JPanel();
        JButton okBtn = new JButton();
        JButton cancelBtn = new JButton();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.keyWordsTextArea = new JTextArea();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                KeyWordsDialog.this.closeDialog(evt);
            }
        });
        titleLabel.setFont(new Font("Dialog", 1, 18));
        titleLabel.setText("Words For Search Engine");
        topPanel.add(titleLabel);
        this.getContentPane().add((Component)topPanel, "North");
        okBtn.setText("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyWordsDialog.this.okBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(okBtn);
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyWordsDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.keyWordsTextArea.setColumns(30);
        this.keyWordsTextArea.setRows(15);
        jScrollPane1.setViewportView(this.keyWordsTextArea);
        this.getContentPane().add((Component)jScrollPane1, "Center");
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        this.returnValue = 0;
        this.doClose();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.returnValue = 2;
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.returnValue = 2;
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public int showDialog() {
        this.setVisible(true);
        return this.returnValue;
    }

    public List<String> getKeyWords() {
        ArrayList<String> list = new ArrayList<String>();
        String lines = this.keyWordsTextArea.getText();
        StringTokenizer stk = new StringTokenizer(lines, "\n");
        while (stk.hasMoreElements()) {
            list.add(stk.nextToken());
        }
        return list;
    }
}

