/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import org.tango.pogo.pogo_gui.tools.PogoFileFilter;
import org.tango.pogo.pogo_gui.tools.PogoProperty;

public class PreferencesDialog
extends JDialog {
    private JTextField inheritanceTxt;
    private JTextField mailTxt;
    private JRadioButton reloadBtn;

    public PreferencesDialog(JFrame jFrame) {
        super((Frame)jFrame, true);
        this.initComponents();
        this.reloadBtn.setSelected(PogoProperty.loadPrevious);
        if (PogoProperty.contactAddress != null) {
            this.mailTxt.setText(PogoProperty.contactAddress);
        }
        if (PogoProperty.inheritHome != null) {
            this.inheritanceTxt.setText(PogoProperty.inheritHome);
        }
        this.pack();
        ATKGraphicsUtils.centerDialog(this);
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel2 = new JLabel();
        this.inheritanceTxt = new JTextField();
        JButton jButton = new JButton();
        this.reloadBtn = new JRadioButton();
        JLabel jLabel3 = new JLabel();
        this.mailTxt = new JTextField();
        JPanel jPanel3 = new JPanel();
        JButton jButton2 = new JButton();
        JButton jButton3 = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PreferencesDialog.this.closeDialog(windowEvent);
            }
        });
        jLabel.setFont(new Font("Dialog", 1, 18));
        jLabel.setText("Pogo Preferences");
        jPanel.add(jLabel);
        this.getContentPane().add((Component)jPanel, "North");
        jPanel2.setLayout(new GridBagLayout());
        jLabel2.setFont(new Font("Dialog", 1, 12));
        jLabel2.setText("Inheritance root directory :");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        this.inheritanceTxt.setColumns(50);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        jPanel2.add((Component)this.inheritanceTxt, gridBagConstraints);
        jButton.setText("...");
        jButton.setBorder(new SoftBevelBorder(0));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesDialog.this.inheritanceBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        jPanel2.add((Component)jButton, gridBagConstraints);
        this.reloadBtn.setFont(new Font("Dialog", 1, 12));
        this.reloadBtn.setText("Reload project at startup");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        jPanel2.add((Component)this.reloadBtn, gridBagConstraints);
        jLabel3.setFont(new Font("Dialog", 1, 12));
        jLabel3.setText("Default contact email :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        jPanel2.add((Component)jLabel3, gridBagConstraints);
        this.mailTxt.setColumns(30);
        this.mailTxt.setFont(new Font("Dialog", 1, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        jPanel2.add((Component)this.mailTxt, gridBagConstraints);
        this.getContentPane().add((Component)jPanel2, "Center");
        jButton2.setText("OK");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesDialog.this.okBtnActionPerformed(actionEvent);
            }
        });
        jPanel3.add(jButton2);
        jButton3.setText("Cancel");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel3.add(jButton3);
        this.getContentPane().add((Component)jPanel3, "South");
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        PogoProperty.inheritHome = this.inheritanceTxt.getText();
        PogoProperty.contactAddress = this.mailTxt.getText();
        PogoProperty.loadPrevious = this.reloadBtn.getSelectedObjects() != null;
        PogoProperty.updatePogoRC();
        this.doClose();
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    private void inheritanceBtnActionPerformed(ActionEvent actionEvent) {
        File file;
        JFileChooser jFileChooser = new JFileChooser(this.inheritanceTxt.getText());
        jFileChooser.addChoosableFileFilter(new PogoFileFilter("", "Directory"));
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showDialog(this, "Target Dir.");
        if (n == 0 && (file = jFileChooser.getSelectedFile()) != null && file.isDirectory()) {
            this.inheritanceTxt.setText(file.getAbsolutePath());
        }
        this.inheritanceTxt.requestFocus();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }
}

