/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.tango.pogo.pogoDsl.AdditionalFile;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.eclipse.emf.common.util.EList;
import org.tango.pogo.pogo_gui.tools.OAWutils;
import org.tango.pogo.pogo_gui.tools.PogoFileFilter;

public class AdditionalFilesDialog
extends JDialog {
    private String path;
    private String fileExtension;
    private EList<AdditionalFile> fileList;
    private int returnValue = 2;
    private JList<String> additionalList;
    private JScrollPane listScrollPane;
    private JButton removeBtn;

    public AdditionalFilesDialog(JFrame jFrame, EList<AdditionalFile> eList, String string, String string2) {
        super((Frame)jFrame, true);
        this.fileList = eList;
        this.path = string;
        this.fileExtension = string2;
        this.initForm();
    }

    public AdditionalFilesDialog(JDialog jDialog, EList<AdditionalFile> eList, String string, String string2) {
        super((Dialog)jDialog, true);
        this.fileList = eList;
        this.path = string;
        this.fileExtension = string2;
        this.initForm();
    }

    private void initForm() {
        this.initComponents();
        this.fillJList();
        this.additionalList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                AdditionalFilesDialog.this.listSelectionPerformed(mouseEvent);
            }
        });
        this.removeBtn.setEnabled(false);
        if (this.fileList.size() == 0) {
            this.listScrollPane.setPreferredSize(new Dimension(500, 50));
        }
        this.pack();
        ATKGraphicsUtils.centerDialog(this);
    }

    private void fillJList() {
        this.additionalList.removeAll();
        Vector<String> vector = new Vector<String>();
        for (AdditionalFile additionalFile : this.fileList) {
            vector.add(additionalFile.getPath());
        }
        this.additionalList.setListData(vector);
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel();
        this.listScrollPane = new JScrollPane();
        this.additionalList = new JList();
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton();
        this.removeBtn = new JButton();
        JPanel jPanel3 = new JPanel();
        JButton jButton2 = new JButton();
        JButton jButton3 = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AdditionalFilesDialog.this.closeDialog(windowEvent);
            }
        });
        jLabel.setFont(new Font("Dialog", 1, 18));
        jLabel.setText("Programmer's  Additional  files");
        jPanel.add(jLabel);
        this.getContentPane().add((Component)jPanel, "North");
        this.listScrollPane.setViewportView(this.additionalList);
        this.getContentPane().add((Component)this.listScrollPane, "Center");
        jPanel2.setLayout(new GridBagLayout());
        jButton.setText("Add File");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AdditionalFilesDialog.this.addBtnActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jButton, gridBagConstraints);
        this.removeBtn.setText("Remove");
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AdditionalFilesDialog.this.removeBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        jPanel2.add((Component)this.removeBtn, gridBagConstraints);
        this.getContentPane().add((Component)jPanel2, "After");
        jButton2.setText("OK");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AdditionalFilesDialog.this.okBtnActionPerformed(actionEvent);
            }
        });
        jPanel3.add(jButton2);
        jButton3.setText("Cancel");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AdditionalFilesDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel3.add(jButton3);
        this.getContentPane().add((Component)jPanel3, "South");
        this.pack();
    }

    private void listSelectionPerformed(MouseEvent mouseEvent) {
        this.removeBtn.setEnabled(true);
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        this.returnValue = 0;
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.returnValue = 2;
        this.doClose();
    }

    private void addBtnActionPerformed(ActionEvent actionEvent) {
        File file;
        JFileChooser jFileChooser = new JFileChooser(this.path);
        PogoFileFilter pogoFileFilter = new PogoFileFilter(this.fileExtension, "Additional Code Files");
        jFileChooser.setFileFilter(pogoFileFilter);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0 && (file = jFileChooser.getSelectedFile()) != null && !file.isDirectory()) {
            String string = file.getName();
            String string2 = file.getAbsolutePath();
            int n2 = string.lastIndexOf(".");
            if (n2 > 0) {
                string = string.substring(0, n2);
            }
            AdditionalFile additionalFile = OAWutils.factory.createAdditionalFile();
            additionalFile.setName(string);
            additionalFile.setPath(string2);
            this.fileList.add(additionalFile);
            this.fillJList();
        }
    }

    private void removeBtnActionPerformed(ActionEvent actionEvent) {
        String string = this.additionalList.getSelectedValue();
        if (JOptionPane.showConfirmDialog(this, "Remove  " + string + " ?", "Confirmation Window", 0) == 0) {
            int n = this.additionalList.getSelectedIndex();
            this.fileList.remove(n);
            this.fillJList();
            this.removeBtn.setEnabled(false);
        }
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.returnValue = 2;
        this.doClose();
    }

    public int showDialog() {
        this.setVisible(true);
        return this.returnValue;
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }
}

