/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.diagnostic;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic;
import org.eclipse.xtext.serializer.diagnostic.ITokenDiagnosticProvider;
import org.eclipse.xtext.serializer.diagnostic.SerializationDiagnostic;
import org.eclipse.xtext.util.EmfFormatter;

public class TokenDiagnosticProvider
implements ITokenDiagnosticProvider {
    protected String getFullReferenceName(EObject semanticObject, CrossReference reference) {
        EReference ref = GrammarUtil.getReference(reference);
        String clazz = semanticObject.eClass().getName();
        if (ref.getEContainingClass() != semanticObject.eClass()) {
            clazz = String.valueOf(ref.getEContainingClass().getName()) + "(" + clazz + ")";
        }
        return String.valueOf(clazz) + "." + ref.getName();
    }

    public ISerializationDiagnostic getInvalidEnumValueDiagnostic(EObject semanticObject, RuleCall rc, Object value) {
        ArrayList<String> valid = Lists.newArrayList();
        for (EnumLiteralDeclaration eld : EcoreUtil2.getAllContentsOfType(rc.getRule(), EnumLiteralDeclaration.class)) {
            valid.add(eld.getEnumLiteral().getInstance().getName());
        }
        StringBuilder msg = new StringBuilder();
        msg.append("The value '" + value + "' is invalid for enum " + rc.getRule().getName() + "\n");
        msg.append("Valid values are: " + Joiner.on(", ").join(valid));
        return new SerializationDiagnostic("invalid enum value", semanticObject, rc, msg.toString());
    }

    public ISerializationDiagnostic getNoEObjectDescriptionFoundDiagnostic(EObject semanticObject, CrossReference element, EObject target, IScope scope) {
        String msg = "No EObjectDescription could be found in Scope " + this.getFullReferenceName(semanticObject, element) + " for " + EmfFormatter.objPath(target);
        return new SerializationDiagnostic("no eobject description found", semanticObject, element, msg);
    }

    public ISerializationDiagnostic getNoScopeFoundDiagnostic(EObject semanticObject, CrossReference element, EObject target) {
        String msg = "Could not create Scope for EReference " + this.getFullReferenceName(semanticObject, element);
        return new SerializationDiagnostic("no scope found", semanticObject, element, msg);
    }

    public ISerializationDiagnostic getNullNotAllowedDiagnostic(EObject semanticObject, AbstractElement ele) {
        return new SerializationDiagnostic("null not allowed", semanticObject, ele, "Must not be null");
    }

    public ISerializationDiagnostic getValueConversionExceptionDiagnostic(EObject semanticObject, AbstractElement element, Object value, Throwable exception) {
        return new SerializationDiagnostic("value conversion exception", semanticObject, element, exception.getMessage());
    }
}

