/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.mwe;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.xtext.mwe.ISlotEntry;
import org.eclipse.xtext.resource.IResourceDescriptions;

public class ResourceLoadingSlotEntry
implements ISlotEntry {
    private String slot;
    private Set<Pattern> uris = Sets.newHashSet();

    public void setSlot(String slot) {
        this.slot = slot;
    }

    public void addUri(String uri) {
        this.uris.add(Pattern.compile(uri));
    }

    public void put(WorkflowContext ctx, IResourceDescriptions descriptions, ResourceSet resourceSet) {
        EList<Resource> resources = resourceSet.getResources();
        ArrayList<Resource> result = Lists.newArrayList();
        for (Resource resource : resources) {
            if (!this.isMatch(resource)) continue;
            result.add(resource);
        }
        ctx.set(this.slot, result);
    }

    protected boolean isMatch(Resource resource) {
        if (this.uris.isEmpty()) {
            return true;
        }
        for (Pattern uriPattern : this.uris) {
            if (!uriPattern.matcher(resource.getURI().toString()).matches()) continue;
            return true;
        }
        return false;
    }

    public void preInvoke() {
        if (this.slot == null) {
            throw new IllegalStateException("'slot' has not been configured");
        }
    }
}

