/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.parser.antlr;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.UnorderedGroup;
import org.eclipse.xtext.generator.BindFactory;
import org.eclipse.xtext.generator.Binding;
import org.eclipse.xtext.generator.Naming;
import org.eclipse.xtext.generator.parser.antlr.AbstractAntlrGeneratorFragment;
import org.eclipse.xtext.generator.parser.antlr.splitting.BacktrackingGuardRemover;
import org.eclipse.xtext.util.Files;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtextAntlrUiGeneratorFragment
extends AbstractAntlrGeneratorFragment {
    private boolean removeBacktrackingGuards = false;
    private int lookaheadThreshold = Integer.MAX_VALUE;

    public void setRemoveBacktrackingGuards(boolean removeBacktrackingGuards) {
        this.removeBacktrackingGuards = removeBacktrackingGuards;
    }

    public void setLookaheadThreshold(String lookaheadThreshold) {
        this.lookaheadThreshold = Integer.parseInt(lookaheadThreshold);
    }

    protected void removeBacktrackingGuardsIfEnabled(String absoluteGrammarFileName) {
        if (this.removeBacktrackingGuards) {
            String javaFile = absoluteGrammarFileName.replaceAll("\\.g$", this.getParserFileNameSuffix());
            String content = Files.readFileIntoString(javaFile);
            BacktrackingGuardRemover remover = new BacktrackingGuardRemover(content, this.lookaheadThreshold);
            String newContent = remover.transform();
            Files.writeStringIntoFile(javaFile, newContent);
        }
    }

    @Override
    public void generate(Grammar grammar, XpandExecutionContext ctx) {
        super.generate(grammar, ctx);
        String srcUiGenPath = ctx.getOutput().getOutlet("SRC_GEN_UI").getPath();
        String encoding = this.getEncoding(ctx, "SRC_GEN_UI");
        String absoluteGrammarFileName = String.valueOf(srcUiGenPath) + "/" + XtextAntlrUiGeneratorFragment.getGrammarFileName(grammar, this.getNaming()).replace('.', '/') + ".g";
        this.addAntlrParam("-fo");
        this.addAntlrParam(absoluteGrammarFileName.substring(0, absoluteGrammarFileName.lastIndexOf(47)));
        this.getAntlrTool().runWithEncodingAndParams(absoluteGrammarFileName, encoding, this.getAntlrParams());
        this.simplifyUnorderedGroupPredicatesIfRequired(grammar, absoluteGrammarFileName);
        this.splitParserAndLexerIfEnabled(absoluteGrammarFileName);
        this.suppressWarnings(absoluteGrammarFileName);
        this.removeBacktrackingGuardsIfEnabled(absoluteGrammarFileName);
    }

    @Override
    public void checkConfiguration(Issues issues) {
        super.checkConfiguration(issues);
        if (this.getOptions().isBacktrackLexer()) {
            issues.addError("This fragment does not support the option 'backtracking' for the lexer. Use 'org.eclipse.xtext.generator.parser.antlr.ex.ca.ContentAssistParserGeneratorFragment' instead");
        }
        if (this.getOptions().isIgnoreCase()) {
            issues.addError("This fragment does not support the option 'ignoreCase'. Use 'org.eclipse.xtext.generator.parser.antlr.ex.ca.ContentAssistParserGeneratorFragment' instead");
        }
    }

    @Override
    public Set<Binding> getGuiceBindingsUi(Grammar grammar) {
        return new BindFactory().addTypeToType("org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext.Factory", "org.eclipse.xtext.ui.editor.contentassist.antlr.ParserBasedContentAssistContextFactory").addTypeToType("org.eclipse.xtext.ui.editor.contentassist.antlr.IContentAssistParser", XtextAntlrUiGeneratorFragment.getParserClassName(grammar, this.getNaming())).addConfiguredBinding("ContentAssistLexerProvider", "binder.bind(" + XtextAntlrUiGeneratorFragment.getInternalLexerClassName(grammar, this.getNaming()) + ".class)" + ".toProvider(org.eclipse.xtext.parser.antlr.LexerProvider.create(" + XtextAntlrUiGeneratorFragment.getInternalLexerClassName(grammar, this.getNaming()) + ".class))").addConfiguredBinding("ContentAssistLexer", "binder.bind(org.eclipse.xtext.ui.editor.contentassist.antlr.internal.Lexer.class).annotatedWith(com.google.inject.name.Names.named(org.eclipse.xtext.ui.LexerUIBindings.CONTENT_ASSIST)).to(" + XtextAntlrUiGeneratorFragment.getInternalLexerClassName(grammar, this.getNaming()) + ".class)").getBindings();
    }

    @Override
    public String[] getRequiredBundlesUi(Grammar grammar) {
        return new String[]{"org.antlr.runtime"};
    }

    @Override
    public String[] getExportedPackagesUi(Grammar grammar) {
        return new String[]{String.valueOf(this.getNaming().basePackageUi(grammar)) + ".contentassist.antlr"};
    }

    public static String getParserClassName(Grammar g, Naming naming) {
        return String.valueOf(naming.basePackageUi(g)) + ".contentassist.antlr." + GrammarUtil.getName(g) + "Parser";
    }

    public static String getInternalLexerClassName(Grammar g, Naming naming) {
        return String.valueOf(naming.basePackageUi(g)) + ".contentassist.antlr.internal.Internal" + GrammarUtil.getName(g) + "Lexer";
    }

    public static String getInternalParserClassName(Grammar g, Naming naming) {
        return String.valueOf(naming.basePackageUi(g)) + ".contentassist.antlr.internal.Internal" + GrammarUtil.getName(g) + "Parser";
    }

    public static String getGrammarFileName(Grammar g, Naming naming) {
        return String.valueOf(naming.basePackageUi(g)) + ".contentassist.antlr.internal.Internal" + GrammarUtil.getName(g);
    }

    public static Collection<Alternatives> getAllAlternatives(Grammar g) {
        return XtextAntlrUiGeneratorFragment.getAllElementsByType(g, Alternatives.class);
    }

    public static Collection<UnorderedGroup> getAllUnorderedGroups(Grammar g) {
        return XtextAntlrUiGeneratorFragment.getAllElementsByType(g, UnorderedGroup.class);
    }

    public static Collection<Group> getAllGroups(Grammar g) {
        return XtextAntlrUiGeneratorFragment.getAllElementsByType(g, Group.class);
    }

    public static Collection<Assignment> getAllAssignments(Grammar g) {
        return XtextAntlrUiGeneratorFragment.getAllElementsByType(g, Assignment.class);
    }

    public static Collection<AbstractElement> getAllPredicatedElements(Grammar g) {
        Collection<AbstractElement> unfiltered = XtextAntlrUiGeneratorFragment.getAllElementsByType(g, AbstractElement.class);
        Collection<AbstractElement> result = Collections2.filter(unfiltered, new Predicate<AbstractElement>(){

            @Override
            public boolean apply(AbstractElement input) {
                return input.isPredicated() || input.isFirstSetPredicated();
            }
        });
        return result;
    }

    private static <T extends AbstractElement> Collection<T> getAllElementsByType(Grammar g, Class<T> type) {
        List<ParserRule> allParserRules = GrammarUtil.allParserRules(g);
        ArrayList<T> result = new ArrayList<T>(30);
        for (ParserRule rule : allParserRules) {
            result.addAll(EcoreUtil2.getAllContentsOfType(rule, type));
        }
        List<EnumRule> allEnumRules = GrammarUtil.allEnumRules(g);
        for (EnumRule rule : allEnumRules) {
            result.addAll(EcoreUtil2.getAllContentsOfType(rule, type));
        }
        return result;
    }
}

