/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.util;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ForwardingMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.common.primitives.Booleans;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmComponentType;
import org.eclipse.xtext.common.types.JvmDelegateTypeReference;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMultiTypeReference;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmSynonymTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmVoid;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.util.AbstractConformanceVisitor;
import org.eclipse.xtext.common.types.util.AbstractTypeReferenceVisitor;
import org.eclipse.xtext.common.types.util.ITypeArgumentContext;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.SuperTypeCollector;
import org.eclipse.xtext.common.types.util.TypeArgumentContextProvider;
import org.eclipse.xtext.common.types.util.TypeConformanceComputationArgument;
import org.eclipse.xtext.common.types.util.TypeConformanceResult;
import org.eclipse.xtext.common.types.util.TypeConformanceStrategySelector;
import org.eclipse.xtext.common.types.util.TypeReferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
@Singleton
public class TypeConformanceComputer {
    protected AbstractConformanceVisitor<JvmTypeReference> leftDispatcher = this.createStrategySelector();
    @Inject
    protected SuperTypeCollector superTypeCollector;
    @Inject
    protected TypesFactory factory = TypesFactory.eINSTANCE;
    @Inject
    protected TypeArgumentContextProvider typeArgumentContextProvider;
    @Inject
    protected Primitives primitives;
    @Inject
    protected TypeReferences typeReferences;

    public void setSuperTypeCollector(SuperTypeCollector superTypeCollector) {
        this.superTypeCollector = superTypeCollector;
    }

    protected TypeConformanceStrategySelector createStrategySelector() {
        return new TypeConformanceStrategySelector(this);
    }

    public void setPrimitives(Primitives primitives) {
        this.primitives = primitives;
    }

    public void setFactory(TypesFactory factory) {
        this.factory = factory;
    }

    public void setTypeArgumentContextProvider(TypeArgumentContextProvider typeArgumentContextProvider) {
        this.typeArgumentContextProvider = typeArgumentContextProvider;
    }

    public void setTypeReferences(TypeReferences typeReferences) {
        this.typeReferences = typeReferences;
    }

    public boolean isConformant(JvmTypeReference left, JvmTypeReference right) {
        return this.isConformant(left, right, false);
    }

    public boolean isConformant(JvmTypeReference left, JvmTypeReference right, boolean ignoreGenerics) {
        if (left == right && left != null) {
            return true;
        }
        TypeConformanceResult result = this.isConformant(left, right, new TypeConformanceComputationArgument(ignoreGenerics, false, true));
        return result.isConformant();
    }

    public TypeConformanceResult isConformant(JvmTypeReference left, JvmTypeReference right, TypeConformanceComputationArgument flags) {
        if (left == right && left != null) {
            return TypeConformanceResult.SUCCESS;
        }
        return (TypeConformanceResult)this.leftDispatcher.visit(left, TypeConformanceComputationArgument.Internal.create(right, flags.rawType, flags.asTypeArgument, flags.allowPrimitiveConversion));
    }

    protected boolean isPrimitiveVoid(JvmTypeReference reference) {
        return reference.getType() instanceof JvmVoid;
    }

    public JvmTypeReference getCommonSuperType(List<JvmTypeReference> types) {
        if (types == null || types.isEmpty()) {
            throw new IllegalArgumentException("Types can't be null or empty " + types);
        }
        if (types.size() == 1) {
            return types.get(0);
        }
        for (JvmTypeReference type : types) {
            if (this.conformsToAll(type, types)) {
                return type;
            }
            if (!this.isPrimitiveVoid(type)) continue;
            return null;
        }
        if (this.containsPrimitiveOrAnyReferences(types)) {
            List<JvmTypeReference> withoutPrimitives = this.replacePrimitivesAndRemoveAnyReferences(types);
            if (withoutPrimitives.equals(types)) {
                return null;
            }
            return this.getCommonSuperType(withoutPrimitives);
        }
        JvmTypeReference firstType = types.get(0);
        List<JvmTypeReference> tail = types.subList(1, types.size());
        LinkedHashMultimap<JvmType, JvmTypeReference> all = LinkedHashMultimap.create();
        LinkedHashMultiset<JvmType> cumulatedDistance = LinkedHashMultiset.create();
        this.initializeDistance(firstType, all, cumulatedDistance);
        this.cumulateDistance(tail, all, cumulatedDistance);
        ArrayList<Multiset.Entry<JvmType>> candidates = Lists.newArrayList(cumulatedDistance.entrySet());
        if (candidates.size() == 1) {
            JvmType firstRawType = (JvmType)((Multiset.Entry)candidates.get(0)).getElement();
            return this.getFirstForRawType(all, firstRawType);
        }
        this.inplaceSortByDistanceAndName(candidates);
        ArrayList<JvmTypeReference> referencesWithSameDistance = Lists.newArrayListWithExpectedSize(2);
        int wasDistance = -1;
        boolean classSeen = false;
        block1: for (Multiset.Entry entry : candidates) {
            JvmType rawType = (JvmType)entry.getElement();
            JvmTypeReference result = null;
            if (wasDistance == -1) {
                wasDistance = entry.getCount();
            } else if (wasDistance != entry.getCount()) {
                if (classSeen) break;
                result = this.getTypeParametersForSupertype(all, rawType, types);
                for (JvmTypeReference alreadyCollected : referencesWithSameDistance) {
                    if (!this.isConformant(result, alreadyCollected, true)) continue;
                    classSeen = classSeen || this.isClass(rawType);
                    continue block1;
                }
                wasDistance = entry.getCount();
            }
            if (result == null) {
                result = this.getTypeParametersForSupertype(all, rawType, types);
            }
            if (result == null) continue;
            boolean isClass = this.isClass(rawType);
            boolean bl = classSeen = classSeen || isClass;
            if (isClass) {
                referencesWithSameDistance.add(0, result);
                continue;
            }
            referencesWithSameDistance.add(result);
        }
        if (referencesWithSameDistance.size() == 1) {
            return (JvmTypeReference)referencesWithSameDistance.get(0);
        }
        if (referencesWithSameDistance.size() > 1) {
            JvmMultiTypeReference jvmMultiTypeReference = this.typeReferences.createMultiTypeReference(((JvmTypeReference)referencesWithSameDistance.get(0)).getType(), new JvmTypeReference[0]);
            if (jvmMultiTypeReference == null) {
                return jvmMultiTypeReference;
            }
            for (JvmTypeReference reference : referencesWithSameDistance) {
                jvmMultiTypeReference.getReferences().add(EcoreUtil2.cloneIfContained(reference));
            }
            return jvmMultiTypeReference;
        }
        return null;
    }

    protected boolean isClass(JvmType type) {
        if (type instanceof JvmArrayType) {
            return this.isClass(((JvmArrayType)type).getComponentType());
        }
        return type instanceof JvmGenericType && !((JvmGenericType)type).isInterface();
    }

    protected JvmType findContext(JvmTypeReference firstType) {
        if (firstType instanceof JvmGenericArrayTypeReference) {
            return this.findContext(((JvmGenericArrayTypeReference)firstType).getComponentType());
        }
        return firstType.getType();
    }

    protected List<JvmTypeReference> replacePrimitivesAndRemoveAnyReferences(List<JvmTypeReference> types) {
        ArrayList<JvmTypeReference> result = Lists.newArrayList();
        for (JvmTypeReference type : types) {
            if (type instanceof JvmAnyTypeReference) continue;
            result.add(this.primitives.asWrapperTypeIfPrimitive(type));
        }
        return result;
    }

    protected boolean containsPrimitiveOrAnyReferences(List<JvmTypeReference> types) {
        for (JvmTypeReference type : types) {
            if (this.isPrimitiveType(type)) {
                return true;
            }
            if (!(type instanceof JvmAnyTypeReference)) continue;
            return true;
        }
        return false;
    }

    protected List<JvmTypeReference> getComponentTypes(List<JvmTypeReference> types) {
        AbstractTypeReferenceVisitor.InheritanceAware<JvmTypeReference> componentTypeComputer = new AbstractTypeReferenceVisitor.InheritanceAware<JvmTypeReference>(){

            @Override
            public JvmTypeReference doVisitTypeReference(JvmTypeReference reference) {
                return null;
            }

            @Override
            protected JvmTypeReference handleNullReference() {
                return null;
            }

            @Override
            public JvmTypeReference doVisitMultiTypeReference(JvmMultiTypeReference multi) {
                JvmMultiTypeReference result = TypeConformanceComputer.this.factory.createJvmMultiTypeReference();
                for (JvmTypeReference reference : multi.getReferences()) {
                    JvmTypeReference component = (JvmTypeReference)this.visit(reference);
                    if (component == null) continue;
                    if (component.eContainer() == null) {
                        result.getReferences().add(component);
                        continue;
                    }
                    JvmDelegateTypeReference delegate = TypeConformanceComputer.this.factory.createJvmDelegateTypeReference();
                    delegate.setDelegate(component);
                    result.getReferences().add(delegate);
                }
                return result;
            }

            @Override
            public JvmTypeReference doVisitGenericArrayTypeReference(JvmGenericArrayTypeReference reference) {
                return reference.getComponentType();
            }

            @Override
            public JvmTypeReference doVisitSynonymTypeReference(JvmSynonymTypeReference synonym) {
                JvmTypeReference result = null;
                for (JvmTypeReference reference : synonym.getReferences()) {
                    JvmTypeReference component = (JvmTypeReference)this.visit(reference);
                    if (component == null) continue;
                    if (result == null) {
                        result = component;
                        continue;
                    }
                    if (!(result instanceof JvmSynonymTypeReference)) {
                        JvmSynonymTypeReference newResult = TypeConformanceComputer.this.factory.createJvmSynonymTypeReference();
                        if (result.eContainer() == null) {
                            newResult.getReferences().add(result);
                        } else {
                            JvmDelegateTypeReference delegate = TypeConformanceComputer.this.factory.createJvmDelegateTypeReference();
                            delegate.setDelegate(component);
                            newResult.getReferences().add(delegate);
                        }
                        result = newResult;
                    }
                    if (component.eContainer() == null) {
                        ((JvmSynonymTypeReference)result).getReferences().add(result);
                        continue;
                    }
                    JvmDelegateTypeReference delegate = TypeConformanceComputer.this.factory.createJvmDelegateTypeReference();
                    delegate.setDelegate(component);
                    ((JvmSynonymTypeReference)result).getReferences().add(delegate);
                }
                return result;
            }
        };
        ArrayList<JvmTypeReference> result = Lists.newArrayList();
        for (JvmTypeReference reference : types) {
            JvmTypeReference componentType = (JvmTypeReference)componentTypeComputer.visit(reference);
            result.add(componentType);
        }
        return result;
    }

    protected boolean allTypesAreArrays(List<JvmTypeReference> types) {
        AbstractTypeReferenceVisitor.InheritanceAware<Boolean> isArrayVisitor = new AbstractTypeReferenceVisitor.InheritanceAware<Boolean>(){

            @Override
            protected Boolean handleNullReference() {
                return Boolean.FALSE;
            }

            @Override
            public Boolean doVisitTypeReference(JvmTypeReference reference) {
                return Boolean.FALSE;
            }

            @Override
            public Boolean doVisitMultiTypeReference(JvmMultiTypeReference multi) {
                for (JvmTypeReference reference : multi.getReferences()) {
                    if (((Boolean)this.visit(reference)).booleanValue()) continue;
                    return Boolean.FALSE;
                }
                return !multi.getReferences().isEmpty();
            }

            @Override
            public Boolean doVisitGenericArrayTypeReference(JvmGenericArrayTypeReference reference) {
                if (reference.getComponentType() != null) {
                    return true;
                }
                return false;
            }

            @Override
            public Boolean doVisitSynonymTypeReference(JvmSynonymTypeReference synonym) {
                for (JvmTypeReference reference : synonym.getReferences()) {
                    if (!((Boolean)this.visit(reference)).booleanValue()) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
        for (JvmTypeReference reference : types) {
            if (((Boolean)isArrayVisitor.visit(reference)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    protected boolean isPrimitiveType(JvmTypeReference reference) {
        return reference.getType() instanceof JvmPrimitiveType;
    }

    protected JvmTypeReference getTypeParametersForSupertype(final Multimap<JvmType, JvmTypeReference> all, JvmType rawType, List<JvmTypeReference> initiallyRequested) {
        Function<JvmTypeReference, JvmTypeReference> getComponentType;
        JvmComponentType componentType;
        ForwardingMultimap<JvmType, JvmTypeReference> decorated;
        JvmTypeReference jvmTypeReference;
        if (rawType instanceof JvmTypeParameterDeclarator) {
            EList<JvmTypeParameter> typeParameters = ((JvmTypeParameterDeclarator)((Object)rawType)).getTypeParameters();
            if (typeParameters.isEmpty()) {
                return this.getFirstForRawType(all, rawType);
            }
            ArrayList<Object> parameterSuperTypes = Lists.newArrayList();
            int i = 0;
            while (i < typeParameters.size()) {
                ArrayList<JvmTypeReference> arrayList = Lists.newArrayList();
                for (JvmTypeReference reference : all.get(rawType)) {
                    if (reference instanceof JvmParameterizedTypeReference) {
                        JvmParameterizedTypeReference parameterized = (JvmParameterizedTypeReference)reference;
                        if (parameterized.getArguments().isEmpty()) {
                            JvmParameterizedTypeReference result = this.factory.createJvmParameterizedTypeReference();
                            result.setType(rawType);
                            return result;
                        }
                        JvmTypeReference parameterReference = (JvmTypeReference)parameterized.getArguments().get(i);
                        arrayList.add(parameterReference);
                        continue;
                    }
                    return null;
                }
                JvmTypeReference parameterSuperType = this.getCommonParameterSuperType(arrayList, initiallyRequested);
                if (parameterSuperType == null) {
                    return null;
                }
                parameterSuperTypes.add(parameterSuperType);
                ++i;
            }
            JvmParameterizedTypeReference result = this.factory.createJvmParameterizedTypeReference();
            result.setType(rawType);
            for (JvmTypeReference jvmTypeReference2 : parameterSuperTypes) {
                result.getArguments().add(EcoreUtil2.clone(jvmTypeReference2));
            }
            return result;
        }
        if (rawType instanceof JvmArrayType && (jvmTypeReference = this.getTypeParametersForSupertype((Multimap<JvmType, JvmTypeReference>)(decorated = new ForwardingMultimap<JvmType, JvmTypeReference>(componentType = ((JvmArrayType)rawType).getComponentType(), rawType, (Function)(getComponentType = new Function<JvmTypeReference, JvmTypeReference>(){

            @Override
            public JvmTypeReference apply(JvmTypeReference from) {
                if (from instanceof JvmGenericArrayTypeReference) {
                    return ((JvmGenericArrayTypeReference)from).getComponentType();
                }
                return from;
            }
        })){
            private final /* synthetic */ JvmComponentType val$componentType;
            private final /* synthetic */ JvmType val$rawType;
            private final /* synthetic */ Function val$getComponentType;
            {
                this.val$componentType = jvmComponentType;
                this.val$rawType = jvmType;
                this.val$getComponentType = function;
            }

            @Override
            protected Multimap<JvmType, JvmTypeReference> delegate() {
                return all;
            }

            @Override
            public Collection<JvmTypeReference> get(JvmType key) {
                if (key == this.val$componentType) {
                    Collection result = all.get(this.val$rawType);
                    return Collections2.transform(result, this.val$getComponentType);
                }
                return super.get(key);
            }
        }), componentType, Lists.transform(initiallyRequested, getComponentType))) != null) {
            if (jvmTypeReference.eContainer() instanceof JvmGenericArrayTypeReference) {
                return (JvmTypeReference)jvmTypeReference.eContainer();
            }
            JvmGenericArrayTypeReference result = this.factory.createJvmGenericArrayTypeReference();
            result.setComponentType(jvmTypeReference);
            return result;
        }
        return null;
    }

    protected JvmTypeReference getFirstForRawType(Multimap<JvmType, JvmTypeReference> all, JvmType rawType) {
        for (JvmTypeReference result : all.get(rawType)) {
            if (!(result instanceof JvmParameterizedTypeReference) && !(result instanceof JvmGenericArrayTypeReference)) continue;
            return result;
        }
        throw new IllegalStateException(String.valueOf(all.toString()) + " does not contain a useful type reference for rawtype " + rawType.getQualifiedName());
    }

    protected void initializeDistance(JvmTypeReference firstType, Multimap<JvmType, JvmTypeReference> all, Multiset<JvmType> cumulatedDistance) {
        ITypeArgumentContext firstContext = this.getTypeArgumentContextProvider().getTypeArgumentContext(new TypeArgumentContextProvider.ReceiverRequest(firstType));
        MaxDistanceRawTypeAcceptor acceptor = new MaxDistanceRawTypeAcceptor(cumulatedDistance, all, new ArgumentResolver(firstContext));
        acceptor.accept(firstType, 0);
        this.superTypeCollector.collectSuperTypes(firstType, acceptor);
    }

    protected void cumulateDistance(List<JvmTypeReference> references, Multimap<JvmType, JvmTypeReference> all, Multiset<JvmType> cumulatedDistance) {
        for (JvmTypeReference other : references) {
            LinkedHashMultiset<JvmType> otherDistance = LinkedHashMultiset.create();
            this.initializeDistance(other, all, otherDistance);
            cumulatedDistance.retainAll(otherDistance);
            for (Multiset.Entry typeToDistance : otherDistance.entrySet()) {
                if (!cumulatedDistance.contains(typeToDistance.getElement())) continue;
                cumulatedDistance.add((JvmType)typeToDistance.getElement(), typeToDistance.getCount());
            }
        }
    }

    protected void inplaceSortByDistanceAndName(List<Multiset.Entry<JvmType>> candidates) {
        Collections.sort(candidates, new Comparator<Multiset.Entry<JvmType>>(){

            @Override
            public int compare(Multiset.Entry<JvmType> o1, Multiset.Entry<JvmType> o2) {
                if (o1.getCount() == o2.getCount()) {
                    JvmType element1 = o1.getElement();
                    JvmType element2 = o2.getElement();
                    return this.compare(element1, element2);
                }
                if (o1.getCount() < o2.getCount()) {
                    return -1;
                }
                return 1;
            }

            @Override
            protected int compare(JvmType element1, JvmType element2) {
                int result;
                if (element1 instanceof JvmArrayType && element2 instanceof JvmArrayType) {
                    return this.compare(((JvmArrayType)element1).getComponentType(), ((JvmArrayType)element2).getComponentType());
                }
                if (element1 instanceof JvmGenericType && element2 instanceof JvmGenericType && (result = Booleans.compare(((JvmGenericType)element1).isInterface(), ((JvmGenericType)element2).isInterface())) != 0) {
                    return result;
                }
                return element1.getIdentifier().compareTo(element2.getIdentifier());
            }
        });
    }

    public JvmTypeReference getCommonParameterSuperType(List<JvmTypeReference> types, List<JvmTypeReference> initiallyRequested) {
        HashSet<String> initiallyRequestedNames;
        Function<JvmTypeReference, String> getCanonicalName = new Function<JvmTypeReference, String>(){

            @Override
            public String apply(JvmTypeReference from) {
                return from.getIdentifier();
            }
        };
        HashSet<String> allNames = Sets.newHashSet(Iterables.transform(types, getCanonicalName));
        if (allNames.size() == 1) {
            return types.get(0);
        }
        if (types.size() == initiallyRequested.size() && (initiallyRequestedNames = Sets.newHashSet(Iterables.transform(initiallyRequested, getCanonicalName))).equals(allNames)) {
            JvmTypeReference objectTypeReference = this.typeReferences.getTypeForName(Object.class, (Notifier)types.get(0).getType(), new JvmTypeReference[0]);
            return this.typeReferences.wildCardExtends(objectTypeReference);
        }
        JvmTypeReference superType = this.getCommonSuperType(types);
        if (superType instanceof JvmWildcardTypeReference) {
            return superType;
        }
        JvmWildcardTypeReference wildcardTypeReference = this.factory.createJvmWildcardTypeReference();
        if (superType != null) {
            JvmUpperBound upperBound = this.factory.createJvmUpperBound();
            upperBound.setTypeReference(EcoreUtil2.clone(superType));
            wildcardTypeReference.getConstraints().add(upperBound);
        }
        return wildcardTypeReference;
    }

    protected boolean conformsToAll(JvmTypeReference type, List<JvmTypeReference> types) {
        boolean conform = true;
        int i = 0;
        while (conform && i < types.size()) {
            conform = this.isConformant(type, types.get(i));
            ++i;
        }
        return conform;
    }

    protected TypeReferences getTypeReferences() {
        return this.typeReferences;
    }

    protected SuperTypeCollector getSuperTypeCollector() {
        return this.superTypeCollector;
    }

    protected Primitives getPrimitives() {
        return this.primitives;
    }

    protected TypeArgumentContextProvider getTypeArgumentContextProvider() {
        return this.typeArgumentContextProvider;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ArgumentResolver
    implements Function<JvmTypeReference, JvmTypeReference> {
        private final ITypeArgumentContext context;

        protected ArgumentResolver(ITypeArgumentContext context) {
            this.context = context;
        }

        @Override
        public JvmTypeReference apply(JvmTypeReference from) {
            JvmTypeReference result = this.context.resolve(from);
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MaxDistanceRawTypeAcceptor
    implements SuperTypeCollector.SuperTypeAcceptor {
        private final Multiset<JvmType> distances;
        private final Multimap<JvmType, JvmTypeReference> rawTypeToReference;
        private final Function<JvmTypeReference, JvmTypeReference> resolver;

        protected MaxDistanceRawTypeAcceptor(Multiset<JvmType> result, Multimap<JvmType, JvmTypeReference> all, Function<JvmTypeReference, JvmTypeReference> resolver) {
            this.distances = result;
            this.rawTypeToReference = all;
            this.resolver = resolver;
        }

        @Override
        public boolean accept(JvmTypeReference superType, int distance) {
            if (superType == null) {
                return false;
            }
            JvmType type = superType.getType();
            this.rawTypeToReference.put(type, this.resolver.apply(superType));
            if (this.distances.contains(type)) {
                int currentCount = this.distances.count(type);
                if (currentCount < distance + 1) {
                    this.distances.setCount(type, distance + 1);
                }
            } else {
                this.distances.add(type, distance + 1);
            }
            return true;
        }
    }
}

