/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.binary.asm;

import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xtext.common.types.JvmAnnotationAnnotationValue;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationValue;
import org.eclipse.xtext.common.types.JvmEnumAnnotationValue;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.access.binary.asm.BinarySignatures;
import org.eclipse.xtext.common.types.access.binary.asm.BinaryTypeSignature;
import org.eclipse.xtext.common.types.access.binary.asm.JvmAnnotationValueBuilder;
import org.eclipse.xtext.common.types.access.binary.asm.Proxies;
import org.objectweb.asm.AnnotationVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvmAnnotationReferenceBuilder
extends AnnotationVisitor {
    protected final Proxies proxies;
    private final InternalEList<JvmAnnotationReference> target;
    private final JvmAnnotationReference result;
    private final InternalEList<JvmAnnotationValue> values;
    private final BinaryTypeSignature annotationType;

    public JvmAnnotationReferenceBuilder(InternalEList<JvmAnnotationReference> target, String desc, Proxies proxies) {
        super(327680);
        this.proxies = proxies;
        this.target = target;
        this.annotationType = BinarySignatures.createTypeSignature(desc);
        this.result = TypesFactory.eINSTANCE.createJvmAnnotationReference();
        this.result.setAnnotation(proxies.createAnnotationProxy(this.annotationType));
        this.values = (InternalEList)this.result.getExplicitValues();
    }

    @Override
    public void visit(String name, Object value) {
        JvmAnnotationValue annotationValue = this.proxies.createAnnotationValue(value);
        annotationValue.setOperation(this.proxies.createMethodProxy(this.annotationType, name));
        this.values.addUnique(annotationValue);
    }

    @Override
    public void visitEnum(String name, String desc, String value) {
        JvmEnumAnnotationValue result = TypesFactory.eINSTANCE.createJvmEnumAnnotationValue();
        JvmEnumerationLiteral enumLiteralProxy = this.proxies.createEnumLiteral(value, desc);
        ((InternalEList)result.getValues()).addUnique(enumLiteralProxy);
        result.setOperation(this.proxies.createMethodProxy(this.annotationType, name));
        this.values.addUnique(result);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name, String desc) {
        JvmAnnotationAnnotationValue annotationValue = TypesFactory.eINSTANCE.createJvmAnnotationAnnotationValue();
        InternalEList nestedValues = (InternalEList)annotationValue.getValues();
        annotationValue.setOperation(this.proxies.createMethodProxy(this.annotationType, name));
        JvmAnnotationReferenceBuilder annotation = new JvmAnnotationReferenceBuilder(nestedValues, desc, this.proxies);
        this.values.addUnique(annotationValue);
        return annotation;
    }

    @Override
    public AnnotationVisitor visitArray(final String name) {
        return new JvmAnnotationValueBuilder(this.proxies){

            public void visitEnd() {
                if (this.result == null) {
                    this.result = TypesFactory.eINSTANCE.createJvmCustomAnnotationValue();
                }
                this.result.setOperation(this.proxies.createMethodProxy(JvmAnnotationReferenceBuilder.this.annotationType, name));
                JvmAnnotationReferenceBuilder.this.values.addUnique(this.result);
            }
        };
    }

    @Override
    public void visitEnd() {
        this.target.addUnique(this.result);
    }
}

