/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.common.types.access.ClasspathTypeProviderFactory;
import org.eclipse.xtext.common.types.access.binary.asm.ClassFileBytesAccess;
import org.eclipse.xtext.common.types.access.impl.CachingClasspathTypeProvider;
import org.eclipse.xtext.common.types.access.impl.CachingDeclaredTypeFactory;
import org.eclipse.xtext.common.types.access.impl.ClasspathTypeProvider;
import org.eclipse.xtext.common.types.access.impl.DeclaredTypeFactory;

@Singleton
public class CachingClasspathTypeProviderFactory
extends ClasspathTypeProviderFactory {
    private CachingDeclaredTypeFactory reusedFactory;

    @Inject
    public CachingClasspathTypeProviderFactory(ClassLoader classLoader) {
        super(classLoader);
        this.reusedFactory = this.newClassReaderTypeFactory(classLoader);
    }

    private CachingDeclaredTypeFactory newClassReaderTypeFactory(ClassLoader classLoader) {
        DeclaredTypeFactory factoryDelegate = new DeclaredTypeFactory(new ClassFileBytesAccess(), classLoader);
        return new CachingDeclaredTypeFactory(factoryDelegate);
    }

    protected ClasspathTypeProvider createClasspathTypeProvider(ResourceSet resourceSet) {
        ClassLoader classLoader = this.getClassLoader(resourceSet);
        CachingDeclaredTypeFactory actualFactoryToUse = this.reusedFactory;
        if (!this.isDefaultClassLoader(classLoader)) {
            actualFactoryToUse = this.newClassReaderTypeFactory(classLoader);
        }
        return new CachingClasspathTypeProvider(classLoader, resourceSet, this.getIndexedJvmTypeAccess(), actualFactoryToUse);
    }
}

