/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dnd.IDragAndDropService;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchWindowConfigurer;
import org.eclipse.ui.services.IDisposable;

public class EditorSiteDragAndDropServiceImpl
implements IDragAndDropService,
IDisposable {
    private static String MDT_KEY = "MDT";
    List addedListeners = new ArrayList();

    @Override
    public void addMergedDropTarget(Control control, int ops, Transfer[] transfers, DropTargetListener listener) {
        this.removeMergedDropTarget(control);
        int editorSiteOps = 21;
        WorkbenchWindow ww = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        WorkbenchWindowConfigurer winConfigurer = ww.getWindowConfigurer();
        Transfer[] editorSiteTransfers = winConfigurer.getTransfers();
        DropTargetListener editorSiteListener = winConfigurer.getDropTargetListener();
        MergedDropTarget newTarget = new MergedDropTarget(control, ops, transfers, listener, editorSiteOps, editorSiteTransfers, editorSiteListener);
        this.addedListeners.add(newTarget);
        newTarget.realDropTarget.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent e) {
                Object mdt = e.widget.getData(MDT_KEY);
                EditorSiteDragAndDropServiceImpl.this.addedListeners.remove(mdt);
            }
        });
    }

    private DropTarget getCurrentDropTarget(Control control) {
        if (control == null) {
            return null;
        }
        Object curDT = control.getData("DropTarget");
        return (DropTarget)curDT;
    }

    @Override
    public void removeMergedDropTarget(Control control) {
        DropTarget targetForControl = this.getCurrentDropTarget(control);
        if (targetForControl != null) {
            targetForControl.dispose();
            this.addedListeners.remove(targetForControl);
        }
    }

    @Override
    public void dispose() {
        this.addedListeners.clear();
    }

    private static class MergedDropTarget {
        private DropTarget realDropTarget;
        private Transfer[] secondaryTransfers;
        private DropTargetListener secondaryListener;
        private int secondaryOps;
        private Transfer[] primaryTransfers;
        private DropTargetListener primaryListener;
        private int primaryOps;

        public MergedDropTarget(Control control, int priOps, Transfer[] priTransfers, DropTargetListener priListener, int secOps, Transfer[] secTransfers, DropTargetListener secListener) {
            this.realDropTarget = new DropTarget(control, priOps | secOps);
            this.realDropTarget.setData(MDT_KEY, this);
            this.primaryTransfers = priTransfers;
            this.primaryListener = priListener;
            this.primaryOps = priOps;
            this.secondaryTransfers = secTransfers;
            this.secondaryListener = secListener;
            this.secondaryOps = secOps;
            Transfer[] allTransfers = new Transfer[this.secondaryTransfers.length + this.primaryTransfers.length];
            int curTransfer = 0;
            int i = 0;
            while (i < this.primaryTransfers.length) {
                allTransfers[curTransfer++] = this.primaryTransfers[i];
                ++i;
            }
            i = 0;
            while (i < this.secondaryTransfers.length) {
                allTransfers[curTransfer++] = this.secondaryTransfers[i];
                ++i;
            }
            this.realDropTarget.setTransfer(allTransfers);
            this.realDropTarget.addDropListener(new DropTargetListener(){

                @Override
                public void dragEnter(DropTargetEvent event) {
                    MergedDropTarget.this.getAppropriateListener(event, true).dragEnter(event);
                }

                @Override
                public void dragLeave(DropTargetEvent event) {
                    MergedDropTarget.this.getAppropriateListener(event, false).dragLeave(event);
                }

                @Override
                public void dragOperationChanged(DropTargetEvent event) {
                    MergedDropTarget.this.getAppropriateListener(event, true).dragOperationChanged(event);
                }

                @Override
                public void dragOver(DropTargetEvent event) {
                    MergedDropTarget.this.getAppropriateListener(event, true).dragOver(event);
                }

                @Override
                public void drop(DropTargetEvent event) {
                    MergedDropTarget.this.getAppropriateListener(event, true).drop(event);
                }

                @Override
                public void dropAccept(DropTargetEvent event) {
                    MergedDropTarget.this.getAppropriateListener(event, true).dropAccept(event);
                }
            });
        }

        private DropTargetListener getAppropriateListener(DropTargetEvent event, boolean checkOperation) {
            if (this.isSupportedType(this.primaryTransfers, event.currentDataType)) {
                if (checkOperation && !this.isSupportedOperation(this.primaryOps, event.detail)) {
                    event.detail = 0;
                }
                return this.primaryListener;
            }
            if (checkOperation && !this.isSupportedOperation(this.secondaryOps, event.detail)) {
                event.detail = 0;
            }
            return this.secondaryListener;
        }

        private boolean isSupportedType(Transfer[] transfers, TransferData transferType) {
            int i = 0;
            while (i < transfers.length) {
                if (transfers[i].isSupportedType(transferType)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private boolean isSupportedOperation(int dropOps, int eventDetail) {
            return ((dropOps | 0x10) & eventDetail) != 0;
        }
    }
}

