/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xpand2.codeassist;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.internal.xpand2.codeassist.FastAnalyzer;
import org.eclipse.internal.xpand2.codeassist.StackElement;
import org.eclipse.internal.xtend.expression.codeassist.ProposalComputer;
import org.eclipse.internal.xtend.expression.codeassist.ProposalFactory;
import org.eclipse.xtend.expression.ExecutionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementProposalComputer
implements ProposalComputer {
    private static final Pattern WS_PATTERN = Pattern.compile("(\\n?[\\t ]*)\\z");

    @Override
    public List<Object> computeProposals(String txt, ExecutionContext ctx, ProposalFactory factory) {
        ArrayList<Object> result = new ArrayList<Object>();
        String prefix = "";
        String ws = this.findTrailingWhitespace(txt);
        Stack<StackElement> s = FastAnalyzer.computeStack(txt);
        if (s.size() > 0) {
            StackElement se = s.peek();
            result.add(factory.createStatementProposal("\u00abEND" + se.block + "\u00bb", "END" + se.block, ""));
            if (this.contains("IF", s)) {
                result.add(factory.createStatementProposal("\u00abELSE\u00bb", "ELSE", ""));
                result.add(factory.createStatementProposal("\u00abELSEIF statement\u00bb", "ELSEIF", ""));
            }
            if (!this.contains("FILE", s)) {
                result.add(this.fileBlockProposal(ws, factory));
            }
            if (!this.contains("PROTECT", s)) {
                result.add(this.protectBlockProposal(ws, factory));
            }
            result.add(this.foreachBlockProposal(ws, factory));
            result.add(this.ifBlockProposal(ws, factory));
            result.add(this.letBlockProposal(ws, factory));
            result.add(this.expandStatementProposal(ws, factory));
            result.add(this.remBlockProposal(ws, factory));
        } else {
            if (txt.indexOf("\u00abDEFINE") == -1) {
                if (txt.indexOf("\u00abEXTENSION") == -1) {
                    result.add(this.importStatementProposal(factory));
                }
                result.add(this.extensionStatementProposal(factory));
            }
            result.add(this.defineBlockProposal(ws, factory));
            result.add(this.aroundBlockProposal(ws, factory));
            result.add(this.remBlockProposal(ws, factory));
        }
        return result;
    }

    private Object importStatementProposal(ProposalFactory factory) {
        String insertString = "\u00abIMPORT my::imported::namespace\u00bb";
        return factory.createStatementProposal("\u00abIMPORT my::imported::namespace\u00bb", "IMPORT statement", "", "\u00abIMPORT my::imported::namespace\u00bb".indexOf("my::imported::namespace"), "my::imported::namespace".length());
    }

    private Object extensionStatementProposal(ProposalFactory factory) {
        String insertString = "\u00abEXTENSION path::to::AbstractExtension\u00bb";
        return factory.createStatementProposal("\u00abEXTENSION path::to::AbstractExtension\u00bb", "EXTENSION statement", "", "\u00abEXTENSION path::to::AbstractExtension\u00bb".indexOf("path::to::AbstractExtension"), "path::to::AbstractExtension".length());
    }

    protected String findTrailingWhitespace(String txt) {
        Matcher m = WS_PATTERN.matcher(txt);
        m.find();
        return m.group(1);
    }

    private Object expandStatementProposal(String ws, ProposalFactory factory) {
        String insertString = "\u00abEXPAND definition FOR this\u00bb";
        return factory.createStatementProposal("\u00abEXPAND definition FOR this\u00bb", "EXPAND statement", "", "\u00abEXPAND definition FOR this\u00bb".indexOf("definition"), "definition".length());
    }

    private Object letBlockProposal(String ws, ProposalFactory factory) {
        String insertString = "\u00abLET expression AS e\u00bb" + ws + "\u00ab" + "ENDLET" + "\u00bb";
        return factory.createStatementProposal(insertString, "LET block", "", insertString.indexOf("expression"), "expression".length());
    }

    private Object ifBlockProposal(String ws, ProposalFactory factory) {
        String insertString = "\u00abIF condition\u00bb" + ws + "\u00ab" + "ENDIF" + "\u00bb";
        return factory.createStatementProposal(insertString, "IF block", "", insertString.indexOf("condition"), "condition".length());
    }

    private Object foreachBlockProposal(String ws, ProposalFactory factory) {
        String insertString = "\u00abFOREACH elements AS e\u00bb" + ws + "\u00ab" + "ENDFOREACH" + "\u00bb";
        return factory.createStatementProposal(insertString, "FOREACH block", "", insertString.indexOf("elements"), "elements".length());
    }

    private Object protectBlockProposal(String ws, ProposalFactory factory) {
        String insertString = "\u00abPROTECT CSTART '/*' CEND '*/' ID uniqueId\u00bb" + ws + "\u00ab" + "ENDPROTECT" + "\u00bb";
        return factory.createStatementProposal(insertString, "PROTECT region", "", insertString.indexOf("uniqueId"), "uniqueId".length());
    }

    private Object fileBlockProposal(String ws, ProposalFactory factory) {
        String insertString = "\u00abFILE fileName\u00bb" + ws + "\u00ab" + "ENDFILE" + "\u00bb";
        return factory.createStatementProposal(insertString, "FILE block", "", insertString.indexOf("fileName"), "fileName".length());
    }

    private Object defineBlockProposal(String ws, ProposalFactory factory) {
        String insertString = "\u00abDEFINE definionName FOR Type\u00bb" + ws + "\u00ab" + "ENDDEFINE" + "\u00bb";
        return factory.createStatementProposal(insertString, "new DEFINE", "", insertString.indexOf("definionName"), "definionName".length());
    }

    private Object aroundBlockProposal(String ws, ProposalFactory factory) {
        String insertString = "\u00abAROUND fullyQualifiedDefinionName FOR Type\u00bb" + ws + "\u00ab" + "ENDAROUND" + "\u00bb";
        return factory.createStatementProposal(insertString, "new AROUND", "", insertString.indexOf("fullyQualifiedDefinionName"), "fullyQualifiedDefinionName".length());
    }

    private Object remBlockProposal(String ws, ProposalFactory factory) {
        String blockContent = "comment";
        String insertString = "\u00abREM\u00bbcomment\u00abENDREM\u00bb";
        return factory.createStatementProposal("\u00abREM\u00bbcomment\u00abENDREM\u00bb", "REM block", "", "\u00abREM\u00bbcomment\u00abENDREM\u00bb".indexOf("comment"), "comment".length());
    }

    private boolean contains(String blockName, Stack<StackElement> s) {
        for (StackElement element : s) {
            if (!element.block.equals(blockName)) continue;
            return true;
        }
        return false;
    }

    protected String findPrefix(String txt) {
        StringBuffer result = new StringBuffer();
        int i = txt.length() - 1;
        char c = txt.charAt(i);
        while (i > 0 && Character.isJavaIdentifierStart(c)) {
            result.append(c);
            c = txt.charAt(--i);
        }
        return result.reverse().toString();
    }
}

