/*
 * Decompiled with CFR 0.152.
 */
package net.danieldietrich.protectedregions.core;

import java.util.Map;
import net.danieldietrich.protectedregions.core.DefaultDocument;
import net.danieldietrich.protectedregions.core.IDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionUtil {
    private RegionUtil() {
    }

    public static IDocument merge(IDocument currentDoc, final IDocument previousDoc) {
        return RegionUtil.merge(currentDoc, new HasMarkedRegions(){

            public IDocument.IRegion get(String id) {
                return previousDoc.getMarkedRegion(id);
            }
        });
    }

    public static IDocument merge(IDocument currentDoc, final Map<String, IDocument.IRegion> pool) {
        return RegionUtil.merge(currentDoc, new HasMarkedRegions(){

            public IDocument.IRegion get(String id) {
                return (IDocument.IRegion)pool.get(id);
            }
        });
    }

    private static IDocument merge(IDocument currentDoc, HasMarkedRegions hasMarkedRegions) {
        DefaultDocument result = new DefaultDocument();
        for (IDocument.IRegion generatedRegion : currentDoc.getRegions()) {
            IDocument.IRegion previousRegion;
            IDocument.IRegion markedRegion = null;
            if (generatedRegion.isMarkedRegion() && (previousRegion = hasMarkedRegions.get(generatedRegion.getId())) != null && previousRegion.isEnabled()) {
                markedRegion = previousRegion;
            }
            result.addRegion(markedRegion != null ? markedRegion : generatedRegion);
        }
        return result;
    }

    public static IDocument fillIn(IDocument currentDoc, IDocument previousDoc) {
        DefaultDocument result = new DefaultDocument();
        for (IDocument.IRegion previousRegion : previousDoc.getRegions()) {
            IDocument.IRegion generatedRegion;
            IDocument.IRegion markedRegion = null;
            if (previousRegion.isMarkedRegion() && (generatedRegion = currentDoc.getMarkedRegion(previousRegion.getId())) != null && previousRegion.isEnabled()) {
                markedRegion = generatedRegion;
            }
            result.addRegion(markedRegion != null ? markedRegion : previousRegion);
        }
        return result;
    }

    private static interface HasMarkedRegions {
        public IDocument.IRegion get(String var1);
    }
}

