/*
 * Decompiled with CFR 0.152.
 */
package net.danieldietrich.protectedregions.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.danieldietrich.protectedregions.core.IDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultDocument
implements IDocument {
    private List<IDocument.IRegion> regions = new ArrayList<IDocument.IRegion>();
    private Map<String, IDocument.IRegion> markedRegions = new HashMap<String, IDocument.IRegion>();

    DefaultDocument() {
    }

    @Override
    public Iterable<IDocument.IRegion> getRegions() {
        return Collections.unmodifiableList(this.regions);
    }

    @Override
    public IDocument.IRegion getMarkedRegion(String id) {
        return this.markedRegions.get(id);
    }

    public void addRegion(IDocument.IRegion region) {
        this.regions.add(region);
        if (region.isMarkedRegion()) {
            if (this.markedRegions.containsKey(region.getId())) {
                throw new IllegalStateException("Duplicate marked region id: " + region.getId());
            }
            this.markedRegions.put(region.getId(), region);
        }
    }

    @Override
    public String getContents() {
        StringBuilder result = new StringBuilder();
        for (IDocument.IRegion region : this.regions) {
            result.append(region.getText());
        }
        return result.toString();
    }
}

