/*
 * Decompiled with CFR 0.152.
 */
package io.tesla.aether.okhttp;

import com.squareup.okhttp.OkAuthenticator;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.internal.tls.OkHostnameVerifier;
import io.tesla.aether.client.AetherClient;
import io.tesla.aether.client.AetherClientAuthentication;
import io.tesla.aether.client.AetherClientConfig;
import io.tesla.aether.client.AetherClientProxy;
import io.tesla.aether.client.Response;
import io.tesla.aether.client.RetryableSource;
import io.tesla.aether.okhttp.ssl.SslContextFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;

public class OkHttpAetherClient
implements AetherClient {
    private Map<String, String> headers;
    private AetherClientConfig config;
    private OkHttpClient httpClient;
    private SSLSocketFactory sslSocketFactory;

    public OkHttpAetherClient(AetherClientConfig config) {
        this.config = config;
        this.headers = new HashMap<String, String>();
        if (config.getHeaders() != null) {
            this.headers.putAll(config.getHeaders());
        }
        if (this.headers != null && !this.headers.containsKey("User-Agent")) {
            this.headers.put("User-Agent", config.getUserAgent());
        }
        this.httpClient = new OkHttpClient();
        this.httpClient.setProxy(this.getProxy(config.getProxy()));
        this.httpClient.setHostnameVerifier(OkHostnameVerifier.INSTANCE);
        if (config.getSslSocketFactory() != null) {
            this.sslSocketFactory = config.getSslSocketFactory();
        }
    }

    @Override
    public Response head(String uri) throws IOException {
        HttpURLConnection ohc;
        do {
            ohc = this.httpClient.open(new URL(uri));
            ohc.setRequestMethod("HEAD");
        } while (this.authenticate(ohc));
        return new ResponseAdapter(ohc);
    }

    @Override
    public Response get(String uri) throws IOException {
        HttpURLConnection ohc;
        do {
            ohc = this.getConnection(uri, null);
            ohc.setRequestMethod("GET");
        } while (this.authenticate(ohc));
        return new ResponseAdapter(ohc);
    }

    @Override
    public Response get(String uri, Map<String, String> requestHeaders) throws IOException {
        HttpURLConnection ohc;
        do {
            ohc = this.getConnection(uri, requestHeaders);
            ohc.setRequestMethod("GET");
        } while (this.authenticate(ohc));
        return new ResponseAdapter(ohc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response put(String uri, RetryableSource source) throws IOException {
        HttpURLConnection ohc;
        do {
            ohc = this.getConnection(uri, null);
            ohc.setUseCaches(false);
            ohc.setRequestProperty("Content-Type", "application/octet-stream");
            ohc.setRequestMethod("PUT");
            ohc.setDoOutput(true);
            if (source.length() > 0L) {
                ohc.setFixedLengthStreamingMode((int)source.length());
            }
            OutputStream os = ohc.getOutputStream();
            try {
                source.copyTo(os);
            }
            finally {
                os.close();
            }
        } while (this.authenticate(ohc));
        return new ResponseAdapter(ohc);
    }

    private boolean authenticate(HttpURLConnection ohc) throws IOException {
        int status;
        try {
            status = ohc.getResponseCode();
        }
        catch (HttpRetryException e) {
            status = e.responseCode();
        }
        switch (status) {
            case 407: {
                if (this.config.getProxy() == null) {
                    throw new ProtocolException("Received HTTP_PROXY_AUTH (407) code while not using proxy");
                }
                if (this.config.getProxy().getAuthentication() == null || this.headers.containsKey("Proxy-Authorization")) break;
                this.headers.put("Proxy-Authorization", this.toHeaderValue(this.config.getProxy().getAuthentication()));
                return true;
            }
            case 401: {
                if (this.config.getAuthentication() == null || this.headers.containsKey("Authorization")) break;
                this.headers.put("Authorization", this.toHeaderValue(this.config.getAuthentication()));
                return true;
            }
        }
        return false;
    }

    private String toHeaderValue(AetherClientAuthentication auth) {
        return OkAuthenticator.Credential.basic(auth.getUsername(), auth.getPassword()).getHeaderValue();
    }

    @Override
    public void setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    private Proxy getProxy(AetherClientProxy proxy) {
        Proxy ohp;
        if (proxy == null) {
            ohp = Proxy.NO_PROXY;
        } else {
            InetSocketAddress addr = new InetSocketAddress(proxy.getHost(), proxy.getPort());
            ohp = new Proxy(Proxy.Type.HTTP, addr);
        }
        return ohp;
    }

    private void checkForSslSystemProperties() {
        if (this.sslSocketFactory == null) {
            String keyStorePath = System.getProperty("javax.net.ssl.keyStore");
            String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
            String keyStoreType = System.getProperty("javax.net.ssl.keyStoreType");
            String trustStorePath = System.getProperty("javax.net.ssl.trustStore");
            String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
            String trustStoreType = System.getProperty("javax.net.ssl.trustStoreType");
            SslContextFactory scf = new SslContextFactory();
            if (keyStorePath != null && keyStorePassword != null) {
                scf.setKeyStorePath(keyStorePath);
                scf.setKeyStorePassword(keyStorePassword);
                scf.setKeyStoreType(keyStoreType);
                if (trustStorePath != null && trustStorePassword != null) {
                    scf.setTrustStore(trustStorePath);
                    scf.setTrustStorePassword(trustStorePassword);
                    scf.setTrustStoreType(trustStoreType);
                }
                try {
                    this.sslSocketFactory = scf.getSslContext().getSocketFactory();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    private HttpURLConnection getConnection(String uri, Map<String, String> requestHeaders) throws IOException {
        this.checkForSslSystemProperties();
        if (this.sslSocketFactory != null) {
            this.httpClient.setSslSocketFactory(this.sslSocketFactory);
        }
        HttpURLConnection ohc = this.httpClient.open(new URL(uri));
        if (this.headers != null) {
            for (String headerName : this.headers.keySet()) {
                ohc.addRequestProperty(headerName, this.headers.get(headerName));
            }
        }
        if (requestHeaders != null) {
            for (String headerName : requestHeaders.keySet()) {
                ohc.addRequestProperty(headerName, requestHeaders.get(headerName));
            }
        }
        ohc.setConnectTimeout(this.config.getConnectionTimeout());
        ohc.setReadTimeout(this.config.getRequestTimeout());
        return ohc;
    }

    @Override
    public void close() {
    }

    class ResponseAdapter
    implements Response {
        HttpURLConnection conn;

        ResponseAdapter(HttpURLConnection conn) {
            this.conn = conn;
        }

        @Override
        public int getStatusCode() throws IOException {
            return this.conn.getResponseCode();
        }

        @Override
        public String getStatusMessage() throws IOException {
            return this.conn.getResponseMessage();
        }

        @Override
        public String getHeader(String name) {
            return this.conn.getHeaderField(name);
        }

        @Override
        public Map<String, List<String>> getHeaders() {
            return this.conn.getHeaderFields();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.conn.getInputStream();
        }
    }
}

