/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class JSmoothProgressBar
extends JComponent {
    private static Color darkProgressDefault = new Color(110, 110, 160);
    private static Color backProgressDefault = new Color(156, 154, 206);
    private static Color lightProgressDefault = new Color(196, 200, 240);
    private int off_x = 0;
    private int off_y = 0;
    private float currentValue = 0.0f;
    private float maxValue = 100.0f;
    private boolean stringPaint;
    private Color darkProgress = darkProgressDefault;
    private Color backProgress = backProgressDefault;
    private Color lightProgress = lightProgressDefault;
    private Insets borderMargin;
    private int ascent;
    private int[] dgSize;
    private int prSize;
    private int totalSize;
    private int[] digit;
    private double ratio;

    public JSmoothProgressBar() {
        this.setBackground(new Color(206, 206, 206));
        this.setForeground(backProgressDefault);
        this.setFont(new Font("Dialog", 1, 12));
        this.stringPaint = false;
        this.setOpaque(true);
        this.setBorder(BorderFactory.createBevelBorder(1));
        this.updateDigit();
    }

    public void setProgressBarColors(Color back, Color light, Color dark) {
        this.darkProgress = dark;
        this.lightProgress = light;
        this.backProgress = back;
    }

    @Override
    public void setBorder(Border b) {
        super.setBorder(b);
        this.borderMargin = b == null ? new Insets(0, 0, 0, 0) : this.getBorder().getBorderInsets(this);
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.dgSize = new int[10];
        int i = 0;
        while (i < 10) {
            this.dgSize[i] = ATKGraphicsUtils.measureString((String)Integer.toString((int)i), (Font)f).width + 1;
            ++i;
        }
        this.prSize = ATKGraphicsUtils.measureString((String)"%", (Font)f).width;
        this.ascent = (int)((double)ATKGraphicsUtils.getLineMetrics("100%", f).getAscent() + 0.5);
    }

    public void setValue(int v) {
        this.currentValue = (float)v >= this.maxValue ? this.maxValue : (float)v;
        this.updateDigit();
        this.repaint();
    }

    public int getValue() {
        return (int)this.currentValue;
    }

    public void setMaximum(int v) {
        this.maxValue = v;
        if (this.maxValue <= this.currentValue) {
            this.currentValue = this.maxValue;
        }
        this.updateDigit();
        this.repaint();
    }

    public int getMaximum() {
        return (int)this.maxValue;
    }

    public void setIndeterminate(boolean b) {
    }

    public void setStringPainted(boolean b) {
        this.stringPaint = b;
        this.repaint();
    }

    public void setValueOffsets(int x, int y) {
        this.off_x = x;
        this.off_y = y;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        int wr = w - (this.borderMargin.left + this.borderMargin.right + 1);
        int hr = h - (this.borderMargin.bottom + this.borderMargin.top + 1);
        g.setColor(this.getBackground());
        g.fillRect(0, 0, w, h);
        int bpos = (int)Math.rint((double)wr * this.ratio);
        g.setColor(this.backProgress);
        g.fillRect(this.borderMargin.left, this.borderMargin.top, bpos, hr);
        g.setColor(this.lightProgress);
        g.drawLine(this.borderMargin.left, this.borderMargin.top, this.borderMargin.left + bpos, this.borderMargin.top);
        g.drawLine(this.borderMargin.left, this.borderMargin.top, this.borderMargin.left, this.borderMargin.top + hr);
        g.setColor(this.darkProgress);
        g.drawLine(this.borderMargin.left + bpos, this.borderMargin.top, this.borderMargin.left + bpos, this.borderMargin.top + hr);
        g.drawLine(this.borderMargin.left + bpos, this.borderMargin.top + hr, this.borderMargin.left, this.borderMargin.top + hr);
        if (this.stringPaint) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            int xpos = (w - this.totalSize) / 2 + this.off_x;
            int ypos = (hr + this.ascent) / 2 + this.off_y + this.borderMargin.top;
            int sum = 0;
            g.setFont(this.getFont());
            int i = 0;
            while (i < this.digit.length) {
                g.setColor(this.selectColor(xpos + sum + this.dgSize[this.digit[i]] / 3 > bpos));
                g.drawString(Integer.toString(this.digit[i]), xpos + sum, ypos);
                sum += this.dgSize[this.digit[i]];
                ++i;
            }
            g.setColor(this.selectColor(xpos + sum + this.prSize / 3 > bpos));
            g.drawString("%", xpos + sum, ypos);
        }
        this.paintBorder(g);
    }

    private Color selectColor(boolean getFg) {
        if (getFg) {
            return this.getForeground();
        }
        return this.getBackground();
    }

    private void updateDigit() {
        this.ratio = (double)(this.currentValue / this.maxValue) + 1.0E-4;
        if (this.ratio < 0.0) {
            this.ratio = 0.0;
        }
        if (this.ratio > 1.0) {
            this.ratio = 1.0;
        }
        if (Double.isNaN(this.ratio)) {
            this.ratio = 0.0;
        }
        int c = (int)this.ratio;
        int d = (int)(this.ratio * 10.0) % 10;
        int u = (int)(this.ratio * 100.0) % 10;
        if (c == 0) {
            if (d == 0) {
                this.digit = new int[1];
                this.digit[0] = u;
            } else {
                this.digit = new int[2];
                this.digit[0] = d;
                this.digit[1] = u;
            }
        } else {
            this.digit = new int[3];
            this.digit[0] = c;
            this.digit[1] = d;
            this.digit[2] = u;
        }
        this.totalSize = this.prSize;
        int i = 0;
        while (i < this.digit.length) {
            this.totalSize += this.dgSize[this.digit[i]];
            ++i;
        }
    }
}

