/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator.java.projects;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import fr.esrf.tango.pogo.generator.cpp.utils.Headers;
import fr.esrf.tango.pogo.generator.java.JavaUtils;
import fr.esrf.tango.pogo.pogoDsl.ClassDescription;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class LinuxMakefile
implements IGenerator {
    @Inject
    @Extension
    private Headers _headers;
    @Inject
    @Extension
    private JavaUtils _javaUtils;

    @Override
    public void doGenerate(Resource resource, IFileSystemAccess fsa) {
        TreeIterator<EObject> _allContents = resource.getAllContents();
        Iterable<EObject> _iterable = IteratorExtensions.toIterable(_allContents);
        Iterable<PogoDeviceClass> _filter = Iterables.filter(_iterable, PogoDeviceClass.class);
        for (PogoDeviceClass cls : _filter) {
            ClassDescription _description_1;
            String _filestogenerate;
            boolean _contains;
            ClassDescription _description = cls.getDescription();
            String _language = _description.getLanguage();
            String _lowerCase = _language.toLowerCase();
            boolean _equals = _lowerCase.equals("java");
            if (!_equals || !(_contains = (_filestogenerate = (_description_1 = cls.getDescription()).getFilestogenerate()).contains("Makefile"))) continue;
            CharSequence _generateLinuxMakefile = this.generateLinuxMakefile(cls);
            fsa.generateFile("Makefile", _generateLinuxMakefile);
        }
    }

    public CharSequence generateLinuxMakefile(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = cls.getName();
        CharSequence _makefileHeader = this._headers.makefileHeader(_name, false);
        _builder.append((Object)_makefileHeader, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#=============================================================================");
        _builder.newLine();
        _builder.append("# PACKAGE_NAME is the name of the library/device/exe you want to build");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("CLASS\t     = ");
        String _name_1 = cls.getName();
        _builder.append((Object)_name_1, "");
        _builder.newLineIfNotEmpty();
        _builder.append("PACKAGE_NAME = ");
        String _javaDevicePackage = this._javaUtils.javaDevicePackage(cls);
        _builder.append((Object)_javaDevicePackage, "");
        _builder.newLineIfNotEmpty();
        _builder.append("SOURCE_FILES = ");
        String _javaDeviceSourceFile = this._javaUtils.javaDeviceSourceFile(cls);
        _builder.append((Object)_javaDeviceSourceFile, "");
        _builder.newLineIfNotEmpty();
        _builder.append("MAJOR_VERS   = 1");
        _builder.newLine();
        _builder.append("MINOR_VERS   = 0");
        _builder.newLine();
        _builder.append("RELEASE      = Release_$(MAJOR_VERS)_$(MINOR_VERS)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("INSTANCE     = test");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("#=============================================================================");
        _builder.newLine();
        _builder.append("#\t\tThe compiler flags");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("JAVAC = javac -classpath .:$(CLASSPATH)");
        _builder.newLine();
        _builder.append("BIN_DIR = ./bin");
        _builder.newLine();
        _builder.append("JAVAFLAGS = -d $(BIN_DIR)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#=============================================================================");
        _builder.newLine();
        _builder.append("# Rulee to compile");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append(".SUFFIXES:\t.class .java");
        _builder.newLine();
        _builder.append(".java.class:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("$(JAVAC) $(JAVAFLAGS) $<");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("#=============================================================================");
        _builder.newLine();
        _builder.append("# Class list of objects needed to make the output");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("all:\tclasses");
        _builder.newLine();
        _builder.append("classes:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("$(JAVAC) $(JAVAFLAGS) $(SOURCE_FILES)/*.java");
        _builder.newLine();
        _builder.newLine();
        _builder.append("run:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("java $(PACKAGE_NAME)/$(CLASS)  $(INSTANCE)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#=============================================================================");
        _builder.newLine();
        _builder.append("# Jar file generation");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("JAR_NAME = ");
        String _name_2 = cls.getName();
        String _lowerCase = _name_2.toLowerCase();
        _builder.append((Object)_lowerCase, "");
        _builder.append("-$(MAJOR_VERS).$(MINOR_VERS).jar");
        _builder.newLineIfNotEmpty();
        _builder.append("jar:\tclasses");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("cd $(BIN_DIR); jar cvf  $(JAR_NAME) $(SOURCE_FILES)/*.class");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("mv $(BIN_DIR)/$(JAR_NAME) .");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ls -l $(JAR_NAME)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#=============================================================================");
        _builder.newLine();
        _builder.append("# Java doc generation");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("doc:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("javadoc -d documentation -windowtitle $(PACKAGE_NAME).$(CLASS) \\");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("-private -version -author -nodeprecated -header \"$(PACKAGE_NAME).$(CLASS) Class\"\t\\");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("$(SOURCE_FILES)/*.java");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#=============================================================================");
        _builder.newLine();
        _builder.append("# remove class files");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("clean:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("rm $(BIN_DIR)/$(SOURCE_FILES)/*.class");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }
}

