/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator.java;

import com.google.inject.Inject;
import fr.esrf.tango.pogo.generator.common.StringUtils;
import fr.esrf.tango.pogo.generator.java.JavaUtils;
import fr.esrf.tango.pogo.generator.java.ProtectedArea;
import fr.esrf.tango.pogo.pogoDsl.AttrProperties;
import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.ForwardedAttribute;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.Type;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

public class JavaAttribute {
    @Inject
    @Extension
    private JavaUtils _javaUtils;
    @Inject
    @Extension
    private ProtectedArea _protectedArea;

    public CharSequence attributeMethods(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        EList<Attribute> _attributes = cls.getAttributes();
        for (Attribute attribute : _attributes) {
            boolean _isConcreteHere = this._javaUtils.isConcreteHere(attribute);
            if (!_isConcreteHere) continue;
            CharSequence _declareAttributeMember = this.declareAttributeMember(cls, attribute);
            _builder.append((Object)_declareAttributeMember, "");
            _builder.newLineIfNotEmpty();
            CharSequence _method = this.getMethod(cls, attribute);
            _builder.append((Object)_method, "");
            _builder.newLineIfNotEmpty();
            String _rwType = attribute.getRwType();
            boolean _contains = _rwType.contains("WRITE");
            if (_contains) {
                CharSequence _setMethod = this.setMethod(cls, attribute);
                _builder.append((Object)_setMethod, "");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence declareAttributeMember(PogoDeviceClass cls, Attribute attribute) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Attribute ");
        String _name = attribute.getName();
        _builder.append((Object)_name, " ");
        _builder.append(", ");
        String _strJavaType = this._javaUtils.strJavaType(attribute);
        _builder.append((Object)_strJavaType, " ");
        _builder.append(", ");
        String _attType = attribute.getAttType();
        _builder.append((Object)_attType, " ");
        _builder.append(", ");
        String _rwType = attribute.getRwType();
        _builder.append((Object)_rwType, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* description:");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*     ");
        AttrProperties _properties = attribute.getProperties();
        String _description = _properties.getDescription();
        String _comments = StringUtils.comments(_description, "*     ");
        _builder.append((Object)_comments, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        Type _dataType = attribute.getDataType();
        String _string = _dataType.toString();
        boolean _contains = _string.contains("Enum");
        if (_contains) {
            String _buildEnum = this._javaUtils.buildEnum(attribute);
            _builder.append((Object)_buildEnum, "");
            _builder.newLineIfNotEmpty();
        }
        String _declareParameters = this._javaUtils.declareParameters(attribute);
        _builder.append((Object)_declareParameters, "");
        _builder.newLineIfNotEmpty();
        String _declareProperties = this._javaUtils.declareProperties(attribute);
        _builder.append((Object)_declareProperties, "");
        _builder.newLineIfNotEmpty();
        String _stateMachine = this._javaUtils.stateMachine(attribute);
        _builder.append((Object)_stateMachine, "");
        _builder.newLineIfNotEmpty();
        _builder.append("private ");
        String _strFullJavaType = this._javaUtils.strFullJavaType(attribute);
        _builder.append((Object)_strFullJavaType, "");
        _builder.append(" ");
        String _name_1 = attribute.getName();
        String _dataMemberName = this._javaUtils.dataMemberName(_name_1);
        _builder.append((Object)_dataMemberName, "");
        String _allocation = this._javaUtils.allocation(attribute);
        _builder.append((Object)_allocation, "");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence getMethod(PogoDeviceClass cls, Attribute attribute) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Read attribute ");
        String _name = attribute.getName();
        _builder.append((Object)_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* ");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @return attribute value");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @throws DevFailed if read attribute failed.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        Type _dataType = attribute.getDataType();
        String _string = _dataType.toString();
        boolean _contains = _string.contains("Enum");
        if (_contains) {
            _builder.append("public ");
            String _strFullJavaType = this._javaUtils.strFullJavaType(attribute);
            _builder.append((Object)_strFullJavaType, "");
            _builder.append(" ");
            String _attributeMethodName = JavaUtils.attributeMethodName(attribute, true);
            _builder.append((Object)_attributeMethodName, "");
            _builder.append("() throws DevFailed {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("xlogger.entry();");
            _builder.newLine();
            _builder.append("\t");
            String _name_1 = attribute.getName();
            String _plus = "get" + _name_1;
            String _protectedArea = this._protectedArea.protectedArea(cls, _plus, "Put read attribute code here", true);
            _builder.append((Object)_protectedArea, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("xlogger.exit();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("return ");
            String _name_2 = attribute.getName();
            String _dataMemberName = this._javaUtils.dataMemberName(_name_2);
            _builder.append((Object)_dataMemberName, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        } else {
            _builder.append("public org.tango.server.attribute.AttributeValue ");
            String _attributeMethodName_1 = JavaUtils.attributeMethodName(attribute, true);
            _builder.append((Object)_attributeMethodName_1, "");
            _builder.append("() throws DevFailed {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("xlogger.entry();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("org.tango.server.attribute.AttributeValue");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("attributeValue = new org.tango.server.attribute.AttributeValue();");
            _builder.newLine();
            _builder.append("\t");
            String _name_3 = attribute.getName();
            String _plus_1 = "get" + _name_3;
            String _protectedArea_1 = this._protectedArea.protectedArea(cls, _plus_1, "Put read attribute code here", true);
            _builder.append((Object)_protectedArea_1, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("attributeValue.setValue(");
            String _name_4 = attribute.getName();
            String _dataMemberName_1 = this._javaUtils.dataMemberName(_name_4);
            _builder.append((Object)_dataMemberName_1, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("xlogger.exit();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("return attributeValue;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence setMethod(PogoDeviceClass cls, Attribute attribute) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Write attribute ");
        String _name = attribute.getName();
        _builder.append((Object)_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* @param  ");
        String _name_1 = attribute.getName();
        String _dataMemberName = this._javaUtils.dataMemberName(_name_1);
        _builder.append((Object)_dataMemberName, " ");
        _builder.append(" value to write");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* @throws DevFailed if write attribute failed.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("public void ");
        String _attributeMethodName = JavaUtils.attributeMethodName(attribute, false);
        _builder.append((Object)_attributeMethodName, "");
        _builder.append("(");
        String _strFullJavaType = this._javaUtils.strFullJavaType(attribute);
        _builder.append((Object)_strFullJavaType, "");
        _builder.append(" ");
        String _name_2 = attribute.getName();
        String _dataMemberName_1 = this._javaUtils.dataMemberName(_name_2);
        _builder.append((Object)_dataMemberName_1, "");
        _builder.append(") throws DevFailed {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("xlogger.entry();");
        _builder.newLine();
        _builder.append("\t");
        String _name_3 = attribute.getName();
        String _plus = "set" + _name_3;
        String _name_4 = attribute.getName();
        String _dataMemberName_2 = this._javaUtils.dataMemberName(_name_4);
        String _plus_1 = "this." + _dataMemberName_2;
        String _plus_2 = String.valueOf(_plus_1) + " = ";
        String _name_5 = attribute.getName();
        String _dataMemberName_3 = this._javaUtils.dataMemberName(_name_5);
        String _plus_3 = String.valueOf(_plus_2) + _dataMemberName_3;
        String _plus_4 = String.valueOf(_plus_3) + ";";
        String _protectedArea = this._protectedArea.protectedArea(cls, _plus, _plus_4, false);
        _builder.append((Object)_protectedArea, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("xlogger.exit();");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence addForwardedAttributes(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*\tAdd forwarded attributes");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("private void addForwardedAttributes() throws DevFailed {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("xlogger.entry();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//\tDon't forget to set attribute __root_att properties");
        _builder.newLine();
        EList<ForwardedAttribute> _forwardedAttributes = cls.getForwardedAttributes();
        for (ForwardedAttribute attribute : _forwardedAttributes) {
            _builder.append("\t");
            _builder.append("dynamicManager.addAttribute(new ForwardedAttribute(null, \"");
            String _name = attribute.getName();
            _builder.append((Object)_name, "\t");
            _builder.append("\", \"");
            String _label = attribute.getLabel();
            _builder.append((Object)_label, "\t");
            _builder.append("\"));");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("xlogger.exit();");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }
}

