/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator.html;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import fr.esrf.tango.pogo.generator.common.StringUtils;
import fr.esrf.tango.pogo.generator.html.HtmlAttributes;
import fr.esrf.tango.pogo.generator.html.HtmlCommands;
import fr.esrf.tango.pogo.generator.html.HtmlUtils;
import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.ClassDescription;
import fr.esrf.tango.pogo.pogoDsl.ClassIdentification;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.Property;
import fr.esrf.tango.pogo.pogoDsl.State;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class HtmlDescription
implements IGenerator {
    @Inject
    @Extension
    private HtmlUtils _htmlUtils;
    @Inject
    @Extension
    private HtmlCommands _htmlCommands;
    @Inject
    @Extension
    private HtmlAttributes _htmlAttributes;

    @Override
    public void doGenerate(Resource resource, IFileSystemAccess fsa) {
        TreeIterator<EObject> _allContents = resource.getAllContents();
        Iterable<EObject> _iterable = IteratorExtensions.toIterable(_allContents);
        Iterable<PogoDeviceClass> _filter = Iterables.filter(_iterable, PogoDeviceClass.class);
        for (PogoDeviceClass cls : _filter) {
            ClassDescription _description = cls.getDescription();
            String _filestogenerate = _description.getFilestogenerate();
            boolean _contains = _filestogenerate.contains("html");
            if (!_contains) continue;
            StringUtils.printTrace("Generating doc_html/ClassDescription.html");
            CharSequence _generateHtmlDescriptionFile = this.generateHtmlDescriptionFile(cls, true);
            fsa.generateFile("doc_html/ClassDescription.html", _generateHtmlDescriptionFile);
            StringUtils.printTrace("Generating doc_html/Properties.html");
            CharSequence _generateHtmlPropertiesFile = this.generateHtmlPropertiesFile(cls, true);
            fsa.generateFile("doc_html/Properties.html", _generateHtmlPropertiesFile);
            StringUtils.printTrace("Generating doc_html/States.html");
            CharSequence _generateHtmlStatesFile = this.generateHtmlStatesFile(cls, true);
            fsa.generateFile("doc_html/States.html", _generateHtmlStatesFile);
            StringUtils.printTrace("Generating doc_html/FullDocument.html");
            CharSequence _generateHtmlFullDocumentFile = this.generateHtmlFullDocumentFile(cls);
            fsa.generateFile("doc_html/FullDocument.html", _generateHtmlFullDocumentFile);
            StringUtils.printTrace("Try to manage Documentation.html from pogo-6 if any");
            this._htmlUtils.retrieveProtectedDescriptionPart(cls);
        }
    }

    public CharSequence generateHtmlDescriptionFile(PogoDeviceClass cls, boolean withHeader) {
        StringConcatenation _builder = new StringConcatenation();
        if (withHeader) {
            String _htmlFileHeader = this._htmlUtils.htmlFileHeader(cls, "Description");
            _builder.append((Object)_htmlFileHeader, "");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("<ul>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<br><br><br>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<table border=\"0\" width=\"100%\">");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<Tr>");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("<td> ");
        String _name = cls.getName();
        String _plus = String.valueOf(_name) + " Class Identification :";
        String _htmlTitle = this._htmlUtils.htmlTitle(_plus);
        _builder.append((Object)_htmlTitle, "\t\t\t");
        _builder.append(" </td>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("<td> ");
        String _name_1 = cls.getName();
        String _plus_1 = String.valueOf(_name_1) + " Class Inheritance :";
        String _htmlTitle_1 = this._htmlUtils.htmlTitle(_plus_1);
        _builder.append((Object)_htmlTitle_1, "\t\t\t");
        _builder.append(" </td>");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("</tr>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<td><ul>");
        _builder.newLine();
        ClassDescription _description = cls.getDescription();
        ClassIdentification _identification = _description.getIdentification();
        boolean _equals = Objects.equal(_identification, null);
        if (_equals) {
            _builder.append("\t\t\t");
            _builder.append("Class has no identification card !");
            _builder.newLine();
        } else {
            _builder.append("\t\t\t");
            _builder.append("<table border=\"0\">");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("<Tr>");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("\t\t");
            _builder.append("<td> Contact </td><td> : at ");
            ClassDescription _description_1 = cls.getDescription();
            ClassIdentification _identification_1 = _description_1.getIdentification();
            String _htmlIdContact = this._htmlUtils.htmlIdContact(_identification_1);
            _builder.append((Object)_htmlIdContact, "\t\t\t\t\t");
            _builder.append("</td>");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("</tr>");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("<tr>");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("\t\t");
            _builder.append("<td> Class Family </td><td> : ");
            ClassDescription _description_2 = cls.getDescription();
            ClassIdentification _identification_2 = _description_2.getIdentification();
            String _htmlClassFamily = this._htmlUtils.htmlClassFamily(_identification_2);
            _builder.append((Object)_htmlClassFamily, "\t\t\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("</tr>");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("<tr>");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("\t\t");
            _builder.append("<td> Platform </td><td> : ");
            ClassDescription _description_3 = cls.getDescription();
            ClassIdentification _identification_3 = _description_3.getIdentification();
            String _platform = _identification_3.getPlatform();
            _builder.append((Object)_platform, "\t\t\t\t\t");
            _builder.append(" </td>");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("</tr>");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("<tr>");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("\t\t");
            _builder.append("<td> Bus </td><td> : ");
            ClassDescription _description_4 = cls.getDescription();
            ClassIdentification _identification_4 = _description_4.getIdentification();
            String _bus = _identification_4.getBus();
            _builder.append((Object)_bus, "\t\t\t\t\t");
            _builder.append(" </td>");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("</tr>");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("<tr>");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("\t\t");
            _builder.append("<td> Manufacturer </td><td> : ");
            ClassDescription _description_5 = cls.getDescription();
            ClassIdentification _identification_5 = _description_5.getIdentification();
            String _manufacturer = _identification_5.getManufacturer();
            _builder.append((Object)_manufacturer, "\t\t\t\t\t");
            _builder.append(" </td>");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("</tr>");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("<tr>");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("\t\t");
            _builder.append("<td> Manufacturer ref.</td><td> : ");
            ClassDescription _description_6 = cls.getDescription();
            ClassIdentification _identification_6 = _description_6.getIdentification();
            String _reference = _identification_6.getReference();
            _builder.append((Object)_reference, "\t\t\t\t\t");
            _builder.append(" </td>");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("</tr>");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("</Table>");
            _builder.newLine();
        }
        _builder.append("\t\t");
        _builder.append("</ul></td>");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<td>");
        _builder.newLine();
        _builder.append("\t\t\t");
        String _htmlInheritance = this._htmlUtils.htmlInheritance(cls);
        _builder.append((Object)_htmlInheritance, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("</td>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("</Table>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<br><br><br>");
        _builder.newLine();
        _builder.append("\t");
        String _name_2 = cls.getName();
        String _plus_2 = String.valueOf(_name_2) + " Class Description :";
        String _htmlTitle_2 = this._htmlUtils.htmlTitle(_plus_2);
        _builder.append((Object)_htmlTitle_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("<br><br>");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("<ul>");
        _builder.newLine();
        _builder.append("\t\t");
        ClassDescription _description_7 = cls.getDescription();
        String _description_8 = _description_7.getDescription();
        String _checkSpecialChars = HtmlUtils.checkSpecialChars(_description_8);
        String _htmlStringWithBreak = this._htmlUtils.htmlStringWithBreak(_checkSpecialChars);
        _builder.append((Object)_htmlStringWithBreak, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        String _addDescriptionFromPogo6IfExists = this._htmlUtils.addDescriptionFromPogo6IfExists(cls);
        _builder.append((Object)_addDescriptionFromPogo6IfExists, "\t\t");
        _builder.newLineIfNotEmpty();
        if (withHeader) {
            _builder.append("\t\t");
            _builder.append("<!---  /*PROTECTED REGION ID(index.html) ENABLED START*/  --->");
            _builder.newLine();
        } else {
            _builder.append("\t\t");
            _builder.append("<!---  /*PROTECTED REGION ID(FullDocument.html) ENABLED START*/  --->");
            _builder.newLine();
        }
        _builder.append("\t\t\t");
        _builder.append("<!--- Add your own documentation, pictures, links,.... --->");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("<!---  /*PROTECTED REGION END*/  --->");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("</ul>");
        _builder.newLine();
        _builder.append("</ul>");
        _builder.newLine();
        if (withHeader) {
            _builder.append("</body>");
            _builder.newLine();
            _builder.append("</html>");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence generateHtmlPropertiesFile(PogoDeviceClass cls, boolean withHeader) {
        StringConcatenation _builder = new StringConcatenation();
        if (withHeader) {
            String _htmlFileHeader = this._htmlUtils.htmlFileHeader(cls, "Properties");
            _builder.append((Object)_htmlFileHeader, "");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("<br><br><br>");
        _builder.newLine();
        String _name = cls.getName();
        String _plus = String.valueOf(_name) + "  Properties :";
        String _htmlTitle = this._htmlUtils.htmlTitle(_plus);
        _builder.append((Object)_htmlTitle, "");
        _builder.newLineIfNotEmpty();
        _builder.append("<br><br><br>");
        _builder.newLine();
        EList<Property> _classProperties = cls.getClassProperties();
        String _htmlPropertyTable = this._htmlUtils.htmlPropertyTable(_classProperties, "Class Properties");
        _builder.append((Object)_htmlPropertyTable, "");
        _builder.newLineIfNotEmpty();
        _builder.append("<br><br><br>");
        _builder.newLine();
        EList<Property> _deviceProperties = cls.getDeviceProperties();
        String _htmlPropertyTable_1 = this._htmlUtils.htmlPropertyTable(_deviceProperties, "Device Properties");
        _builder.append((Object)_htmlPropertyTable_1, "");
        _builder.newLineIfNotEmpty();
        if (withHeader) {
            _builder.append("</body>");
            _builder.newLine();
            _builder.append("</html>");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence generateHtmlStatesFile(PogoDeviceClass cls, boolean withHeader) {
        StringConcatenation _builder = new StringConcatenation();
        if (withHeader) {
            String _htmlFileHeader = this._htmlUtils.htmlFileHeader(cls, "States");
            _builder.append((Object)_htmlFileHeader, "");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("<br><br><br><br>");
        _builder.newLine();
        EList<State> _states = cls.getStates();
        String _name = cls.getName();
        String _htmlStatesTable = this._htmlUtils.htmlStatesTable(_states, _name);
        _builder.append((Object)_htmlStatesTable, "");
        _builder.newLineIfNotEmpty();
        if (withHeader) {
            _builder.append("</body>");
            _builder.newLine();
            _builder.append("</html>");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence generateHtmlFullDocumentFile(PogoDeviceClass cls) {
        StringConcatenation _builder = new StringConcatenation();
        String _htmlFileHeader = this._htmlUtils.htmlFileHeader(cls);
        _builder.append((Object)_htmlFileHeader, "");
        _builder.newLineIfNotEmpty();
        String _generateHtmlTangoBannerFile = HtmlUtils.generateHtmlTangoBannerFile();
        _builder.append((Object)_generateHtmlTangoBannerFile, "");
        _builder.newLineIfNotEmpty();
        _builder.append("<hr>");
        _builder.newLine();
        _builder.append("<br>");
        _builder.newLine();
        String _htmlFullDocummentTitleAndContents = this._htmlUtils.htmlFullDocummentTitleAndContents(cls);
        _builder.append((Object)_htmlFullDocummentTitleAndContents, "");
        _builder.newLineIfNotEmpty();
        _builder.append("<br><br>");
        _builder.newLine();
        _builder.append("<a name=\"description\"> </a>");
        _builder.newLine();
        CharSequence _generateHtmlDescriptionFile = this.generateHtmlDescriptionFile(cls, false);
        _builder.append((Object)_generateHtmlDescriptionFile, "");
        _builder.newLineIfNotEmpty();
        _builder.append("<br><br>");
        _builder.newLine();
        _builder.append("<hr>");
        _builder.newLine();
        _builder.append("<a name=\"properties\"> </a>");
        _builder.newLine();
        CharSequence _generateHtmlPropertiesFile = this.generateHtmlPropertiesFile(cls, false);
        _builder.append((Object)_generateHtmlPropertiesFile, "");
        _builder.newLineIfNotEmpty();
        _builder.append("<br><br>");
        _builder.newLine();
        _builder.append("<hr>");
        _builder.newLine();
        _builder.append("<a name=\"commands\"> </a>");
        _builder.newLine();
        CharSequence _generateHtmlCommandsFile = this._htmlCommands.generateHtmlCommandsFile(cls, false);
        _builder.append((Object)_generateHtmlCommandsFile, "");
        _builder.newLineIfNotEmpty();
        EList<Command> _commands = cls.getCommands();
        for (Command command : _commands) {
            _builder.append("<br><br><hr>");
            _builder.newLine();
            _builder.append("<a name=\"cmd");
            String _name = command.getName();
            _builder.append((Object)_name, "");
            _builder.append("\"> </a>");
            _builder.newLineIfNotEmpty();
            CharSequence _generateHtmlOneCommandFile = this._htmlCommands.generateHtmlOneCommandFile(cls, command, false);
            _builder.append((Object)_generateHtmlOneCommandFile, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("<br><br>");
        _builder.newLine();
        _builder.append("<hr>");
        _builder.newLine();
        _builder.append("<a name=\"attributes\"> </a>");
        _builder.newLine();
        CharSequence _generateHtmlAttributesFile = this._htmlAttributes.generateHtmlAttributesFile(cls, false);
        _builder.append((Object)_generateHtmlAttributesFile, "");
        _builder.newLineIfNotEmpty();
        EList<Attribute> _attributes = cls.getAttributes();
        for (Attribute attribute : _attributes) {
            _builder.append("<br><br>");
            _builder.newLine();
            _builder.append("<hr>");
            _builder.newLine();
            _builder.append("<a name=\"attr");
            String _name_1 = attribute.getName();
            _builder.append((Object)_name_1, "");
            _builder.append("\"> </a>");
            _builder.newLineIfNotEmpty();
            CharSequence _generateHtmlOneAttributeFile = this._htmlAttributes.generateHtmlOneAttributeFile(cls, attribute, false);
            _builder.append((Object)_generateHtmlOneAttributeFile, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("<br><br>");
        _builder.newLine();
        _builder.append("<hr>");
        _builder.newLine();
        EList<Attribute> _dynamicAttributes = cls.getDynamicAttributes();
        for (Attribute attribute_1 : _dynamicAttributes) {
            _builder.append("<br><br>");
            _builder.newLine();
            _builder.append("<hr>");
            _builder.newLine();
            _builder.append("<a name=\"attr");
            String _name_2 = attribute_1.getName();
            _builder.append((Object)_name_2, "");
            _builder.append("\"> </a>");
            _builder.newLineIfNotEmpty();
            CharSequence _generateHtmlOneAttributeFile_1 = this._htmlAttributes.generateHtmlOneAttributeFile(cls, attribute_1, false);
            _builder.append((Object)_generateHtmlOneAttributeFile_1, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("<br><br>");
        _builder.newLine();
        _builder.append("<hr>");
        _builder.newLine();
        _builder.append("<a name=\"states\"> </a>");
        _builder.newLine();
        CharSequence _generateHtmlStatesFile = this.generateHtmlStatesFile(cls, false);
        _builder.append((Object)_generateHtmlStatesFile, "");
        _builder.newLineIfNotEmpty();
        _builder.append("</body>");
        _builder.newLine();
        _builder.append("</html>");
        _builder.newLine();
        return _builder;
    }
}

